/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;

public abstract class CircularDivisionRenderer<F> {
    protected final Random rand = new Random();
    public boolean squareRender = false;
    protected double centerX;
    protected double centerY;
    protected double renderRadius;
    protected double renderOrigin;
    protected double innerRadius;
    private final HashMap<F, ColorCallback> renderColors = new HashMap();
    private final HashMap<F, Integer> entryColors = new HashMap();
    private int currentDefaultColorIndex = 0;
    private static ArrayList<Integer> defaultColors = new ArrayList();

    public abstract Collection<F> getElements();

    public abstract void clear();

    public abstract F getClickedSection(int var1, int var2);

    public final void addColorRenderer(F type, ColorCallback call) {
        this.renderColors.put(type, call);
    }

    public final void setGeometry(double x, double y, double r, double zeroAng) {
        this.setGeometry(x, y, r, 0.0, zeroAng);
    }

    public final void setGeometry(double x, double y, double r, double ir, double zeroAng) {
        this.centerX = x;
        this.centerY = y;
        this.renderRadius = r;
        this.innerRadius = ir;
        this.renderOrigin = zeroAng;
    }

    @SideOnly(value=Side.CLIENT)
    public final void render() {
        this.render(null);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void render(Map<F, Integer> var1);

    public final void resetColors() {
        this.entryColors.clear();
    }

    protected final int getColorForElement(F o, Map<F, Integer> colorMap) {
        if (this.entryColors.isEmpty()) {
            this.calculateEntryColors(colorMap);
        }
        return this.entryColors.get(o);
    }

    private final void calculateEntryColors(Map<F, Integer> colorMap) {
        if (this.entryColors.isEmpty()) {
            this.currentDefaultColorIndex = 0;
            for (F o : this.getElements()) {
                this.entryColors.put(o, this.calcColorForElement(o, colorMap));
            }
        }
    }

    private final int calcColorForElement(F o, Map<F, Integer> colorMap) {
        int c = 0;
        if (colorMap != null && colorMap.containsKey(o)) {
            c = colorMap.get(o);
        } else {
            ColorCallback call = this.renderColors.get(o);
            if (call != null) {
                c = call.getColor(o);
            } else {
                if (this.currentDefaultColorIndex >= defaultColors.size()) {
                    int newcolor = ReikaColorAPI.RGBtoHex(this.rand.nextInt(255), this.rand.nextInt(255), this.rand.nextInt(255));
                    defaultColors.add(newcolor);
                    c = newcolor;
                } else {
                    c = defaultColors.get(this.currentDefaultColorIndex);
                }
                ++this.currentDefaultColorIndex;
            }
        }
        return c;
    }

    protected final void renderSection(Tessellator v5, double ang1, double ang2) {
        if (this.innerRadius == 0.0) {
            v5.func_78377_a(this.centerX, this.centerY, 0.0);
            for (double d = ang1; d <= ang2; d += 0.25) {
                double d2 = Math.toRadians(d);
                double r2 = this.getOuterRadiusAt(d2);
                double dx = this.centerX + r2 * Math.cos(d2);
                double dy = this.centerY + r2 * Math.sin(d2);
                v5.func_78377_a(dx, dy, 0.0);
            }
            double d2 = Math.toRadians(ang2);
            double r2 = this.getOuterRadiusAt(d2);
            double dx = this.centerX + r2 * Math.cos(d2);
            double dy = this.centerY + r2 * Math.sin(d2);
            v5.func_78377_a(dx, dy, 0.0);
        } else {
            for (double d = ang1; d <= ang2; d += 0.25) {
                double d2 = Math.toRadians(d);
                double r1 = this.getInnerRadiusAt(d2);
                double r2 = this.getOuterRadiusAt(d2);
                double dx1 = this.centerX + r1 * Math.cos(d2);
                double dy1 = this.centerY + r1 * Math.sin(d2);
                double dx2 = this.centerX + r2 * Math.cos(d2);
                double dy2 = this.centerY + r2 * Math.sin(d2);
                v5.func_78377_a(dx1, dy1, 0.0);
                v5.func_78377_a(dx2, dy2, 0.0);
            }
        }
    }

    public final double getInnerRadiusAt(double ang) {
        if (this.squareRender) {
            return this.innerRadius * Math.min(Math.abs(1.0 / Math.cos(ang)), Math.abs(1.0 / Math.sin(ang)));
        }
        return this.innerRadius;
    }

    public final double getOuterRadiusAt(double ang) {
        if (this.squareRender) {
            return this.renderRadius * Math.min(Math.abs(1.0 / Math.cos(ang)), Math.abs(1.0 / Math.sin(ang)));
        }
        return this.renderRadius;
    }

    static {
        defaultColors.add(0xFF0000);
        defaultColors.add(65280);
        defaultColors.add(255);
        defaultColors.add(0xFFFF00);
        defaultColors.add(0xFF00FF);
        defaultColors.add(65535);
        defaultColors.add(0xA0A0A0);
    }

    public static class IntColorCallback
    implements ColorCallback {
        public final int color;

        public IntColorCallback(int c) {
            this.color = c;
        }

        @Override
        public int getColor(Object key) {
            return this.color;
        }
    }

    public static interface ColorCallback {
        public int getColor(Object var1);
    }
}

