/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Collections;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.InventorySlot;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class InventoryCache {
    private final ItemHashMap<Collection<InventorySlot>> data = new ItemHashMap().enableNBT();
    private final Collection<IInventory> inventories = new HashSet<IInventory>();
    private final ItemHashMap<Collection<IDeepStorageUnit>> dsus = new ItemHashMap().enableNBT();
    @DependentMethodStripper.ModDependent(value={ModList.STORAGEDRAWERS})
    private IDrawerGroup drawers;

    public InventoryCache addInventory(IInventory ii) {
        if (InterfaceCache.DSU.instanceOf(ii)) {
            this.addDSU((IDeepStorageUnit)ii);
        } else {
            if (InterfaceCache.DRAWER.instanceOf(ii)) {
                this.addDrawer((IDrawerGroup)ii);
                return this;
            }
            for (int i = 0; i < ii.func_70302_i_(); ++i) {
                this.addSlot(new InventorySlot(i, ii));
            }
        }
        this.inventories.add(ii);
        return this;
    }

    @DependentMethodStripper.ClassDependent(value="powercrystals.minefactoryreloaded.api.IDeepStorageUnit")
    private void addDSU(IDeepStorageUnit dsu) {
        ItemStack is = dsu.getStoredItemType();
        if (is != null) {
            Collection<IDeepStorageUnit> c = this.dsus.get(is);
            if (c == null) {
                c = new ArrayList<IDeepStorageUnit>();
                this.dsus.put(is, c);
            }
            c.add(dsu);
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.STORAGEDRAWERS})
    private void addDrawer(IDrawerGroup grp) {
        this.drawers = grp;
    }

    public InventoryCache addSlot(InventorySlot slot) {
        ItemStack is = slot.getStack();
        if (is != null) {
            this.addItemToData(is, slot);
        }
        this.inventories.add(slot.inventory);
        return this;
    }

    private void addItemToData(ItemStack is, InventorySlot slot) {
        int has = this.getItemCount(is);
        Collection<InventorySlot> li = this.data.get(is);
        if (li == null) {
            li = new ArrayList<InventorySlot>();
            this.data.put(is, li);
        }
        li.add(slot);
    }

    public boolean hasItem(ItemStack is) {
        return this.data.containsKey(is) || this.dsus.containsKey(is);
    }

    public int addItemsToUnderlyingInventories(ItemStack is, boolean simulate) {
        this.validateInventories();
        int left = is.field_77994_a;
        if (ModList.STORAGEDRAWERS.isLoaded() && this.drawers != null) {
            left -= ReikaInventoryHelper.drawerInventory.addItem(this.drawers, is, false, !simulate);
        }
        for (IInventory ii : this.inventories) {
            left = ReikaInventoryHelper.addToInventoryWithLeftover(is, ii, simulate);
            if (!simulate) {
                is.field_77994_a = left;
            }
            if (left > 0) continue;
            return 0;
        }
        return left;
    }

    /*
     * WARNING - void declaration
     */
    public int getItemCount(ItemStack is) {
        Collection<IDeepStorageUnit> li2;
        int count = 0;
        Collection<InventorySlot> li = this.data.get(is);
        if (li != null) {
            for (InventorySlot inventorySlot : li) {
                if (is.field_77990_d != null && !is.field_77990_d.equals((Object)inventorySlot.getStack().field_77990_d)) continue;
                count += inventorySlot.getStackSize();
            }
        }
        if ((li2 = this.dsus.get(is)) != null) {
            for (IDeepStorageUnit dsu : li2) {
                if (is.field_77990_d != null && !is.field_77990_d.equals((Object)dsu.getStoredItemType().field_77990_d)) continue;
                count += dsu.getStoredItemType().field_77994_a;
            }
        }
        if (ModList.STORAGEDRAWERS.isLoaded() && this.drawers != null) {
            void var5_9;
            boolean bl = false;
            while (var5_9 < this.drawers.getDrawerCount()) {
                IDrawer dwr = this.drawers.getDrawer((int)var5_9);
                ItemStack in = dwr.getStoredItemPrototype();
                if (is.field_77990_d == null || is.field_77990_d.equals((Object)in.field_77990_d)) {
                    count += dwr.getStoredItemCount();
                }
                ++var5_9;
            }
        }
        return count;
    }

    public int removeXItems(ItemStack is, int amt) {
        ItemStack take;
        Collection<IDeepStorageUnit> li2;
        this.validateInventories();
        Collection<InventorySlot> li = this.data.get(is);
        int rem = 0;
        if (li != null) {
            Iterator<InventorySlot> it = li.iterator();
            while (it.hasNext()) {
                InventorySlot slot = it.next();
                if (is.field_77990_d != null && !is.field_77990_d.equals((Object)slot.getStack().field_77990_d)) continue;
                int dec = slot.decrement(amt);
                rem += dec;
                amt -= dec;
                if (slot.isEmpty()) {
                    it.remove();
                }
                if (amt > 0) continue;
                return rem;
            }
        }
        if ((li2 = this.dsus.get(is)) != null) {
            Iterator<IDeepStorageUnit> it = li2.iterator();
            while (it.hasNext()) {
                IDeepStorageUnit dsu = it.next();
                if (is.field_77990_d != null && !is.field_77990_d.equals((Object)dsu.getStoredItemType().field_77990_d)) continue;
                int has = dsu.getStoredItemType().field_77994_a;
                int dec = Math.min(amt, has);
                rem += dec;
                amt -= dec;
                dsu.setStoredItemCount(has - dec);
                if (dsu.getStoredItemType() == null || dsu.getStoredItemType().field_77994_a == 0) {
                    it.remove();
                }
                if (amt > 0) continue;
                return rem;
            }
        }
        if (ModList.STORAGEDRAWERS.isLoaded() && this.drawers != null && (take = ReikaInventoryHelper.drawerInventory.takeItem(this.drawers, new ItemMatch().addItem(new KeyedItemStack(is).setIgnoreNBT(false)), amt, true)) != null) {
            rem += take.field_77994_a;
        }
        return rem;
    }

    private void validateInventories() {
        Iterator<IInventory> it = this.inventories.iterator();
        while (it.hasNext()) {
            IInventory ii = it.next();
            if (!(ii instanceof TileEntity) || !((TileEntity)ii).func_145837_r()) continue;
            it.remove();
            for (Collection<InventorySlot> c2 : this.data.values()) {
                Iterator<InventorySlot> it2 = c2.iterator();
                while (it2.hasNext()) {
                    InventorySlot s = it2.next();
                    if (s.inventory != ii) continue;
                    it2.remove();
                }
            }
        }
    }

    public void clear() {
        this.data.clear();
        this.inventories.clear();
        this.dsus.clear();
        if (ModList.STORAGEDRAWERS.isLoaded()) {
            this.drawers = null;
        }
    }

    public String toString() {
        return this.data.toString();
    }
}

