/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBounds {
    public final double negativeX;
    public final double negativeY;
    public final double negativeZ;
    public final double positiveX;
    public final double positiveY;
    public final double positiveZ;

    public static BlockBounds fromBlock(Block b, IBlockAccess world, int x, int y, int z) {
        b.func_149719_a(world, x, y, z);
        return new BlockBounds(b.func_149704_x(), b.func_149665_z(), b.func_149706_B(), b.func_149753_y(), b.func_149669_A(), b.func_149693_C());
    }

    public BlockBounds(double nx, double ny, double nz, double px, double py, double pz) {
        this.negativeX = Math.max(0.0, nx);
        this.negativeY = Math.max(0.0, ny);
        this.negativeZ = Math.max(0.0, nz);
        this.positiveX = Math.min(1.0, px);
        this.positiveY = Math.min(1.0, py);
        this.positiveZ = Math.min(1.0, pz);
        this.verify();
    }

    private void verify() {
        if (this.negativeX > this.positiveX) {
            throw new IllegalArgumentException("Negative X bound is larger than positive bound!");
        }
        if (this.negativeY > this.positiveY) {
            throw new IllegalArgumentException("Negative Y bound is larger than positive bound!");
        }
        if (this.negativeZ > this.positiveZ) {
            throw new IllegalArgumentException("Negative Z bound is larger than positive bound!");
        }
    }

    public BlockBounds add(ForgeDirection side, double amt) {
        return this.cut(side, -amt);
    }

    public BlockBounds cut(ForgeDirection side, double amt) {
        double nx = this.negativeX;
        double ny = this.negativeY;
        double nz = this.negativeZ;
        double px = this.positiveX;
        double py = this.positiveY;
        double pz = this.positiveZ;
        switch (side) {
            case DOWN: {
                amt = Math.min(amt, py - ny);
                ny += amt;
                break;
            }
            case UP: {
                amt = Math.min(amt, py - ny);
                py -= amt;
                break;
            }
            case EAST: {
                amt = Math.min(amt, px - nx);
                px -= amt;
                break;
            }
            case WEST: {
                amt = Math.min(amt, px - nx);
                nx += amt;
                break;
            }
            case NORTH: {
                amt = Math.min(amt, pz - nz);
                nz += amt;
                break;
            }
            case SOUTH: {
                amt = Math.min(amt, pz - nz);
                pz -= amt;
                break;
            }
        }
        return new BlockBounds(nx, ny, nz, px, py, pz);
    }

    public BlockBounds fill(ForgeDirection side) {
        double nx = this.negativeX;
        double ny = this.negativeY;
        double nz = this.negativeZ;
        double px = this.positiveX;
        double py = this.positiveY;
        double pz = this.positiveZ;
        switch (side) {
            case DOWN: {
                ny = 0.0;
                break;
            }
            case UP: {
                py = 1.0;
                break;
            }
            case EAST: {
                px = 1.0;
                break;
            }
            case WEST: {
                nx = 0.0;
                break;
            }
            case NORTH: {
                nz = 0.0;
                break;
            }
            case SOUTH: {
                pz = 1.0;
                break;
            }
        }
        return new BlockBounds(nx, ny, nz, px, py, pz);
    }

    public BlockBounds roundToNearest(double d) {
        double nx = this.negativeX;
        double ny = this.negativeY;
        double nz = this.negativeZ;
        double px = this.positiveX;
        double py = this.positiveY;
        double pz = this.positiveZ;
        nx = ReikaMathLibrary.roundToNearestFraction(nx, d);
        ny = ReikaMathLibrary.roundToNearestFraction(ny, d);
        nz = ReikaMathLibrary.roundToNearestFraction(nz, d);
        px = ReikaMathLibrary.roundToNearestFraction(px, d);
        py = ReikaMathLibrary.roundToNearestFraction(py, d);
        pz = ReikaMathLibrary.roundToNearestFraction(pz, d);
        return new BlockBounds(nx, ny, nz, px, py, pz);
    }

    public void copyToBlock(Block b) {
        b.func_149676_a((float)this.negativeX, (float)this.negativeY, (float)this.negativeZ, (float)this.positiveX, (float)this.positiveY, (float)this.positiveZ);
    }

    public static BlockBounds block() {
        return new BlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public void writeToNBT(String id, NBTTagCompound NBT) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74780_a("nx", this.negativeX);
        tag.func_74780_a("ny", this.negativeY);
        tag.func_74780_a("nz", this.negativeZ);
        tag.func_74780_a("px", this.positiveX);
        tag.func_74780_a("py", this.positiveY);
        tag.func_74780_a("pz", this.positiveZ);
        NBT.func_74782_a(id, (NBTBase)tag);
    }

    public static BlockBounds readFromNBT(String id, NBTTagCompound NBT) {
        NBTTagCompound tag = NBT.func_74775_l(id);
        double nx = tag.func_74769_h("nx");
        double ny = tag.func_74769_h("ny");
        double nz = tag.func_74769_h("nz");
        double px = tag.func_74769_h("px");
        double py = tag.func_74769_h("py");
        double pz = tag.func_74769_h("pz");
        return new BlockBounds(nx, ny, nz, px, py, pz);
    }

    public AxisAlignedBB asAABB(int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)((double)x + this.negativeX), (double)((double)y + this.negativeY), (double)((double)z + this.negativeZ), (double)((double)x + this.positiveX), (double)((double)y + this.positiveY), (double)((double)z + this.positiveZ));
    }

    public double getBound(ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                return this.negativeY;
            }
            case EAST: {
                return this.positiveX;
            }
            case NORTH: {
                return this.negativeZ;
            }
            case SOUTH: {
                return this.positiveZ;
            }
            case UP: {
                return this.positiveY;
            }
            case WEST: {
                return this.negativeX;
            }
        }
        return Double.NaN;
    }

    public boolean isFullDistance(ForgeDirection dir) {
        boolean val = dir.offsetX + dir.offsetY + dir.offsetZ == 1;
        return this.getBound(dir) == (double)val;
    }

    public boolean isFullFace(ForgeDirection dir) {
        if (this.isFullDistance(dir)) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir2 = ForgeDirection.VALID_DIRECTIONS[i];
            if (dir2 == dir || dir2 == dir.getOpposite() || this.isFullDistance(dir2)) continue;
            return false;
        }
        return true;
    }

    public ArrayList<String> toClearString() {
        ArrayList<String> li = new ArrayList<String>();
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            String s = dir == ForgeDirection.UP ? "Top" : (dir == ForgeDirection.DOWN ? "Bottom" : ReikaStringParser.capFirstChar(dir.name()));
            li.add(String.format("%s: %.1f px", s, 16.0 * this.getBound(dir)));
        }
        return li;
    }

    public String toString() {
        return this.negativeX + "," + this.negativeY + "," + this.negativeZ + " > " + this.positiveX + "," + this.positiveY + "," + this.positiveZ;
    }

    public int hashCode() {
        return Double.hashCode(this.negativeX) ^ Double.hashCode(this.positiveX) + Double.hashCode(this.negativeY) ^ Double.hashCode(this.positiveY) + Double.hashCode(this.negativeZ) ^ Double.hashCode(this.positiveZ);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlockBounds)) {
            return false;
        }
        BlockBounds bb = (BlockBounds)o;
        return Math.abs(bb.negativeX - this.negativeX) < 0.01 && Math.abs(bb.negativeY - this.negativeY) < 0.01 && Math.abs(bb.negativeZ - this.negativeZ) < 0.01 && Math.abs(bb.positiveX - this.positiveX) < 0.01 && Math.abs(bb.positiveY - this.positiveY) < 0.01 && Math.abs(bb.positiveZ - this.positiveZ) < 0.01;
    }

    public boolean sharesSideSize(BlockBounds bb, ForgeDirection dir) {
        switch (dir) {
            case DOWN: 
            case UP: {
                return Math.abs(bb.negativeX - this.negativeX) < 0.01 && Math.abs(bb.negativeZ - this.negativeZ) < 0.01 && Math.abs(bb.positiveX - this.positiveX) < 0.01 && Math.abs(bb.positiveZ - this.positiveZ) < 0.01;
            }
            case EAST: 
            case WEST: {
                return Math.abs(bb.negativeY - this.negativeY) < 0.01 && Math.abs(bb.negativeZ - this.negativeZ) < 0.01 && Math.abs(bb.positiveY - this.positiveY) < 0.01 && Math.abs(bb.positiveZ - this.positiveZ) < 0.01;
            }
            case NORTH: 
            case SOUTH: {
                return Math.abs(bb.negativeX - this.negativeX) < 0.01 && Math.abs(bb.negativeY - this.negativeY) < 0.01 && Math.abs(bb.positiveX - this.positiveX) < 0.01 && Math.abs(bb.positiveY - this.positiveY) < 0.01;
            }
        }
        throw new IllegalStateException();
    }
}

