/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.Location;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class DecimalPosition
implements Location,
Comparable<DecimalPosition> {
    private static final Random rand = new Random();
    public final double xCoord;
    public final double yCoord;
    public final double zCoord;

    public DecimalPosition(double x, double y, double z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    public DecimalPosition(TileEntity te) {
        this((double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5);
    }

    public DecimalPosition(Coordinate c) {
        this((double)c.xCoord + 0.5, (double)c.yCoord + 0.5, (double)c.zCoord + 0.5);
    }

    public DecimalPosition(Entity e) {
        this(e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public DecimalPosition(Entity e, float ptick) {
        this(e.field_70142_S + (double)ptick * (e.field_70165_t - e.field_70142_S), e.field_70137_T + (double)ptick * (e.field_70163_u - e.field_70137_T), e.field_70136_U + (double)ptick * (e.field_70161_v - e.field_70136_U));
    }

    public DecimalPosition(DecimalPosition loc) {
        this(loc.xCoord, loc.yCoord, loc.zCoord);
    }

    public DecimalPosition(MovingObjectPosition hit) {
        this((double)hit.field_72311_b + 0.5, (double)hit.field_72312_c + 0.5, (double)hit.field_72309_d + 0.5);
    }

    public DecimalPosition(WorldLocation src) {
        this((double)src.xCoord + 0.5, (double)src.yCoord + 0.5, (double)src.zCoord + 0.5);
    }

    public DecimalPosition(Vec3 vec) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public DecimalPosition offset(double dx, double dy, double dz) {
        return new DecimalPosition(this.xCoord + dx, this.yCoord + dy, this.zCoord + dz);
    }

    public DecimalPosition offset(ForgeDirection dir, double dist) {
        return this.offset((double)dir.offsetX * dist, (double)dir.offsetY * dist, (double)dir.offsetZ * dist);
    }

    public DecimalPosition offset(DecimalPosition p) {
        return this.offset(p.xCoord, p.yCoord, p.zCoord);
    }

    public boolean sharesBlock(DecimalPosition dec) {
        return this.sharesBlock(dec.xCoord, dec.yCoord, dec.zCoord);
    }

    public boolean sharesBlock(double x, double y, double z) {
        return this.matchX(x) && this.matchY(y) && this.matchZ(z);
    }

    private boolean matchX(double x) {
        return MathHelper.func_76128_c((double)x) == MathHelper.func_76128_c((double)this.xCoord);
    }

    private boolean matchY(double y) {
        return MathHelper.func_76128_c((double)y) == MathHelper.func_76128_c((double)this.yCoord);
    }

    private boolean matchZ(double z) {
        return MathHelper.func_76128_c((double)z) == MathHelper.func_76128_c((double)this.zCoord);
    }

    @Override
    public void writeToNBT(String tag, NBTTagCompound NBT) {
        NBTTagCompound data = new NBTTagCompound();
        this.writeToTag(data);
        NBT.func_74782_a(tag, (NBTBase)data);
    }

    @Override
    public void writeToTag(NBTTagCompound data) {
        data.func_74780_a("x", this.xCoord);
        data.func_74780_a("y", this.yCoord);
        data.func_74780_a("z", this.zCoord);
    }

    public static final DecimalPosition readFromNBT(String tag, NBTTagCompound NBT) {
        if (!NBT.func_74764_b(tag)) {
            return null;
        }
        NBTTagCompound data = NBT.func_74775_l(tag);
        if (data != null) {
            double x = data.func_74769_h("x");
            double y = data.func_74769_h("y");
            double z = data.func_74769_h("z");
            return new DecimalPosition(x, y, z);
        }
        return null;
    }

    @Override
    public NBTTagCompound writeToTag() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("x", this.xCoord);
        data.func_74780_a("y", this.yCoord);
        data.func_74780_a("z", this.zCoord);
        return data;
    }

    public static final DecimalPosition readTag(NBTTagCompound data) {
        double x = data.func_74769_h("x");
        double y = data.func_74769_h("y");
        double z = data.func_74769_h("z");
        return new DecimalPosition(x, y, z);
    }

    public DecimalPosition copy() {
        return new DecimalPosition(this.xCoord, this.yCoord, this.zCoord);
    }

    public String toString() {
        return "[" + this.xCoord + ", " + this.yCoord + ", " + this.zCoord + "]";
    }

    public int hashCode() {
        return Coordinate.coordHash((int)(this.xCoord * 1000.0), (int)(this.yCoord * 1000.0), (int)(this.zCoord * 1000.0));
    }

    public boolean equals(Object o) {
        if (o instanceof DecimalPosition) {
            DecimalPosition w = (DecimalPosition)o;
            return this.equals(w.xCoord, w.yCoord, w.zCoord);
        }
        return false;
    }

    public boolean equals(double x, double y, double z) {
        return x == this.xCoord && y == this.yCoord && z == this.zCoord;
    }

    public double getDistanceTo(DecimalPosition src) {
        return this.getDistanceTo(src.xCoord, src.yCoord, src.zCoord);
    }

    @Override
    public double getDistanceTo(double x, double y, double z) {
        return ReikaMathLibrary.py3d(x - this.xCoord, y - this.yCoord, z - this.zCoord);
    }

    public boolean isWithinSquare(Coordinate c, double d) {
        return this.isWithinSquare(c, d, d, d);
    }

    public boolean isWithinSquare(Coordinate c, double dx, double dy, double dz) {
        return Math.abs((double)c.xCoord - this.xCoord) <= dx && Math.abs((double)c.yCoord - this.yCoord) <= dy && Math.abs((double)c.zCoord - this.zCoord) <= dz;
    }

    public double[] toArray() {
        double[] a = new double[]{this.xCoord, this.yCoord, this.zCoord};
        return a;
    }

    public Coordinate getCoordinate() {
        return new Coordinate(MathHelper.func_76128_c((double)this.xCoord), MathHelper.func_76128_c((double)this.yCoord), MathHelper.func_76128_c((double)this.zCoord));
    }

    @Override
    public Block getBlock(IBlockAccess world) {
        return world != null ? this.getCoordinate().getBlock(world) : null;
    }

    public boolean isEmpty(IBlockAccess world) {
        return this.getBlock(world).isAir(world, MathHelper.func_76128_c((double)this.xCoord), MathHelper.func_76128_c((double)this.yCoord), MathHelper.func_76128_c((double)this.zCoord));
    }

    @Override
    public int getBlockMetadata(IBlockAccess world) {
        return world != null ? this.getCoordinate().getBlockMetadata(world) : -1;
    }

    @Override
    public TileEntity getTileEntity(IBlockAccess world) {
        return world != null ? this.getCoordinate().getTileEntity(world) : null;
    }

    public int getRedstone(World world) {
        return world != null ? this.getCoordinate().getRedstone(world) : 0;
    }

    public void triggerBlockUpdate(World world, boolean adjacent) {
        this.getCoordinate().triggerBlockUpdate(world, adjacent);
    }

    public void dropItem(World world, ItemStack is) {
        this.dropItem(world, is, 1.0);
    }

    public void dropItem(World world, ItemStack is, double vscale) {
        if (world != null && !world.field_72995_K) {
            ReikaItemHelper.dropItem(world, this.xCoord + rand.nextDouble(), this.yCoord + rand.nextDouble(), this.zCoord + rand.nextDouble(), is, vscale);
        }
    }

    public boolean setBlock(World world, Block b) {
        return this.setBlock(world, b, 0);
    }

    public boolean setBlock(World world, ItemStack is) {
        return this.setBlock(world, Block.func_149634_a((Item)is.func_77973_b()), is.func_77960_j());
    }

    public boolean setBlock(World world, Block id, int meta) {
        return world != null && this.getCoordinate().setBlock(world, id, meta);
    }

    public DecimalPosition negate() {
        return new DecimalPosition(this.xCoord, this.yCoord, this.zCoord);
    }

    public DecimalPosition to2D() {
        return new DecimalPosition(this.xCoord, 0.0, this.zCoord);
    }

    public static DecimalPosition interpolate(DecimalPosition p1, DecimalPosition p2, double f) {
        return DecimalPosition.interpolate(p1.xCoord, p1.yCoord, p1.zCoord, p2.xCoord, p2.yCoord, p2.zCoord, f);
    }

    public static DecimalPosition interpolate(double x1, double y1, double z1, double x2, double y2, double z2, double f) {
        return new DecimalPosition(x1 + (x2 - x1) * f, y1 + (y2 - y1) * f, z1 + (z2 - z1) * f);
    }

    public void writeToBuf(ByteBuf buf) {
        buf.writeDouble(this.xCoord);
        buf.writeDouble(this.yCoord);
        buf.writeDouble(this.zCoord);
    }

    public static DecimalPosition readFromBuf(ByteBuf buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return new DecimalPosition(x, y, z);
    }

    public String formattedString(int decimal) {
        String part = "%." + decimal + "f";
        return String.format(part + ", " + part + ", " + part, this.xCoord, this.yCoord, this.zCoord);
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
    }

    public AxisAlignedBB getAABB(double radius) {
        return AxisAlignedBB.func_72330_a((double)(this.xCoord - radius), (double)(this.yCoord - radius), (double)(this.zCoord - radius), (double)(this.xCoord + radius), (double)(this.yCoord + radius), (double)(this.zCoord + radius));
    }

    @Override
    public int compareTo(DecimalPosition o) {
        int val = Integer.compare(this.hashCode(), o.hashCode());
        if (val != 0) {
            return val;
        }
        val = Double.compare(this.xCoord, o.xCoord);
        if (val != 0) {
            return val;
        }
        val = Double.compare(this.yCoord, o.yCoord);
        if (val != 0) {
            return val;
        }
        val = Double.compare(this.zCoord, o.zCoord);
        return val;
    }

    public static DecimalPosition average(DecimalPosition ... pos) {
        double sx = 0.0;
        double sy = 0.0;
        double sz = 0.0;
        int n = pos.length;
        for (int i = 0; i < n; ++i) {
            sx += pos[i].xCoord;
            sy += pos[i].yCoord;
            sz += pos[i].zCoord;
        }
        return new DecimalPosition(sx / (double)n, sy / (double)n, sz / (double)n);
    }

    public static DecimalPosition getRandomWithin(Coordinate c, Random rand) {
        return new DecimalPosition((double)c.xCoord + rand.nextDouble(), (double)c.yCoord + rand.nextDouble(), (double)c.zCoord + rand.nextDouble());
    }

    @Override
    public MovingObjectPosition asMovingPosition(int s, Vec3 vec) {
        return new MovingObjectPosition(MathHelper.func_76128_c((double)this.xCoord), MathHelper.func_76128_c((double)this.yCoord), MathHelper.func_76128_c((double)this.zCoord), s, vec);
    }
}

