/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class BranchingMap<V> {
    private final HashMap<V, TreeEntry<V>> data = new HashMap();

    public V getParent(V obj) {
        TreeEntry<V> t = this.data.get(obj);
        return t != null && ((TreeEntry)t).parent != null ? (V)((TreeEntry)t).parent.value : null;
    }

    public Collection<V> getChildren(V obj) {
        TreeEntry<V> t = this.data.get(obj);
        if (t == null) {
            return null;
        }
        ArrayList ret = new ArrayList();
        for (TreeEntry c : ((TreeEntry)t).children) {
            ret.add(c.value);
        }
        return ret;
    }

    public Collection<V> getRecursiveChildren(V obj) {
        return this.getRecursiveChildren(this.data.get(obj));
    }

    private Collection<V> getRecursiveChildren(TreeEntry<V> tree) {
        ArrayList<V> c = new ArrayList<V>();
        if (tree != null) {
            for (TreeEntry par : ((TreeEntry)tree).children) {
                c.add(par.value);
                c.addAll(this.getRecursiveChildren(par));
            }
        }
        return c;
    }

    public void addChildless(V obj) {
        this.data.put(obj, new TreeEntry(obj));
    }

    public void addChild(V obj, V child) {
        TreeEntry<V> tree = this.data.get(obj);
        if (tree == null) {
            tree = new TreeEntry(obj);
            this.data.put((TreeEntry<V>)obj, (TreeEntry<TreeEntry<V>>)tree);
        }
        this.data.put((TreeEntry)child, ((TreeEntry)tree).addChild(child));
    }

    public boolean containsStep(V p1, V p2) {
        TreeEntry<V> tree = this.data.get(p1);
        return tree != null && ((TreeEntry)tree).children.contains(p2);
    }

    public boolean hasElementAsParent(V obj) {
        return this.data.containsKey(obj);
    }

    public boolean hasElementAsChild(V obj) {
        for (TreeEntry<V> e : this.data.values()) {
            if (!((TreeEntry)e).containsChild(obj)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.data.clear();
    }

    public Topology<V> getTopology() {
        return new Topology(this);
    }

    public Collection valueSet() {
        ArrayList values = new ArrayList();
        for (TreeEntry<V> t : this.data.values()) {
            values.addAll(((TreeEntry)t).getChildValues());
        }
        return values;
    }

    public Collection fullSet() {
        Collection values = this.valueSet();
        for (V obj : this.data.keySet()) {
            if (values.contains(obj)) continue;
            values.add(obj);
        }
        return values;
    }

    public LinkedList<V> getPathTo(V obj) {
        LinkedList ret = new LinkedList();
        TreeEntry e = this.data.get(obj);
        while (e != null) {
            ret.add(e.value);
            e = e.parent;
        }
        Collections.reverse(ret);
        return ret;
    }

    private Collection<TreeEntry<V>> getRoots() {
        ArrayList<TreeEntry<V>> ret = new ArrayList<TreeEntry<V>>();
        for (TreeEntry<V> e : this.data.values()) {
            if (((TreeEntry)e).parent != null) continue;
            ret.add(e);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Branching map:\n");
        for (TreeEntry<V> v : this.getRoots()) {
            if (v == null) continue;
            sb.append(this.getString(v, 0));
        }
        return sb.toString();
    }

    private String getString(TreeEntry<V> e, int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(ReikaStringParser.getNOf(" ", 4 * depth) + e.value + "\n");
        for (TreeEntry e2 : ((TreeEntry)e).children) {
            sb.append(this.getString(e2, depth + 1));
        }
        return sb.toString();
    }

    private String getKeyString(V v) {
        StringBuilder sb = new StringBuilder();
        TreeEntry<V> e = this.data.get(v);
        sb.append(v);
        sb.append("={");
        for (TreeEntry in : ((TreeEntry)e).children) {
            sb.append(this.getKeyString(in.value));
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Topology<V> {
        private final BranchingMap<V> map;
        private final HashMap<V, Integer> depths = new HashMap();
        private final MultiMap<Integer, V> depthInverse = new MultiMap();
        private int maxDepth = 0;

        private Topology(BranchingMap m) {
            this.map = m;
            this.calculateDepths();
        }

        private void calculateDepths() {
            ArrayList c = new ArrayList(this.map.fullSet());
            for (Object obj : c) {
                this.depths.put((Integer)obj, 0);
            }
            boolean change = false;
            do {
                change = false;
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    int d;
                    Object obj = it.next();
                    boolean locchange = false;
                    Object par = this.getParent(obj);
                    int o = this.depths.get(obj);
                    int n = d = par == null ? 0 : this.depths.get(par) + 1;
                    if (d > o) {
                        this.depths.put((Integer)obj, d);
                        this.maxDepth = Math.max(this.maxDepth, d);
                        change = true;
                        locchange = true;
                    }
                    if (locchange) continue;
                    it.remove();
                }
            } while (change);
            for (Map.Entry<V, Integer> e : this.depths.entrySet()) {
                this.depthInverse.addValue(e.getValue(), e.getKey());
            }
        }

        public int getNumberChildren(V obj) {
            return ((TreeEntry)((BranchingMap)this.map).data.get(obj)).children.size();
        }

        public Collection<V> getChildren(V obj) {
            return this.map.getChildren(obj);
        }

        public V getParent(V obj) {
            return this.map.getParent(obj);
        }

        public Map<V, Integer> getDepthMap() {
            return Collections.unmodifiableMap(this.depths);
        }

        public Collection<V> getByDepth(int depth) {
            return Collections.unmodifiableCollection(this.depthInverse.get(depth));
        }

        public String toString() {
            return this.depths.toString();
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }
    }

    private static class TreeEntry<V> {
        private TreeEntry<V> parent;
        private Collection<TreeEntry<V>> children = new ArrayList<TreeEntry<V>>();
        public final V value;

        private TreeEntry(V val) {
            this.value = val;
        }

        private TreeEntry<V> addChild(V c) {
            TreeEntry<V> ret = new TreeEntry<V>(c);
            ret.parent = this;
            this.children.add(ret);
            return ret;
        }

        private boolean containsChild(V c) {
            for (TreeEntry<V> e : this.children) {
                if (!e.value.equals(c)) continue;
                return true;
            }
            return false;
        }

        private Collection<V> getChildValues() {
            ArrayList<V> c = new ArrayList<V>();
            for (TreeEntry<V> e : this.children) {
                c.add(e.value);
            }
            return c;
        }
    }
}

