/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Instantiable.Data.Immutable.Column;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class ColumnMap {
    private final HashMap<Coordinate, ColumnSet> data = new HashMap();

    public void addColumn(int x, int z, int y1, int y2) {
        this.addColumn(new Coordinate(x, 0, z), y1, y2);
    }

    public void addColumn(Coordinate loc, int y1, int y2) {
        Coordinate key = loc.to2D();
        ColumnSet c = this.data.get(key);
        if (c == null) {
            c = new ColumnSet();
            this.data.put(key, c);
        }
        c.addColumn(y1, y2);
    }

    public void addBlock(int x, int y, int z) {
        this.addBlock(new Coordinate(x, y, z));
    }

    public void addBlock(Coordinate loc) {
        this.addColumn(loc, loc.yCoord, loc.yCoord);
    }

    public Collection<Column> getColumns(int x, int z) {
        return this.getColumns(new Coordinate(x, 0, z));
    }

    public Collection<Column> getColumns(Coordinate c) {
        ColumnSet set = this.data.get(c.to2D());
        return set != null ? set.getColumns() : new ArrayList<Column>();
    }

    private static class ColumnSet {
        private boolean[] data = new boolean[256];
        private int minY = Integer.MAX_VALUE;
        private int maxY = Integer.MIN_VALUE;

        private ColumnSet() {
        }

        private void addColumn(int y1, int y2) {
            for (int y = y1; y <= y2; ++y) {
                this.data[y] = true;
            }
            this.minY = Math.min(this.minY, y1);
            this.maxY = Math.max(this.maxY, y2);
        }

        public Collection<Column> getColumns() {
            ArrayList<Column> li = new ArrayList<Column>();
            boolean active = true;
            int startY = this.minY;
            for (int y = this.minY; y <= this.maxY; ++y) {
                if (active && !this.data[y]) {
                    li.add(new Column(startY, y - 1));
                    active = false;
                    continue;
                }
                if (!this.data[y]) continue;
                if (!active) {
                    startY = y;
                }
                active = true;
            }
            li.add(new Column(startY, this.maxY));
            return li;
        }
    }
}

