/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Instantiable.Data.Maps.ThresholdMapping;
import Reika.DragonAPI.Interfaces.Matcher;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public final class FluidHashMap<V> {
    private final HashMap<String, ThresholdMapping<V>> data = new HashMap();
    private ArrayList<FluidStack> sorted = null;
    private Collection<FluidStack> keyset = null;
    private boolean modifiedKeys = true;
    private Matcher<V> matcher = null;
    private boolean oneWay = false;

    public FluidHashMap<V> setOneWay() {
        return this.setOneWay(null);
    }

    public FluidHashMap<V> setOneWay(Matcher m) {
        this.oneWay = true;
        this.matcher = m;
        return this;
    }

    private void updateKeysets() {
        this.modifiedKeys = false;
        this.keyset = this.createKeySet();
        this.sorted = new ArrayList<FluidStack>(this.keySet());
        ReikaFluidHelper.sortFluids(this.sorted);
    }

    private V putKey(FluidStack is, V value) {
        ThresholdMapping<V> map = this.data.get(is.getFluid().getName());
        if (map == null) {
            map = new ThresholdMapping();
            this.data.put(is.getFluid().getName(), map);
        }
        return map.addMapping(is.amount, value);
    }

    public V get(FluidStack is) {
        ThresholdMapping<V> map = this.data.get(is.getFluid().getName());
        if (map != null) {
            for (double key : map.keySet()) {
                if (!((double)is.amount >= key)) continue;
                return map.getForValue(key, false);
            }
        }
        return null;
    }

    public V getForValue(FluidStack is) {
        ThresholdMapping<V> map = this.data.get(is.getFluid().getName());
        if (map != null) {
            V ret = map.getForValue(is.amount, false);
            return ret;
        }
        return null;
    }

    public boolean containsKey(FluidStack is) {
        ThresholdMapping<V> map = this.data.get(is.getFluid().getName());
        if (map != null) {
            for (double key : map.keySet()) {
                if (!((double)is.amount >= key)) continue;
                return true;
            }
        }
        return false;
    }

    public V put(FluidStack is, V value) {
        if (this.oneWay && this.data.containsKey(is.getFluid().getName())) {
            V v;
            if (this.matcher != null && ((v = this.get(is)) == value || this.matcher.match(v, value))) {
                return v;
            }
            throw new UnsupportedOperationException("This map does not support overwriting values! Fluid " + is + " already mapped to '" + this.get(is) + "'!");
        }
        V ret = this.putKey(is, value);
        this.modifiedKeys = true;
        return ret;
    }

    public boolean containsKey(Fluid i, int amt) {
        return this.containsKey(new FluidStack(i, amt));
    }

    public boolean containsKey(Fluid f) {
        return this.data.containsKey(f.getName());
    }

    public V put(Fluid i, int amt, V value) {
        return this.put(new FluidStack(i, amt), value);
    }

    public V get(Fluid i, int amt) {
        return this.get(new FluidStack(i, amt));
    }

    public int size() {
        return ReikaJavaLibrary.getNestedMapSize(this.data);
    }

    public Collection<FluidStack> keySet() {
        if (this.modifiedKeys || this.keyset == null) {
            this.updateKeysets();
        }
        return Collections.unmodifiableCollection(this.keyset);
    }

    public Collection<V> values() {
        ArrayList<V> li = new ArrayList<V>();
        for (String k : this.data.keySet()) {
            ThresholdMapping<V> o = this.data.get(k);
            li.addAll(o.values());
        }
        return li;
    }

    private Collection<FluidStack> createKeySet() {
        ArrayList<FluidStack> li = new ArrayList<FluidStack>();
        for (String fs : this.data.keySet()) {
            for (double s : this.data.get(fs).keySet()) {
                li.add(new FluidStack(FluidRegistry.getFluid((String)fs), (int)s));
            }
        }
        return li;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (String fs : this.data.keySet()) {
            Fluid f = FluidRegistry.getFluid((String)fs);
            sb.append(ReikaFluidHelper.fluidToString(f) + "=" + this.data.get(fs));
            sb.append(",\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public V remove(FluidStack is) {
        if (this.oneWay) {
            throw new UnsupportedOperationException("This map does not support removing values!");
        }
        V ret = this.removeKey(is);
        this.modifiedKeys = true;
        return ret;
    }

    private V removeKey(FluidStack is) {
        ThresholdMapping<V> map = this.data.get(is.getFluid().getName());
        return map != null ? (V)map.remove(is.amount) : null;
    }

    public boolean removeValue(V value) {
        return ReikaJavaLibrary.removeValuesFromMap(this.data, value);
    }

    public void clear() {
        if (this.oneWay) {
            throw new UnsupportedOperationException("This map does not support removing values!");
        }
        this.data.clear();
        this.modifiedKeys = true;
    }

    public List<FluidStack> sortedKeyset() {
        if (this.modifiedKeys || this.sorted == null) {
            this.updateKeysets();
        }
        return Collections.unmodifiableList(this.sorted);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public FluidHashMap<V> clone() {
        FluidHashMap<V> map = new FluidHashMap<V>();
        map.data.putAll(this.data);
        return map;
    }
}

