/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class LinkMap {
    private final HashMap<WorldLocation, HashMap<WorldLocation, Double>> data = new HashMap();

    public void addLink(WorldLocation src, WorldLocation tg) {
        this.connect(src, tg);
    }

    public void addBiLink(WorldLocation src, WorldLocation tg) {
        this.connect(src, tg);
        this.connect(tg, src);
    }

    private void connect(WorldLocation src, WorldLocation tg) {
        HashMap<WorldLocation, Double> c = this.data.get(src);
        if (c == null) {
            c = new HashMap();
            this.data.put(src, c);
        }
        c.put(tg, tg.getDistanceTo(src));
    }

    public double getDistance(WorldLocation src, WorldLocation tg) {
        HashMap<WorldLocation, Double> c = this.data.get(src);
        if (c != null) {
            Double d = c.get(tg);
            return d != null ? d : Double.POSITIVE_INFINITY;
        }
        return Double.POSITIVE_INFINITY;
    }

    public boolean isConnected(WorldLocation src, WorldLocation tg) {
        HashMap<WorldLocation, Double> c = this.data.get(src);
        return c != null && c.containsKey(tg);
    }

    public boolean removeSource(WorldLocation loc) {
        return this.data.remove(loc) != null;
    }

    public boolean removeLocation(WorldLocation loc) {
        boolean flag = this.removeSource(loc);
        for (HashMap<WorldLocation, Double> map : this.data.values()) {
            flag |= map.remove(loc) != null;
        }
        return flag;
    }

    public Set<WorldLocation> keySet() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public Map<WorldLocation, Double> getTargets(WorldLocation loc) {
        Map map = this.data.get(loc);
        return map != null ? Collections.unmodifiableMap(map) : null;
    }

    public String toString() {
        return this.data.toString();
    }

    public void removeWorld(World world) {
        ArrayList<WorldLocation> c = new ArrayList<WorldLocation>();
        for (WorldLocation loc : this.data.keySet()) {
            if (loc.dimensionID != world.field_73011_w.field_76574_g) continue;
            c.add(loc);
        }
        for (WorldLocation loc : c) {
            this.data.remove(loc);
        }
    }

    public void clear() {
        this.data.clear();
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList li = new NBTTagList();
        for (WorldLocation src : this.data.keySet()) {
            NBTTagCompound entry = new NBTTagCompound();
            src.writeToTag(entry);
            NBTTagList map = new NBTTagList();
            HashMap<WorldLocation, Double> dat = this.data.get(src);
            for (WorldLocation tg : dat.keySet()) {
                NBTTagCompound nbt = new NBTTagCompound();
                tg.writeToTag(nbt);
                map.func_74742_a((NBTBase)nbt);
            }
            entry.func_74782_a("map", (NBTBase)map);
            li.func_74742_a((NBTBase)entry);
        }
        tag.func_74782_a("locs", (NBTBase)li);
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList li = tag.func_150295_c("locs", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            NBTTagCompound entry = (NBTTagCompound)o;
            WorldLocation src = WorldLocation.readTag(entry);
            NBTTagList map = tag.func_150295_c("map", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
            for (Object o2 : li.field_74747_a) {
                NBTTagCompound nbt = (NBTTagCompound)o2;
                WorldLocation tg = WorldLocation.readTag(nbt);
                this.addLink(src, tg);
            }
        }
    }
}

