/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class PluralMap<V>
extends HashMap {
    public final int keySize;
    private boolean bidi = false;

    public PluralMap(int size) {
        this.keySize = size;
    }

    public PluralMap<V> setBidirectional() {
        this.bidi = true;
        return this;
    }

    @Override
    public V put(V value, Object ... key) {
        if (key.length != this.keySize) {
            throw new IllegalArgumentException("Invalid key length!");
        }
        return super.put(this.toList(key), value);
    }

    public V get(Object ... key) {
        if (key.length != this.keySize) {
            throw new IllegalArgumentException("Invalid key length!");
        }
        return super.get(this.toList(key));
    }

    public boolean containsKeyV(Object ... key) {
        if (key.length != this.keySize) {
            throw new IllegalArgumentException("Invalid key length!");
        }
        return super.containsKey(this.toList(key));
    }

    private Collection<Object> toList(Object[] key) {
        return this.bidi ? Sets.newHashSet((Object[])key) : Arrays.asList(key);
    }

    public V remove(Object ... key) {
        if (key.length != this.keySize) {
            throw new IllegalArgumentException("Invalid key length!");
        }
        return super.remove(this.toList(key));
    }

    public Collection<List<Object>> pluralKeySet() {
        return Collections.unmodifiableCollection(this.keySet());
    }
}

