/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.util.Rectangle;

public class RegionMap<V> {
    private final HashMap<Rectangle, V> data = new HashMap();

    public void clear() {
        this.data.clear();
    }

    public String toString() {
        return this.data.toString();
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof RegionMap && this.data.equals(((RegionMap)o).data);
    }

    public V addRegionByWH(int x, int y, int w, int h, V obj) {
        return this.data.put(new Rectangle(x, y, w, h), obj);
    }

    public V addRegionByDXDY(int minx, int miny, int maxx, int maxy, V obj) {
        return this.addRegionByWH(minx, miny, maxx - minx, maxy - miny, obj);
    }

    public V getRegion(int x, int y) {
        for (Rectangle r : this.data.keySet()) {
            if (!r.contains(x, y)) continue;
            return this.data.get(r);
        }
        return null;
    }

    public V remove(int x, int y) {
        for (Rectangle r : this.data.keySet()) {
            if (r.getX() != x || r.getY() != y) continue;
            return this.data.remove(r);
        }
        return null;
    }

    public boolean containsOrigin(int x, int y) {
        for (Rectangle r : this.data.keySet()) {
            if (r.getX() != x || r.getY() != y) continue;
            return true;
        }
        return false;
    }

    public Map<Rectangle, V> view() {
        return Collections.unmodifiableMap(this.data);
    }

    public Collection<Rectangle> keySet() {
        return Collections.unmodifiableCollection(this.data.keySet());
    }
}

