/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import java.util.Collection;
import java.util.Collections;

public final class ReversibleMultiMap<K, V> {
    private final MultiMap<K, V> forward;
    private final MultiMap<V, K> backward;

    public ReversibleMultiMap() {
        this(MultiMap.CollectionType.LIST);
    }

    public ReversibleMultiMap(MultiMap.CollectionType cf) {
        this.forward = new MultiMap(cf);
        this.backward = new MultiMap(cf);
    }

    public void put(K key, Collection<V> values) {
        this.forward.put(key, values);
        for (V v : values) {
            this.backward.addValue(v, key);
        }
    }

    public void addValue(K key, V value) {
        this.forward.addValue(key, value);
        this.backward.addValue(value, key);
    }

    public Collection<V> getForward(K key) {
        return this.forward.get(key);
    }

    public Collection<K> getBackward(V value) {
        return this.backward.get(value);
    }

    public void clear() {
        this.forward.clear();
        this.backward.clear();
    }

    public void remove(K key, V value) {
        this.forward.remove(key, value);
        this.backward.remove(value, key);
    }

    public void removeKey(K key) {
        Collection<V> c = this.forward.remove(key);
        for (V v : c) {
            this.backward.remove(v, key);
        }
    }

    public void removeValue(V value) {
        Collection<K> c = this.backward.remove(value);
        for (K k : c) {
            this.forward.remove(k, value);
        }
    }

    public String toString() {
        return "REVERSIBLE: " + this.forward.toString();
    }

    public Collection<K> keySet() {
        return Collections.unmodifiableCollection(this.forward.keySet());
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.backward.keySet());
    }
}

