/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeMap;

public class ThresholdMapping<V> {
    private final TreeMap<Double, V> data;

    public ThresholdMapping() {
        this.data = new TreeMap();
    }

    public ThresholdMapping(Comparator c) {
        this.data = new TreeMap(c);
    }

    public V addMapping(double thresh, V value) {
        return this.data.put(thresh, value);
    }

    public Double getKeyForValue(double v, boolean ceil) {
        Double d = ceil ? this.data.ceilingKey(v) : this.data.floorKey(v);
        return d != null ? d : null;
    }

    public V getForValue(double v, boolean ceil) {
        Double d = ceil ? this.data.ceilingKey(v) : this.data.floorKey(v);
        return d != null ? (V)this.data.get(d) : null;
    }

    public V remove(double val) {
        return this.data.remove(val);
    }

    public Collection<Double> keySet() {
        return Collections.unmodifiableCollection(this.data.keySet());
    }

    public double firstValue() {
        return this.data.isEmpty() ? 0.0 : this.data.firstKey();
    }

    public double lastValue() {
        return this.data.isEmpty() ? 0.0 : this.data.lastKey();
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.data.values());
    }

    public String toString() {
        return this.data.toString();
    }
}

