/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class Sorter<O> {
    private final Element[] elements;
    private final HashMap<O, Integer> indexes = new HashMap();

    public Sorter(O ... objects) {
        this.elements = new Element[objects.length];
        for (int i = 0; i < this.elements.length; ++i) {
            O o = objects[i];
            if (this.indexes.containsKey(o)) {
                throw new MisuseException("You cannot have duplicate objects!");
            }
            this.elements[i] = new Element(o);
            this.indexes.put(o, i);
        }
    }

    public void increment(O o) {
        int idx = this.indexes.get(o);
        this.elements[idx].count++;
    }

    public ArrayList<O> getSorted() {
        ArrayList li = ReikaJavaLibrary.makeListFromArray(this.elements);
        Collections.sort(li, new ElementSorter());
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Element e : li) {
            ret.add(e.object);
        }
        return ret;
    }

    private static class ElementSorter
    implements Comparator<Element> {
        private ElementSorter() {
        }

        @Override
        public int compare(Element o1, Element o2) {
            return o2.count - o1.count;
        }
    }

    private static class Element<O> {
        private final O object;
        private int count = 0;

        private Element(O o) {
            this.object = o;
        }
    }
}

