/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;

public class SphericalVector {
    public double magnitude;
    public double inclination;
    public double rotation;

    public SphericalVector(double m, double theta, double phi) {
        this.magnitude = m;
        this.inclination = theta;
        this.rotation = phi;
    }

    public static SphericalVector fromCartesian(double dx, double dy, double dz) {
        SphericalVector ret = new SphericalVector(0.0, 0.0, 0.0);
        ret.aimFrom(dx, dy, dz, 0.0, 0.0, 0.0);
        return ret;
    }

    public double[] getCartesian() {
        return ReikaPhysicsHelper.polarToCartesian(this.magnitude, this.inclination, this.rotation);
    }

    public double getXProjection() {
        return this.getCartesian()[0];
    }

    public double getYProjection() {
        return this.getCartesian()[1];
    }

    public double getZProjection() {
        return this.getCartesian()[2];
    }

    public void aimFrom(double x1, double y1, double z1, double x2, double y2, double z2) {
        double[] dat = ReikaPhysicsHelper.cartesianToPolar(x2 - x1, y2 - y1, z2 - z1);
        this.magnitude = dat[0];
        this.inclination = -(dat[1] - 90.0);
        this.rotation = -dat[2] - 90.0;
    }
}

