/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Effects;

import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class EntityFloatingSeedsFX
extends EntityBlurFX {
    private double angXZ;
    private double angY;
    private double angXZ_vel;
    private double angY_vel;
    private double angXZ_target;
    private double angY_target;
    private final double windAngle;
    private final double climbAngle;
    public double tolerance = 1.5;
    public double freedom = 20.0;
    public double angleVelocity = 0.75;
    public double particleVelocity = 0.0625;

    public EntityFloatingSeedsFX(World world, double x, double y, double z, double windAng, double climbAng, IIcon icon) {
        super(world, x, y, z, icon);
        this.setColor(0xFFFFFF);
        this.windAngle = windAng;
        this.climbAngle = climbAng;
        this.angXZ = this.windAngle;
        this.angY = this.climbAngle;
        this.randomizeXZ();
        this.randomizeY();
        this.updateVelocities();
        this.func_110125_a(icon);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateAnglesAndSpeeds();
    }

    private void updateAnglesAndSpeeds() {
        this.updateAngles();
        this.angXZ += this.angXZ_vel;
        this.angY += this.angY_vel;
        this.updateVelocities();
    }

    private void updateAngles() {
        if (Math.abs(this.angXZ_target - this.angXZ) <= this.tolerance) {
            this.randomizeXZ();
        }
        if (Math.abs(this.angY_target - this.angY) <= this.tolerance) {
            this.randomizeY();
        }
    }

    private void randomizeXZ() {
        this.angXZ_target = ReikaRandomHelper.getRandomPlusMinus(this.windAngle, this.freedom);
        if (this.angXZ_target > this.angXZ) {
            this.angXZ_vel = this.angleVelocity;
        } else if (this.angXZ_target < this.angXZ) {
            this.angXZ_vel = -this.angleVelocity;
        }
    }

    private void randomizeY() {
        this.angY_target = ReikaRandomHelper.getRandomPlusMinus(this.climbAngle, this.freedom);
        if (this.angY_target > this.angY) {
            this.angY_vel = this.angleVelocity;
        } else if (this.angY_target < this.angY) {
            this.angY_vel = -this.angleVelocity;
        }
    }

    private void updateVelocities() {
        double[] xyz = ReikaPhysicsHelper.polarToCartesianFast(this.particleVelocity, this.angY, this.angXZ);
        this.field_70159_w = xyz[0];
        this.field_70181_x = xyz[1];
        this.field_70179_y = xyz[2];
    }
}

