/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Event;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import cpw.mods.fml.common.eventhandler.Cancelable;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

@Cancelable
public class AddSmeltingEvent
extends Event {
    private final ItemStack input;
    private final ItemStack output;
    public final float originalXP;
    public float experienceValue;
    private boolean isInvalid = false;
    public static boolean isVanillaPass = false;

    public AddSmeltingEvent(ItemStack in, ItemStack out, float xp) {
        this(in, out, xp, isVanillaPass);
    }

    public AddSmeltingEvent(ItemStack in, ItemStack out, float xp, boolean v) {
        this.input = in;
        this.output = out;
        this.validate();
        this.originalXP = xp;
        this.experienceValue = xp;
        isVanillaPass = v;
    }

    public ItemStack getInput() {
        return this.input == null ? null : this.input.func_77946_l();
    }

    public ItemStack getOutput() {
        return this.output == null ? null : this.output.func_77946_l();
    }

    public void markInvalid() {
        this.isInvalid = true;
        this.setCanceled(true);
    }

    public void setCanceled(boolean cancel) {
        if (this.isInvalid) {
            cancel = true;
        }
        super.setCanceled(cancel);
    }

    public boolean isCanceled() {
        return super.isCanceled() || this.isInvalid;
    }

    public boolean isValid() {
        return !this.isInvalid;
    }

    private void validate() {
        if (this.input == null || this.input.func_77973_b() == null) {
            DragonAPICore.logError("Found a null-input (or null-item input) smelting recipe! " + null + " > " + this.output + "! This is invalid!");
            Thread.dumpStack();
            this.isInvalid = true;
        } else if (this.output == null || this.output.func_77973_b() == null) {
            DragonAPICore.logError("Found a null-output (or null-item output) smelting recipe! " + this.input + " > " + null + "! This is invalid!");
            Thread.dumpStack();
            this.isInvalid = true;
        } else if (!ReikaItemHelper.verifyItemStack(this.input, true)) {
            DragonAPICore.logError("Found a smelting recipe with an invalid input!");
            Thread.dumpStack();
            this.isInvalid = true;
        } else if (!ReikaItemHelper.verifyItemStack(this.output, true)) {
            DragonAPICore.logError("Found a smelting recipe with an invalid output!");
            Thread.dumpStack();
            this.isInvalid = true;
        }
    }

    public static boolean fire(ItemStack in, ItemStack out, float xp) {
        AddSmeltingEvent evt = new AddSmeltingEvent(in, out, xp);
        return !MinecraftForge.EVENT_BUS.post((Event)evt);
    }

    private static String toString(ItemStack in) {
        return in == null ? "null" : (in.func_77973_b() == null ? "null-item" : in.toString());
    }
}

