/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Event;

import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Instantiable.Event.Base.WorldPositionEvent;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

@Event.HasResult
public class BlockSpreadEvent
extends WorldPositionEvent {
    public final Block spreadingBlock;
    public final boolean defaultValue;

    public BlockSpreadEvent(World world, int x, int y, int z, Block b, boolean flag) {
        super(world, x, y, z);
        this.spreadingBlock = b;
        this.defaultValue = flag;
    }

    private static boolean shouldDie(World world, int x, int y, int z, Block b) {
        boolean DEFAULT = world.func_72957_l(x, y + 1, z) < 4 && world.getBlockLightOpacity(x, y + 1, z) > 2;
        BlockDeathEvent evt = new BlockDeathEvent(world, x, y, z, b, DEFAULT);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        switch (evt.getResult()) {
            case ALLOW: {
                return true;
            }
            case DENY: {
                return false;
            }
        }
        return DEFAULT;
    }

    private static boolean shouldSpreadTo(World world, int x, int y, int z, Block b) {
        boolean DEFAULT = world.func_147439_a(x, y, z) == Blocks.field_150346_d && world.func_72805_g(x, y, z) == 0 && world.func_72957_l(x, y + 1, z) >= 4 && world.getBlockLightOpacity(x, y + 1, z) <= 2;
        BlockSpreadEvent evt = new BlockSpreadEvent(world, x, y, z, b, DEFAULT);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        switch (evt.getResult()) {
            case ALLOW: {
                return true;
            }
            case DENY: {
                return false;
            }
        }
        return DEFAULT;
    }

    public static void fire(World world, int x, int y, int z, Random rand, Block b) {
        if (!world.field_72995_K) {
            if (DragonOptions.STOPUNLOADSPREAD.getState() && !world.func_72904_c(x - 6, y - 6, z - 6, x + 6, y + 6, z + 6)) {
                return;
            }
            if (BlockSpreadEvent.shouldDie(world, x, y, z, b)) {
                world.func_147449_b(x, y, z, Blocks.field_150346_d);
            } else if (world.func_72957_l(x, y + 1, z) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    int dz;
                    int dy;
                    int dx = x + rand.nextInt(3) - 1;
                    if (!BlockSpreadEvent.shouldSpreadTo(world, dx, dy = y + rand.nextInt(5) - 3, dz = z + rand.nextInt(3) - 1, b)) continue;
                    world.func_147449_b(dx, dy, dz, b);
                }
            }
        }
    }

    @Event.HasResult
    public static class BlockDeathEvent
    extends BlockSpreadEvent {
        public BlockDeathEvent(World world, int x, int y, int z, Block b, boolean flag) {
            super(world, x, y, z, b, flag);
        }
    }
}

