/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Event.Client;

import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class RenderItemInSlotEvent
extends Event {
    private final ItemStack item;
    public final int slotIndex;
    public final int slotX;
    public final int slotY;
    private final GuiContainer gui;
    public final Slot slot;
    private static long currentHoveredRenderItem;

    public RenderItemInSlotEvent(GuiContainer c, Slot s) {
        this.item = s.func_75211_c();
        this.slotIndex = s.getSlotIndex();
        this.slotX = s.field_75223_e;
        this.slotY = s.field_75221_f;
        this.gui = c;
        this.slot = s;
        if (this.item != null && this.isHovered()) {
            currentHoveredRenderItem = System.identityHashCode(this.item);
        }
    }

    protected RenderItemInSlotEvent(GuiContainer c, ItemStack is, int x, int y) {
        this.item = is;
        this.slotIndex = -1;
        this.slotX = x;
        this.slotY = y;
        this.gui = c;
        this.slot = null;
    }

    public ItemStack getItem() {
        return this.item != null ? this.item.func_77946_l() : null;
    }

    public boolean hasItem() {
        return this.item != null;
    }

    public static boolean isRenderingStackHovered(ItemStack is) {
        return is != null && (long)System.identityHashCode(is) == currentHoveredRenderItem;
    }

    public boolean isHovered() {
        int i = Mouse.getX() * this.gui.field_146294_l / this.gui.field_146297_k.field_71443_c;
        int j = this.gui.field_146295_m - Mouse.getY() * this.gui.field_146295_m / this.gui.field_146297_k.field_71440_d - 1;
        return this.gui.func_146981_a(this.slot, i, j);
    }

    public int getRelativeMouseX() {
        return ReikaGuiAPI.instance.getMouseRealX() - this.slotX - this.gui.field_147003_i;
    }

    public int getRelativeMouseY() {
        return ReikaGuiAPI.instance.getMouseRealY() - this.slotY - this.gui.field_147009_r;
    }

    public boolean guiInstanceOf(Class c) {
        return c.isAssignableFrom(this.gui.getClass());
    }

    public Class getGuiClass() {
        return this.gui.getClass();
    }

    public IInventory getSlotInventory() {
        return this.slot.field_75224_c;
    }

    public static void firePre(GuiContainer gc, Slot s) {
        MinecraftForge.EVENT_BUS.post((Event)new Pre(gc, s));
    }

    public static ItemStack fireMid(ItemStack is, GuiContainer gc, Slot s) {
        Mid mid = new Mid(gc, s, is);
        MinecraftForge.EVENT_BUS.post((Event)mid);
        return mid.itemToRender;
    }

    public static void firePost(GuiContainer gc, Slot s) {
        MinecraftForge.EVENT_BUS.post((Event)new Post(gc, s));
    }

    public static class Post
    extends RenderItemInSlotEvent {
        public Post(GuiContainer c, Slot s) {
            super(c, s);
            currentHoveredRenderItem = 0L;
        }
    }

    public static class Mid
    extends RenderItemInSlotEvent {
        public ItemStack itemToRender;

        public Mid(GuiContainer c, Slot s, ItemStack is) {
            super(c, s);
            this.itemToRender = is;
        }
    }

    public static class Pre
    extends RenderItemInSlotEvent {
        public Pre(GuiContainer c, Slot s) {
            super(c, s);
        }
    }
}

