/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Formula;

import Reika.DragonAPI.Instantiable.Formula.MathExpression;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;

public class InverseLogExpression
extends MathExpression {
    public final double baseVal;
    public final double scale;
    public final double base;

    public InverseLogExpression(double init, double scale, double base) {
        this.baseVal = init;
        this.scale = scale;
        this.base = base;
    }

    @Override
    public final double evaluate(double arg) throws ArithmeticException {
        return this.baseVal / (1.0 + this.scale * ReikaMathLibrary.logbase(arg + 1.0, this.base));
    }

    @Override
    public final double getBaseValue() {
        return this.baseVal;
    }

    @Override
    public final String toString() {
        return this.baseVal + "/(1+" + this.scale + "*(log_" + this.base + "(x+1)))";
    }
}

