/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.GUI;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.GUI.ImagedGuiButton;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Mouse;

public class GuiPainter {
    private final PaintElement[][] data;
    public final int posX;
    public final int posY;
    public final int width;
    public final int height;
    protected final int pixelSize;
    public PaintElement activeElement;
    private MultiMap<PaintElement, Point> locations = new MultiMap(MultiMap.CollectionType.HASHSET);
    public Brush brush = Brush.PIXEL;
    private boolean init;
    private static final Random rand = new Random();

    public GuiPainter(int x, int y, int w, int h, int s) {
        this.data = new PaintElement[w][h];
        this.pixelSize = s;
        this.posX = x;
        this.posY = y;
        this.width = w;
        this.height = h;
    }

    protected void init() {
        this.init = true;
        this.clear();
        this.init = false;
    }

    public void onRenderTick(int mx, int my) {
        if (this.activeElement != null && Mouse.isButtonDown((int)0) && mx >= this.posX && my >= this.posY && mx < this.posX + this.data.length * this.pixelSize && my < this.posY + this.data[0].length * this.pixelSize) {
            int x = mx - this.posX;
            int y = my - this.posY;
            Collection<Point> c = this.brush.getFill();
            for (Point p : c) {
                int dx = x + p.x;
                int dy = y + p.y;
                if (dx < 0 || dy < 0 || dx >= this.data.length || dy >= this.data[dx].length) continue;
                this.put(dx, dy, this.activeElement);
                this.activeElement.onPaintedTo(dx, dy);
            }
        }
    }

    public void draw() {
        for (int i = 0; i < this.data.length; ++i) {
            for (int k = 0; k < this.data[i].length; ++k) {
                PaintElement p = this.data[i][k];
                if (p == null) continue;
                int dx = this.posX + i * this.pixelSize;
                int dy = this.posY + k * this.pixelSize;
                p.draw(i, k, dx, dy, this.pixelSize, false);
            }
        }
        ReikaGuiAPI.instance.drawRectFrame(this.posX, this.posY, this.data.length * this.pixelSize, this.data[0].length * this.pixelSize, 0xFFFFFF);
    }

    protected void put(int dx, int dy, PaintElement p) {
        PaintElement prev = this.data[dx][dy];
        if (this.canReplace(prev, p)) {
            Point pt = new Point(dx, dy);
            this.locations.remove(prev, pt);
            this.data[dx][dy] = p;
            if (p != null) {
                this.locations.addValue(p, pt);
            }
        }
    }

    public void erase(int x, int y) {
        this.put(x, y, this.getFallbackEntry(x, y));
    }

    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            for (int k = 0; k < this.data[i].length; ++k) {
                this.data[i][k] = this.init ? this.getDefaultEntry(i, k) : this.getFallbackEntry(i, k);
            }
        }
    }

    protected PaintElement getDefaultEntry(int x, int y) {
        return this.getFallbackEntry(x, y);
    }

    protected PaintElement getFallbackEntry(int x, int y) {
        return null;
    }

    private boolean canReplace(PaintElement prev, PaintElement p) {
        return p == null || prev == null || p.isPaintable(prev);
    }

    public void drawLegend(int x, int y) {
        this.drawLegend(Minecraft.func_71410_x().field_71466_p, x, y);
    }

    public void drawLegend(FontRenderer f, int x, int y) {
        int dy = y;
        for (PaintElement p : this.locations.keySet()) {
            int s = 7;
            p.draw(0, 0, x, dy, s, true);
            ReikaGuiAPI.instance.drawRectFrame(x, dy, s, s, 0xFFFFFF);
            f.func_78276_b(p.getName(), x + s + 2, dy, 0xFFFFFF);
            dy += f.field_78288_b + 4;
        }
    }

    public PaintElement get(int x, int y) {
        return this.data[x][y];
    }

    public boolean isPainted(int x, int y) {
        return this.get(x, y) != this.getDefaultEntry(x, y);
    }

    public static enum Brush {
        PIXEL("1x1 Pixel"),
        X2("2x2 Square"),
        X3("3x3 Square"),
        DOT("4x4 Dot"),
        CROSS("3x3 '+'"),
        SQUARE("5x5 Square"),
        CIRCLE("5x5 Circle"),
        SPRAY("Random Spray");

        public final String name;
        public static final Brush[] brushList;

        private Brush(String n2) {
            this.name = n2;
        }

        public GuiButton getButton(int id, int x, int y) {
            ImagedGuiButton b = new ImagedGuiButton(id, x, y, 16, 16, this.ordinal() % 4 * 16, this.ordinal() / 4 * 16, this.name, 0xFFFFFF, false, "Resources/brushes.png", DragonAPICore.class);
            b.alignment = ImagedGuiButton.TextAlign.LEFT;
            b.textOffset = 18;
            b.textureSize = 64;
            return b;
        }

        public Collection<Point> getFill() {
            ArrayList<Point> c = new ArrayList<Point>();
            int r = 2;
            switch (this) {
                case CIRCLE: {
                    for (int i = -r; i <= r; ++i) {
                        for (int k = -r; k <= r; ++k) {
                            if (!(ReikaMathLibrary.py3d(i, 0.0, k) <= (double)r + 0.5)) continue;
                            c.add(new Point(i, k));
                        }
                    }
                    break;
                }
                case DOT: {
                    c.add(new Point(0, -1));
                    c.add(new Point(1, -1));
                    c.add(new Point(0, 0));
                    c.add(new Point(1, 0));
                    c.add(new Point(0, 1));
                    c.add(new Point(1, 1));
                    c.add(new Point(2, 0));
                    c.add(new Point(2, 1));
                    c.add(new Point(-1, 0));
                    c.add(new Point(-1, 1));
                    c.add(new Point(0, 2));
                    c.add(new Point(1, 2));
                    break;
                }
                case PIXEL: {
                    c.add(new Point(0, 0));
                    break;
                }
                case SPRAY: {
                    int n = GuiScreen.func_146272_n() ? 18 : 5 + rand.nextInt(4);
                    for (int i = 0; i < n; ++i) {
                        c.add(new Point(ReikaRandomHelper.getRandomPlusMinus(0, 4), ReikaRandomHelper.getRandomPlusMinus(0, 4)));
                    }
                    break;
                }
                case SQUARE: {
                    for (int i = -r; i <= r; ++i) {
                        for (int k = -r; k <= r; ++k) {
                            c.add(new Point(i, k));
                        }
                    }
                    break;
                }
                case CROSS: {
                    c.add(new Point(0, 0));
                    c.add(new Point(1, 0));
                    c.add(new Point(-1, 0));
                    c.add(new Point(0, 1));
                    c.add(new Point(0, -1));
                    break;
                }
                case X2: {
                    c.add(new Point(0, 0));
                    c.add(new Point(1, 0));
                    c.add(new Point(0, 1));
                    c.add(new Point(1, 1));
                    break;
                }
                case X3: {
                    for (int i = -1; i <= 1; ++i) {
                        for (int k = -1; k <= 1; ++k) {
                            c.add(new Point(i, k));
                        }
                    }
                    break;
                }
            }
            return c;
        }

        static {
            brushList = Brush.values();
        }
    }

    public static interface PaintElement {
        public void draw(int var1, int var2, int var3, int var4, int var5, boolean var6);

        public String getName();

        public boolean isPaintable(PaintElement var1);

        public void onPaintedTo(int var1, int var2);
    }
}

