/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.GUI;

import Reika.DragonAPI.Instantiable.GUI.ImagedGuiButton;
import Reika.DragonAPI.Instantiable.Math.DoublePolygon;
import Reika.DragonAPI.Instantiable.Rendering.ComplexSubdividedTexture;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class PolygonalGuiButton
extends ImagedGuiButton {
    private final DoublePolygon shape;
    private final ComplexSubdividedTexture texture;
    private int labelX;
    private int labelY;
    private boolean relativeLabel;
    private int defaultColor = 0xFFFFFF;
    private int hoverColor = 0xFFFFFF;
    private ButtonColorHook colorHook = null;

    public PolygonalGuiButton(int par1, String par4Str, Class mod, DoublePolygon p, ComplexSubdividedTexture tex) {
        super(par1, (int)p.getBounds().x, (int)p.getBounds().y, par4Str, mod);
        this.shape = p;
        this.texture = tex;
    }

    public PolygonalGuiButton(int par1, String par6Str, int par9, boolean par10, String file, Class mod, DoublePolygon p, ComplexSubdividedTexture tex) {
        super(par1, (int)p.getBounds().x, (int)p.getBounds().y, (int)p.getBounds().width, (int)p.getBounds().height, 0, 0, par6Str, par9, par10, file, mod);
        this.shape = p;
        this.texture = tex;
    }

    public PolygonalGuiButton(int par1, String file, String par6Str, int par9, boolean par10, Class mod, DoublePolygon p, ComplexSubdividedTexture tex) {
        super(par1, (int)p.getBounds().x, (int)p.getBounds().y, (int)p.getBounds().width, (int)p.getBounds().height, 0, 0, file, par6Str, par9, par10, mod);
        this.shape = p;
        this.texture = tex;
    }

    public PolygonalGuiButton setLabelPosition(int x, int y, boolean relative) {
        this.labelX = x;
        this.labelY = y;
        this.relativeLabel = relative;
        if (this.relativeLabel) {
            this.labelX = (int)((double)this.labelX + this.shape.getBounds().x);
            this.labelY = (int)((double)this.labelY + (this.shape.getBounds().y + this.shape.getBounds().height / 2.0 - (double)(this.renderer.field_78288_b / 2)));
        }
        return this;
    }

    @Override
    public ImagedGuiButton setTextAlign(ImagedGuiButton.TextAlign ta) {
        super.setTextAlign(ta);
        if (this.relativeLabel) {
            switch (this.alignment) {
                case LEFT: {
                    break;
                }
                case CENTER: {
                    break;
                }
            }
        }
        return this;
    }

    public PolygonalGuiButton setColorBlend(int basic, int hover) {
        this.defaultColor = basic;
        this.hoverColor = hover;
        return this;
    }

    public PolygonalGuiButton setColorCallback(ButtonColorHook bk) {
        this.colorHook = bk;
        return this;
    }

    @Override
    protected boolean isPositionWithin(int mx, int my) {
        return this.shape.contains(mx, my);
    }

    @Override
    protected void renderButton() {
        int a;
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        ReikaTextureHelper.bindTexture(this.modClass, this.getButtonTexture());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double cx = this.shape.getBounds().x + this.shape.getBounds().width / 2.0;
        double cy = this.shape.getBounds().y + this.shape.getBounds().height / 2.0;
        Tessellator.field_78398_a.func_78371_b(this.shape.npoints == 4 ? 7 : 6);
        int c = ReikaColorAPI.mixColors(this.hoverColor, this.defaultColor, this.getHoverFade());
        if (this.colorHook != null) {
            c = this.colorHook.getColor(c);
        }
        if ((a = c >> 24 & 0xFF) <= 0) {
            a = 255;
        }
        Tessellator.field_78398_a.func_78384_a(c & 0xFFFFFF, a);
        for (int i = 0; i < this.shape.npoints; ++i) {
            double x = this.shape.xpoints[i];
            double y = this.shape.ypoints[i];
            this.texture.addVertex(x, y);
        }
        Tessellator.field_78398_a.func_78381_a();
        if (this.field_146126_j != null && this.alignment != ImagedGuiButton.TextAlign.CENTER) {
            GL11.glLineWidth((float)3.0f);
            int ty = this.labelY + this.renderer.field_78288_b;
            int x2 = this.alignment == ImagedGuiButton.TextAlign.RIGHT ? this.labelX - this.renderer.func_78256_a(this.field_146126_j) - 2 : this.labelX + this.renderer.func_78256_a(this.field_146126_j) + 2;
            int x22 = this.alignment == ImagedGuiButton.TextAlign.RIGHT ? this.labelX + 2 : this.labelX - 2;
            ReikaGuiAPI.instance.drawLine(x2, ty, x22, ty, c);
            double dx = (double)x22 - cx;
            double dy = (double)ty - cy;
            double dr = Math.abs(dy) < 1.0 ? 0.5 : 0.2;
            ReikaGuiAPI.instance.drawLine((int)Math.round(cx + dx * dr), (int)Math.round(cy + dy * dr), x22, ty, c);
        }
    }

    @Override
    protected int getLabelX() {
        return this.labelX - this.alignment.getDX(this.renderer, this.field_146126_j) * 2;
    }

    @Override
    protected int getLabelY() {
        return this.labelY;
    }

    @Override
    public int getLabelColor() {
        int base = super.getLabelColor();
        if (this.colorHook != null) {
            return this.colorHook.getColor(base);
        }
        return base;
    }

    public static interface ButtonColorHook {
        public int getColor(int var1);
    }
}

