/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Math;

import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.ArrayDeque;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;

public class MovingAverage {
    private final int size;
    private final ArrayDeque<Double> data;
    private Double averageCache;
    private double lastPenalty = 0.0;

    public MovingAverage(int dataPoints) {
        this.size = dataPoints;
        this.data = new ArrayDeque(dataPoints);
        for (int i = 0; i < this.size; ++i) {
            this.data.add(0.0);
        }
        this.averageCache = null;
    }

    public MovingAverage addValue(double val) {
        this.data.add(val);
        this.data.remove();
        this.averageCache = null;
        return this;
    }

    public double getAverage() {
        return this.getAverage(0.0);
    }

    public double getAverage(double agePenalty) {
        if (agePenalty != this.lastPenalty) {
            this.averageCache = null;
        }
        if (this.averageCache != null) {
            return this.averageCache;
        }
        double avg = 0.0;
        int i = 0;
        for (double d : this.data) {
            if (d > 0.0 && agePenalty > 0.0) {
                d = Math.max(0.0, d * (1.0 - (double)i * agePenalty / (double)this.size));
            }
            avg += d;
            ++i;
        }
        this.averageCache = avg / (double)this.size;
        return this.averageCache;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("size", this.size);
        NBTTagList li = new NBTTagList();
        for (double d : this.data) {
            li.func_74742_a((NBTBase)new NBTTagDouble(d));
        }
        tag.func_74782_a("data", (NBTBase)li);
    }

    public static MovingAverage readFromNBT(NBTTagCompound tag) {
        int size = tag.func_74762_e("size");
        MovingAverage mv = new MovingAverage(size);
        mv.data.clear();
        NBTTagList li = tag.func_150295_c("data", ReikaNBTHelper.NBTTypes.DOUBLE.ID);
        for (int i = 0; i < li.func_74745_c(); ++i) {
            mv.data.add(((NBTTagDouble)li.field_74747_a.get(i)).func_150286_g());
        }
        while (mv.data.size() < mv.size) {
            mv.data.add(0.0);
        }
        mv.averageCache = null;
        return mv;
    }

    public String toString() {
        return this.getAverage() + "=" + this.data.toString();
    }
}

