/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Math.Noise;

import Reika.DragonAPI.Instantiable.Math.Noise.Octave;
import Reika.DragonAPI.Instantiable.Math.Noise.SimplexNoiseGenerator;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.util.MathHelper;

public abstract class NoiseGeneratorBase {
    protected double inputFactor = 1.0;
    protected final Collection<Octave> octaves = new ArrayList<Octave>();
    protected double maxRange = 1.0;
    public boolean clampEdge = false;
    public final long seed;
    private NoiseGeneratorBase xNoise;
    private NoiseGeneratorBase yNoise;
    private NoiseGeneratorBase zNoise;
    private double xNoiseScale;
    private double yNoiseScale;
    private double zNoiseScale;

    protected NoiseGeneratorBase(long s) {
        this.seed = s;
    }

    public final double getValue(double x, double z) {
        return this.calculateValues(x * this.inputFactor, 0.0, z * this.inputFactor, null);
    }

    public final double getValue(double x, double y, double z) {
        return this.calculateValues(x * this.inputFactor, y * this.inputFactor, z * this.inputFactor, null);
    }

    public final Object populateData(double x, double y, double z) {
        Object obj = this.constructObjectStorage();
        this.calculateValues(x * this.inputFactor, y * this.inputFactor, z * this.inputFactor, obj);
        return obj;
    }

    private double calculateValues(double x, double y, double z, Object obj) {
        if (this.displaceCalculation()) {
            double x0 = x;
            double y0 = y;
            double z0 = z;
            x += this.getXDisplacement(x0, y0, z0);
            y += this.getYDisplacement(x0, y0, z0);
            z += this.getZDisplacement(x0, y0, z0);
        }
        double val = this.calcValue(x, y, z, 1.0, 1.0, obj);
        if (!this.octaves.isEmpty()) {
            for (Octave o : this.octaves) {
                val += this.calcValue(x + o.phaseShift, y + o.phaseShift, z + o.phaseShift, o.frequency, o.amplitude, obj);
            }
            val = this.clampEdge ? MathHelper.func_151237_a((double)val, (double)-1.0, (double)1.0) : (val /= this.maxRange);
        }
        return val;
    }

    protected boolean displaceCalculation() {
        return true;
    }

    protected Object constructObjectStorage() {
        return null;
    }

    protected abstract double calcValue(double var1, double var3, double var5, double var7, double var9, Object var11);

    public final NoiseGeneratorBase setFrequency(double f) {
        this.inputFactor = f;
        return this;
    }

    public final double getFrequencyScale() {
        return this.inputFactor;
    }

    public final NoiseGeneratorBase addOctave(double relativeFrequency, double relativeAmplitude) {
        return this.addOctave(relativeFrequency, relativeAmplitude, 0.0);
    }

    public final NoiseGeneratorBase addOctave(double relativeFrequency, double relativeAmplitude, double phaseShift) {
        this.octaves.add(new Octave(relativeFrequency, relativeAmplitude, phaseShift));
        this.maxRange += relativeAmplitude;
        return this;
    }

    public final NoiseGeneratorBase setDisplacementSimple(long seedX, double fx, long seedZ, double fz, double s) {
        return this.setDisplacement(new SimplexNoiseGenerator(seedX).setFrequency(fx), s, null, s, new SimplexNoiseGenerator(seedZ).setFrequency(fz), s);
    }

    public final NoiseGeneratorBase setDisplacementSimple(long seedX, double fx, long seedY, double fy, long seedZ, double fz, double s) {
        return this.setDisplacement(new SimplexNoiseGenerator(seedX).setFrequency(fx), s, new SimplexNoiseGenerator(seedY).setFrequency(fy), s, new SimplexNoiseGenerator(seedZ).setFrequency(fz), s);
    }

    public final NoiseGeneratorBase setDisplacement(NoiseGeneratorBase x, NoiseGeneratorBase y, NoiseGeneratorBase z, double s) {
        return this.setDisplacement(x, s, y, s, z, s);
    }

    public final NoiseGeneratorBase setDisplacement(NoiseGeneratorBase x, double xs, NoiseGeneratorBase y, double ys, NoiseGeneratorBase z, double zs) {
        this.xNoise = x;
        this.yNoise = y;
        this.zNoise = z;
        this.xNoiseScale = xs;
        this.yNoiseScale = ys;
        this.zNoiseScale = zs;
        return this;
    }

    public final double getXDisplacement(double x, double y, double z) {
        return this.xNoise != null ? this.xNoise.getValue(x, y, z) * this.xNoiseScale : 0.0;
    }

    public final double getYDisplacement(double x, double y, double z) {
        return this.yNoise != null ? this.yNoise.getValue(x, y, z) * this.yNoiseScale : 0.0;
    }

    public final double getZDisplacement(double x, double y, double z) {
        return this.zNoise != null ? this.zNoise.getValue(x, y, z) * this.zNoiseScale : 0.0;
    }
}

