/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Math.Noise;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Math.Noise.NoiseGeneratorBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.util.MathHelper;

public class VoronoiNoiseGenerator
extends NoiseGeneratorBase {
    private static final int X_NOISE_GEN = 6971;
    private static final int Y_NOISE_GEN = 1013;
    private static final int Z_NOISE_GEN = 1619;
    private static final int SEED_NOISE_GEN = 31337;
    private static final double SQRT_3 = Math.sqrt(3.0);
    public boolean calculateDistance = false;
    public double randomFactor = 1.0;

    public VoronoiNoiseGenerator(long seed) {
        super(seed);
    }

    private int IntValueNoise3D(int x, int y, int z, int rseed) {
        int n = 6971 * x + 1013 * y + 1619 * z + 31337 * rseed & Integer.MAX_VALUE;
        n = n >> 13 ^ n;
        return n * (n * n * 60493 + 19990303) + 1376312589 & Integer.MAX_VALUE;
    }

    private double ValueNoise3D(int x, int y, int z, int rseed) {
        return 1.0 - (double)this.IntValueNoise3D(x, y, z, rseed) / 1.073741824E9;
    }

    @Override
    protected boolean displaceCalculation() {
        return false;
    }

    @Override
    protected Object constructObjectStorage() {
        return new Candidates();
    }

    @Override
    protected double calcValue(double x, double y, double z, double f, double a, Object obj) {
        if (f != 1.0 && f > 0.0) {
            x *= f;
            y *= f;
            z *= f;
        }
        int xInt = MathHelper.func_76128_c((double)x);
        int yInt = MathHelper.func_76128_c((double)y);
        int zInt = MathHelper.func_76128_c((double)z);
        ((Candidates)obj).candidateList.clear();
        for (int zCur = zInt - 2; zCur <= zInt + 2; ++zCur) {
            for (int yCur = yInt - 2; yCur <= yInt + 2; ++yCur) {
                for (int xCur = xInt - 2; xCur <= xInt + 2; ++xCur) {
                    double xPos = (double)xCur + this.randomFactor * this.ValueNoise3D(xCur, yCur, zCur, (int)this.seed);
                    double yPos = (double)yCur + this.randomFactor * this.ValueNoise3D(xCur, yCur, zCur, (int)this.seed + 1);
                    double zPos = (double)zCur + this.randomFactor * this.ValueNoise3D(xCur, yCur, zCur, (int)this.seed + 2);
                    double xDist = xPos - x;
                    double yDist = yPos - y;
                    double zDist = zPos - z;
                    double dist = xDist * xDist + yDist * yDist + zDist * zDist;
                    ((Candidates)obj).candidateList.add(new Root(xPos, yPos, zPos, dist));
                }
            }
        }
        ((Candidates)obj).sort();
        Root candidate = ((Candidates)obj).getClosest();
        double value = 0.0;
        if (this.calculateDistance) {
            value = candidate.distance * SQRT_3 - 1.0;
        }
        return value + this.ValueNoise3D(MathHelper.func_76128_c((double)((Root)candidate).position.xCoord), MathHelper.func_76128_c((double)((Root)candidate).position.yCoord), MathHelper.func_76128_c((double)((Root)candidate).position.zCoord), 0);
    }

    public DecimalPosition getClosestRoot(double x, double y, double z) {
        double x0 = x;
        double y0 = y;
        double z0 = z;
        Candidates c = (Candidates)this.populateData(x += this.getXDisplacement(x0, y0, z0), y += this.getYDisplacement(x0, y0, z0), z += this.getZDisplacement(x0, y0, z0));
        DecimalPosition raw = c.getClosest().position;
        return new DecimalPosition(raw.xCoord / this.inputFactor, raw.yCoord / this.inputFactor, raw.zCoord / this.inputFactor);
    }

    public Collection<DecimalPosition> getNeighborCellsAt(double x, double y, double z) {
        HashSet<DecimalPosition> ret = new HashSet<DecimalPosition>();
        int xInt = MathHelper.func_76128_c((double)(x *= this.inputFactor));
        int yInt = MathHelper.func_76128_c((double)(y *= this.inputFactor));
        int zInt = MathHelper.func_76128_c((double)(z *= this.inputFactor));
        for (int zCur = zInt - 2; zCur <= zInt + 2; ++zCur) {
            for (int yCur = yInt - 2; yCur <= yInt + 2; ++yCur) {
                for (int xCur = xInt - 2; xCur <= xInt + 2; ++xCur) {
                    double xPos = (double)xCur + this.randomFactor * this.ValueNoise3D(xCur, yCur, zCur, (int)this.seed);
                    double yPos = (double)yCur + this.randomFactor * this.ValueNoise3D(xCur, yCur, zCur, (int)this.seed + 1);
                    double zPos = (double)zCur + this.randomFactor * this.ValueNoise3D(xCur, yCur, zCur, (int)this.seed + 2);
                    ret.add(new DecimalPosition(xPos / this.inputFactor, yPos / this.inputFactor, zPos / this.inputFactor));
                }
            }
        }
        return ret;
    }

    public Collection<DecimalPosition> getCellsWithin3D(double x, double y, double z, double r) {
        HashSet<DecimalPosition> ret = new HashSet<DecimalPosition>();
        int xInt = MathHelper.func_76128_c((double)(x *= this.inputFactor));
        int yInt = MathHelper.func_76128_c((double)(y *= this.inputFactor));
        int zInt = MathHelper.func_76128_c((double)(z *= this.inputFactor));
        int dr = MathHelper.func_76143_f((double)((r *= this.inputFactor) + 2.0));
        for (int zCur = zInt - dr; zCur <= zInt + dr; ++zCur) {
            for (int yCur = yInt - dr; yCur <= yInt + dr; ++yCur) {
                for (int xCur = xInt - dr; xCur <= xInt + dr; ++xCur) {
                    double zPos;
                    double yPos;
                    double xPos = (double)xCur + this.randomFactor * this.ValueNoise3D(xCur, yCur, zCur, (int)this.seed);
                    DecimalPosition d = new DecimalPosition(xPos, yPos = (double)yCur + this.randomFactor * this.ValueNoise3D(xCur, yCur, zCur, (int)(-this.seed)), zPos = (double)zCur + this.randomFactor * this.ValueNoise3D(xCur, yCur, zCur, (int)(this.seed ^ 0xFFFFFFFFFFFFFFFFL)));
                    if (!(d.getDistanceTo(x, y, z) <= r)) continue;
                    ret.add(new DecimalPosition(d.xCoord / this.inputFactor, d.yCoord / this.inputFactor, d.zCoord / this.inputFactor));
                }
            }
        }
        return ret;
    }

    public Collection<DecimalPosition> getCellsWithin2D(double x, double z, double r) {
        HashSet<DecimalPosition> ret = new HashSet<DecimalPosition>();
        int xInt = MathHelper.func_76128_c((double)(x *= this.inputFactor));
        int zInt = MathHelper.func_76128_c((double)(z *= this.inputFactor));
        int dr = MathHelper.func_76143_f((double)((r *= this.inputFactor) + 2.0));
        for (int zCur = zInt - dr; zCur <= zInt + dr; ++zCur) {
            for (int xCur = xInt - dr; xCur <= xInt + dr; ++xCur) {
                double zPos;
                double xPos = (double)xCur + this.randomFactor * this.ValueNoise3D(xCur, 0, zCur, (int)this.seed);
                DecimalPosition d = new DecimalPosition(xPos, 0.0, zPos = (double)zCur + this.randomFactor * this.ValueNoise3D(xCur, 0, zCur, (int)(this.seed ^ 0xFFFFFFFFFFFFFFFFL)));
                if (!(d.getDistanceTo(x, 0.0, z) <= r)) continue;
                ret.add(new DecimalPosition(d.xCoord / this.inputFactor, 0.0, d.zCoord / this.inputFactor));
            }
        }
        return ret;
    }

    public double getEdgeRatio(double x, double z) {
        Candidates c = (Candidates)this.populateData(x, 0.0, z);
        x += this.getXDisplacement(x, 0.0, z);
        z += this.getZDisplacement(x, 0.0, z);
        DecimalPosition candidate1 = ((Root)c.candidateList.get(0)).position;
        DecimalPosition candidate2 = ((Root)c.candidateList.get(1)).position;
        double cx = (candidate1.xCoord + candidate2.xCoord) / (2.0 * this.inputFactor);
        double cy = (candidate1.zCoord + candidate2.zCoord) / (2.0 * this.inputFactor);
        double dx = (candidate2.xCoord - candidate1.xCoord) / this.inputFactor;
        double dy = (candidate2.zCoord - candidate1.zCoord) / this.inputFactor;
        double invslope = -dx / dy;
        double mpx = cx + 1.0;
        double mpy = cy + invslope;
        double dLx = mpx - cx;
        double dLy = mpy - cy;
        double num = dLy * x - dLx * z + mpx * cy - mpy * cx;
        double denom = dLx * dLx + dLy * dLy;
        double dist = Math.abs(num) / Math.sqrt(denom);
        return dist;
    }

    public boolean chunkContainsCenter(int x, int z) {
        DecimalPosition pos = this.getClosestRoot(x, 0.0, z);
        return pos.xCoord >= (double)x && pos.zCoord >= (double)z && pos.xCoord < (double)(x + 16) && pos.yCoord < (double)(z + 16);
    }

    private static final class Root
    implements Comparable<Root> {
        private final DecimalPosition position;
        private final double distance;

        private Root(double x, double y, double z, double d) {
            this.position = new DecimalPosition(x, y, z);
            this.distance = d;
        }

        @Override
        public int compareTo(Root o) {
            return Double.compare(this.distance, o.distance);
        }
    }

    private static class Candidates {
        private final ArrayList<Root> candidateList = new ArrayList();

        private Candidates() {
        }

        private void sort() {
            Collections.sort(this.candidateList);
        }

        private Root getClosest() {
            return this.candidateList.isEmpty() ? null : this.candidateList.get(0);
        }
    }
}

