/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Math;

import Reika.DragonAPI.Instantiable.Data.Maps.CountMap;
import java.util.ArrayList;
import java.util.Collections;

public class Statistics {
    private double mean;
    private double mode;
    private double median;
    private double sum;
    private final CountMap<Double> counts = new CountMap();
    private final ArrayList<Double> values = new ArrayList();

    public Statistics addValue(double val) {
        this.values.add(val);
        this.counts.increment(val);
        Collections.sort(this.values);
        this.sum += val;
        this.mean = this.sum / (double)this.values.size();
        if (val != this.mode && this.counts.get(val) > this.counts.get(this.mode)) {
            this.mode = val;
        }
        this.median = this.values.size() % 2 == 0 ? (this.values.get(this.values.size() / 2) + this.values.get(this.values.size() / 2 - 1)) / 2.0 : this.values.get(this.values.size() / 2);
        return this;
    }

    public double getMean() {
        return this.mean;
    }

    public double getMedian() {
        return this.median;
    }

    public double getMode() {
        return this.mode;
    }

    public double getSum() {
        return this.sum;
    }
}

