/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Math;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Math.Spline;
import java.util.ArrayList;
import java.util.List;

public class VariableEndpointSpline {
    public final DecimalPosition start;
    private final Spline curve;
    private final int pointCount;
    private DecimalPosition endpoint;
    private final ArrayList<DecimalPosition> roots = new ArrayList();
    private final ArrayList<Spline.BasicVariablePoint> points = new ArrayList();

    public VariableEndpointSpline(double x, double y, double z, double x2, double y2, double z2, Spline.SplineType t, int points, double variance, double velocity) {
        this(new DecimalPosition(x, y, z), new DecimalPosition(x2, y2, z2), t, points, variance, velocity);
    }

    public VariableEndpointSpline(DecimalPosition p, DecimalPosition p2, Spline.SplineType t, int points, double variance, double velocity) {
        this.curve = new Spline(t);
        this.pointCount = points;
        this.start = p;
        for (int i = 0; i <= this.pointCount; ++i) {
            Spline.BasicVariablePoint a = new Spline.BasicVariablePoint(new DecimalPosition(0.0, 0.0, 0.0), variance, velocity);
            a.tolerance = 0.0625;
            this.points.add(a);
            this.curve.addPoint(a);
        }
        this.setEndpoint(p2);
    }

    public void setEndpoint(double x, double y, double z) {
        this.setEndpoint(new DecimalPosition(x, y, z));
    }

    public void setEndpoint(DecimalPosition p) {
        if (this.endpoint != null && this.endpoint.equals(p)) {
            return;
        }
        this.endpoint = new DecimalPosition(p);
        this.calculateLine();
    }

    private void calculateLine() {
        this.roots.clear();
        for (int i = 0; i <= this.pointCount; ++i) {
            float f = (float)i / (float)this.pointCount;
            DecimalPosition r = DecimalPosition.interpolate(this.start, this.endpoint, f);
            this.roots.add(r);
            Spline.BasicVariablePoint b = this.points.get(i);
            b.setRelativeTo(r);
        }
    }

    public void tick() {
        for (int i = 0; i <= this.pointCount; ++i) {
            Spline.BasicVariablePoint p = this.points.get(i);
            if (i == 0) {
                p.posZ = 0.0;
                p.posY = 0.0;
                p.posX = 0.0;
                continue;
            }
            p.update();
        }
    }

    public List<DecimalPosition> getPoints(int fineness) {
        return this.curve.get(fineness, false);
    }
}

