/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.ParticleController;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import net.minecraft.entity.Entity;

public class SpringMotionController
implements PositionController {
    private final double xComponent;
    private final double yComponent;
    private final double zComponent;
    private final double maxAmplitude;
    private final double angularSpeed;
    private final double damping;
    private final DecimalPosition origin;
    private double linearPosition;
    private int tick;

    public SpringMotionController(double theta, double phi, double a, double v, double d, DecimalPosition p) {
        this(ReikaPhysicsHelper.polarToCartesian(1.0, theta, phi), a, v, d, p);
    }

    public SpringMotionController(double[] xyz, double a, double v, double d, DecimalPosition p) {
        this.xComponent = xyz[0];
        this.yComponent = xyz[1];
        this.zComponent = xyz[2];
        this.maxAmplitude = a;
        this.angularSpeed = v;
        this.damping = d;
        this.origin = p;
    }

    @Override
    public void update(Entity e) {
        ++this.tick;
        this.linearPosition = this.maxAmplitude * Math.pow(Math.E, -this.damping * (double)this.tick) * Math.cos(this.angularSpeed * (double)this.tick);
    }

    @Override
    public double getPositionX(Entity e) {
        return this.origin.xCoord + this.linearPosition * this.xComponent;
    }

    @Override
    public double getPositionY(Entity e) {
        return this.origin.yCoord + this.linearPosition * this.yComponent;
    }

    @Override
    public double getPositionZ(Entity e) {
        return this.origin.zCoord + this.linearPosition * this.zComponent;
    }
}

