/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class PreferentialItemStack {
    private ArrayList<String> oreNames = new ArrayList();
    private Collection<ItemStack> blacklist = new ArrayList<ItemStack>();
    private Collection<Item> itemblacklist = new ArrayList<Item>();
    private final ItemStack fallbackItem;

    public PreferentialItemStack(Item backup, String ... items) {
        this(new ItemStack(backup), items);
    }

    public PreferentialItemStack(Block backup, String ... items) {
        this(new ItemStack(backup), items);
    }

    public PreferentialItemStack(ItemStack backup, String ... items) {
        if (backup == null || backup.func_77973_b() == null) {
            throw new IllegalArgumentException("Invalid (nonexistent) fallback item!");
        }
        this.fallbackItem = backup;
        for (int i = 0; i < items.length; ++i) {
            this.oreNames.add(items[i]);
        }
    }

    public Object getItem() {
        String s = this.getStringToUse();
        return s != null ? s : this.fallbackItem;
    }

    public PreferentialItemStack blockItemStack(ItemStack is) {
        this.blacklist.add(is.func_77946_l());
        return this;
    }

    public PreferentialItemStack blockItem(Item i) {
        this.itemblacklist.add(i);
        return this;
    }

    private String getStringToUse() {
        for (String ore : this.oreNames) {
            ArrayList items = OreDictionary.getOres((String)ore);
            if (items == null) continue;
            for (ItemStack is : items) {
                if (is == null || is.func_77973_b() == null || this.itemblacklist.contains(is.func_77973_b()) || ReikaItemHelper.collectionContainsItemStack(this.blacklist, is)) continue;
                return ore;
            }
        }
        return null;
    }
}

