/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import net.minecraft.nbt.NBTTagCompound;

public class ProgressBar {
    private int tick;
    private int duration;
    private DurationCallback durationCall;

    public ProgressBar(int dur) {
        this.duration = dur;
    }

    public ProgressBar(DurationCallback call) {
        this.durationCall = call;
    }

    public boolean tick() {
        return this.tick(1);
    }

    public boolean tick(int amt) {
        this.updateDuration();
        if (this.tick + amt >= this.duration) {
            this.tick = (this.tick + amt) % this.duration;
            return true;
        }
        this.tick += amt;
        return false;
    }

    public int tickNoRollover() {
        return this.tickNoRollover(1);
    }

    public int tickNoRollover(int amt) {
        this.updateDuration();
        int max = Math.min(amt, this.duration - this.tick);
        this.tick += max;
        return max;
    }

    public boolean isComplete() {
        this.updateDuration();
        return this.tick >= this.duration;
    }

    public int getScaled(int len) {
        this.updateDuration();
        return this.tick * len / this.duration;
    }

    private void updateDuration() {
        if (this.durationCall != null) {
            this.duration = this.durationCall.getDuration();
        }
    }

    public int getTick() {
        return this.tick;
    }

    public int getDuration() {
        return this.duration;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("duration", this.duration);
        tag.func_74768_a("tick", this.tick);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.duration = tag.func_74762_e("duration");
        this.tick = tag.func_74762_e("tick");
    }

    public static interface DurationCallback {
        public int getDuration();
    }
}

