/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ExtraUtilsHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerBlockHandler;
import Reika.DragonAPI.ModList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class RayTracer {
    private double originX;
    private double originY;
    private double originZ;
    private double targetX;
    private double targetY;
    private double targetZ;
    public boolean airOnly = false;
    public boolean softBlocksOnly = false;
    public boolean allowFluids = true;
    public boolean uniDirectionalChecks = false;
    public boolean cacheBlockRay = false;
    private final ArrayList<BlockKey> forbiddenBlocks = new ArrayList();
    private final ArrayList<BlockKey> allowedBlocks = new ArrayList();
    private final ArrayList<BlockKey> allowedOneTimeBlocks = new ArrayList();
    private final HashSet<Coordinate> blockRay = new HashSet();
    private static final Collection<BlockKey> visuallyTransparent = new HashSet<BlockKey>();
    private static boolean loadedTransparent = false;

    public RayTracer(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.originX = x1;
        this.originY = y1;
        this.originZ = z1;
        this.targetX = x2;
        this.targetY = y2;
        this.targetZ = z2;
    }

    public RayTracer setOrigins(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.originX = x1;
        this.originY = y1;
        this.originZ = z1;
        this.targetX = x2;
        this.targetY = y2;
        this.targetZ = z2;
        this.blockRay.clear();
        return this;
    }

    public RayTracer offset(double dx, double dy, double dz) {
        return this.offset(dx, dy, dz, dx, dy, dz);
    }

    public RayTracer offset(double dx1, double dy1, double dz1, double dx2, double dy2, double dz2) {
        this.originX += dx1;
        this.originY += dy1;
        this.originZ += dz1;
        this.targetX += dx2;
        this.targetY += dy2;
        this.targetZ += dz2;
        this.blockRay.clear();
        return this;
    }

    public RayTracer addOpaqueBlock(Block b) {
        return this.addOpaqueBlock(b, -1);
    }

    public RayTracer addOpaqueBlock(Block b, int meta) {
        this.forbiddenBlocks.add(new BlockKey(b, meta));
        return this;
    }

    public RayTracer addTransparentBlock(Block b) {
        return this.addTransparentBlock(b, -1);
    }

    public RayTracer addTransparentBlock(Block b, int meta) {
        this.allowedBlocks.add(new BlockKey(b, meta));
        return this;
    }

    public RayTracer addOneTimeIgnoredBlock(Block b) {
        return this.addOneTimeIgnoredBlock(b, -1);
    }

    public RayTracer addOneTimeIgnoredBlock(Block b, int meta) {
        this.allowedOneTimeBlocks.add(new BlockKey(b, meta));
        return this;
    }

    public boolean isClearLineOfSight(World world) {
        Vec3 vec1 = Vec3.func_72443_a((double)this.originX, (double)this.originY, (double)this.originZ);
        Vec3 vec2 = Vec3.func_72443_a((double)this.targetX, (double)this.targetY, (double)this.targetZ);
        if (this.uniDirectionalChecks && new DecimalPosition(vec1).hashCode() < new DecimalPosition(vec2).hashCode()) {
            Vec3 vec = vec1;
            vec1 = vec2;
            vec2 = vec;
        }
        Vec3 ray = ReikaVectorHelper.subtract(vec1, vec2);
        double dx = vec2.field_72450_a - vec1.field_72450_a;
        double dy = vec2.field_72448_b - vec1.field_72448_b;
        double dz = vec2.field_72449_c - vec1.field_72449_c;
        double dd = ReikaMathLibrary.py3d(dx, dy, dz);
        for (double d = 0.25; d <= dd; d += 0.25) {
            int bz;
            int by;
            int bx;
            MovingObjectPosition mov;
            Vec3 vec0 = ReikaVectorHelper.scaleVector(ray, d);
            Vec3 vec = ReikaVectorHelper.scaleVector(ray, d - 0.25);
            vec0.field_72450_a += vec1.field_72450_a;
            vec0.field_72448_b += vec1.field_72448_b;
            vec0.field_72449_c += vec1.field_72449_c;
            vec.field_72450_a += vec1.field_72450_a;
            vec.field_72448_b += vec1.field_72448_b;
            vec.field_72449_c += vec1.field_72449_c;
            if (this.cacheBlockRay) {
                this.blockRay.add(new Coordinate(vec));
                this.blockRay.add(new Coordinate(vec0));
            }
            if ((mov = world.func_72933_a(vec, vec0)) == null || mov.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || !this.isNonTerminal(bx = mov.field_72311_b, by = mov.field_72312_c, bz = mov.field_72309_d) || !this.isDisallowedBlock(world, bx, by, bz)) continue;
            this.allowedOneTimeBlocks.clear();
            return false;
        }
        this.allowedOneTimeBlocks.clear();
        return true;
    }

    public Set<Coordinate> getRayBlocks() {
        return Collections.unmodifiableSet(this.blockRay);
    }

    private boolean isNonTerminal(int x, int y, int z) {
        if (x == MathHelper.func_76128_c((double)this.originX) && y == MathHelper.func_76128_c((double)this.originY) && z == MathHelper.func_76128_c((double)this.originZ)) {
            return false;
        }
        return x != MathHelper.func_76128_c((double)this.targetX) || y != MathHelper.func_76128_c((double)this.targetY) || z != MathHelper.func_76128_c((double)this.targetZ);
    }

    private boolean isDisallowedBlock(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        BlockKey key = new BlockKey(b, meta);
        if (this.airOnly && b != Blocks.field_150350_a) {
            return true;
        }
        if (this.allowedBlocks.contains(key)) {
            return false;
        }
        if (this.allowedOneTimeBlocks.contains(key)) {
            return false;
        }
        if (this.forbiddenBlocks.contains(key)) {
            return true;
        }
        if (!this.allowFluids && ReikaBlockHelper.isLiquid(b)) {
            return true;
        }
        return !ReikaWorldHelper.softBlocks((IBlockAccess)world, x, y, z) || this.softBlocksOnly && ReikaBlockHelper.isCollideable(world, x, y, z);
    }

    public boolean isBlockPassable(World world, int x, int y, int z) {
        return !this.isDisallowedBlock(world, x, y, z);
    }

    public static void addVisuallyTransparentBlock(Block b) {
        visuallyTransparent.add(new BlockKey(b));
    }

    public static void addVisuallyTransparentBlock(Block b, int meta) {
        visuallyTransparent.add(new BlockKey(b, meta));
    }

    private static void loadLastTransparent() {
        if (loadedTransparent) {
            return;
        }
        loadedTransparent = true;
        if (ModList.EXTRAUTILS.isLoaded() && ExtraUtilsHandler.getInstance().deco2ID != null) {
            RayTracer.addVisuallyTransparentBlock(ExtraUtilsHandler.getInstance().deco2ID, 1);
            RayTracer.addVisuallyTransparentBlock(ExtraUtilsHandler.getInstance().deco2ID, 2);
            RayTracer.addVisuallyTransparentBlock(ExtraUtilsHandler.getInstance().deco2ID, 4);
        }
        if (ModList.TINKERER.isLoaded() && TinkerBlockHandler.getInstance().clearGlassID != null) {
            RayTracer.addVisuallyTransparentBlock(TinkerBlockHandler.getInstance().clearGlassID);
        }
    }

    public static Collection<BlockKey> getTransparentBlocks() {
        return Collections.unmodifiableCollection(visuallyTransparent);
    }

    public static RayTracer getVisualLOS() {
        RayTracer trace = new RayTracer(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        RayTracer.loadLastTransparent();
        for (BlockKey bk : visuallyTransparent) {
            if (bk.hasMetadata()) {
                trace.addTransparentBlock(bk.blockID, bk.metadata);
                continue;
            }
            trace.addTransparentBlock(bk.blockID);
        }
        trace.allowFluids = true;
        return trace;
    }

    public static RayTracerWithCache getVisualLOSForRenderCulling() {
        RayTracer ret = RayTracer.getVisualLOS();
        return new RayTracerWithCache(ret);
    }

    public static <V> RayTracerWithCache getMultipointVisualLOSForRenderCulling(MultipointChecker<V> mc) {
        RayTracer ret = RayTracer.getVisualLOS();
        return new MultipointRayTracerWithCache(ret, mc);
    }

    public double getLength() {
        return ReikaMathLibrary.py3d(this.originX - this.targetX, this.originY - this.targetY, this.originZ - this.targetZ);
    }

    static {
        RayTracer.addVisuallyTransparentBlock(Blocks.field_150359_w);
        RayTracer.addVisuallyTransparentBlock(Blocks.field_150432_aD);
        RayTracer.addVisuallyTransparentBlock(Blocks.field_150410_aZ);
        RayTracer.addVisuallyTransparentBlock(Blocks.field_150411_aY);
        RayTracer.addVisuallyTransparentBlock(Blocks.field_150422_aJ);
        RayTracer.addVisuallyTransparentBlock(Blocks.field_150386_bk);
        RayTracer.addVisuallyTransparentBlock(Blocks.field_150474_ac);
        RayTracer.addVisuallyTransparentBlock((Block)Blocks.field_150362_t);
        RayTracer.addVisuallyTransparentBlock((Block)Blocks.field_150361_u);
        RayTracer.addVisuallyTransparentBlock((Block)Blocks.field_150329_H);
    }

    public static class RayTracerWithCache<V> {
        protected final RayTracer trace;
        private Boolean cachedRaytrace;
        private long lastTraceTick;
        private int lastTraceTileHash;

        private RayTracerWithCache(RayTracer ret) {
            this.trace = ret;
        }

        public final void setOrigins(double x1, double y1, double z1, double x2, double y2, double z2) {
            this.trace.setOrigins(x1, y1, z1, x2, y2, z2);
        }

        public final boolean isClearLineOfSight(Entity e) {
            return this.isClearLineOfSight(e, e.field_70170_p);
        }

        public final boolean isClearLineOfSight(TileEntity e) {
            return this.isClearLineOfSight(e, e.field_145850_b);
        }

        public final boolean isClearLineOfSight(V focus, World world) {
            this.update(focus, world);
            if (this.cachedRaytrace == null) {
                this.cachedRaytrace = this.getLOS(focus, world);
            }
            return this.cachedRaytrace;
        }

        protected boolean getLOS(V focus, World world) {
            return this.trace.isClearLineOfSight(world);
        }

        private final void update(Object focus, World world) {
            if (this.cachedRaytrace == null) {
                return;
            }
            long time = world.func_82737_E();
            int hash = System.identityHashCode(focus);
            if (time - this.lastTraceTick > 5L || hash != this.lastTraceTileHash) {
                this.cachedRaytrace = null;
                this.lastTraceTileHash = hash;
                this.lastTraceTick = time;
            }
        }
    }

    public static interface MultipointChecker<V> {
        public boolean isClearLineOfSight(V var1, RayTracer var2, World var3);
    }

    private static class MultipointRayTracerWithCache<V>
    extends RayTracerWithCache<V> {
        private final MultipointChecker<V> checker;

        private MultipointRayTracerWithCache(RayTracer ret, MultipointChecker<V> mc) {
            super(ret);
            this.checker = mc;
        }

        @Override
        protected boolean getLOS(V focus, World world) {
            return this.checker.isClearLineOfSight(focus, this.trace, world);
        }
    }
}

