/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import net.minecraft.world.World;

public class RevolvedPattern {
    public final int coreSize;
    public final int height;
    private final int size;
    private final FilledBlockArray data;

    public RevolvedPattern(World world, int c, int h, int r) {
        this.coreSize = c;
        this.height = h;
        this.size = r;
        this.data = new FilledBlockArray(world);
    }

    public RevolvedPattern addBlock(BlockKey bk, int layer, int main, int side) {
        this.data.setBlock(main, layer, side, bk);
        return this;
    }

    public RevolvedPattern addLayer(BlockKey[][] arr, int layer) {
        if (arr.length != this.size || arr[0].length != this.size) {
            throw new MisuseException("Layer does not fit!");
        }
        for (int i = 0; i < arr.length; ++i) {
            for (int k = 0; k < arr[i].length; ++k) {
                this.addBlock(arr[i][k], layer, i, k);
            }
        }
        return this;
    }

    public RevolvedPattern calculate() {
        FilledBlockArray fx = (FilledBlockArray)this.data.flipX();
        FilledBlockArray fz = (FilledBlockArray)this.data.flipZ();
        FilledBlockArray fxz = (FilledBlockArray)this.data.flipX().flipZ();
        if (this.coreSize > 1) {
            int n = this.coreSize - 1;
            fx.offset(-n, 0, 0);
            fz.offset(0, 0, -n);
            fxz.offset(-n, 0, -n);
        }
        this.data.addAll(fx);
        this.data.addAll(fz);
        this.data.addAll(fxz);
        return this;
    }

    public void populate(FilledBlockArray f) {
        f.addAll(this.data);
    }
}

