/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Worldgen;

import Reika.DragonAPI.Exception.UnreachableCodeException;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class ChunkSplicedGenerator {
    protected final Map<ChunkCoordIntPair, Map<Coordinate, BlockPlace>> data;
    protected final boolean isConcurrent;

    public ChunkSplicedGenerator(boolean concurrent) {
        this.isConcurrent = concurrent;
        this.data = this.isConcurrent ? new ConcurrentHashMap() : new HashMap();
    }

    public final void setBlock(int x, int y, int z, Block b) {
        this.place(x, y, z, new SetBlock(b));
    }

    public final void setBlock(int x, int y, int z, Block b, int meta) {
        this.place(x, y, z, new SetBlock(b, meta));
    }

    public final void setBlock(int x, int y, int z, BlockKey bk) {
        this.setBlock(x, y, z, bk.blockID, bk.metadata >= 0 ? bk.metadata : 0);
    }

    public void setAir(int x, int y, int z) {
        this.setBlock(x, y, z, Blocks.field_150350_a);
    }

    public final void setTileEntity(int x, int y, int z, Block b, int meta, TileCallback call) {
        this.place(x, y, z, new TileSet(call, b, meta));
    }

    protected abstract void place(int var1, int var2, int var3, BlockPlace var4);

    protected final void put(ChunkCoordIntPair key, Coordinate c, BlockPlace sb) {
        Map<Coordinate, BlockPlace> map = this.data.get(key);
        if (map == null) {
            map = this.isConcurrent ? new ConcurrentHashMap() : new HashMap();
            this.data.put(key, map);
        }
        map.put(c, sb);
    }

    public final void generate(World world, int chunkX, int chunkZ) {
        this.generate(world, new ChunkCoordIntPair(chunkX, chunkZ));
    }

    public final void generate(World world, ChunkCoordIntPair cp) {
        this.doGenerate(world, cp);
        this.data.remove(cp);
    }

    public final void generateAll(World world) {
        for (ChunkCoordIntPair cp : this.data.keySet()) {
            this.doGenerate(world, cp);
        }
        this.data.clear();
    }

    private void doGenerate(World world, ChunkCoordIntPair cp) {
        Map<Coordinate, BlockPlace> map = this.data.get(cp);
        if (map != null) {
            for (Coordinate c : map.keySet()) {
                BlockPlace bp = map.get(c);
                int x = (cp.field_77276_a << 4) + c.xCoord;
                int y = c.yCoord;
                int z = (cp.field_77275_b << 4) + c.zCoord;
                bp.place(world, x, y, z);
            }
        }
    }

    public final void clear() {
        this.data.clear();
    }

    public final void duplicate(ChunkSplicedGenerator c) {
        this.clear();
        this.data.putAll(c.data);
    }

    public final String toString() {
        return this.data.toString();
    }

    public static ChunkCoordIntPair getKey(int x, int z) {
        return new ChunkCoordIntPair(x >> 4, z >> 4);
    }

    public static interface TileCallback {
        public void onTilePlaced(World var1, int var2, int var3, int var4, TileEntity var5);

        public void readFromNBT(NBTTagCompound var1);

        public void writeToNBT(NBTTagCompound var1);
    }

    static class TileSet
    extends SetBlock {
        private final TileCallback callback;

        TileSet(TileCallback c, Block b, int m) {
            super(b, m);
            this.callback = c;
        }

        @Override
        public void place(World world, int x, int y, int z) {
            super.place(world, x, y, z);
            this.callback.onTilePlaced(world, x, y, z, world.func_147438_o(x, y, z));
        }

        @Override
        public void writeToNBT(NBTTagCompound ret) {
            super.writeToNBT(ret);
            NBTTagCompound tag = new NBTTagCompound();
            this.callback.writeToNBT(tag);
            ret.func_74782_a("tile", (NBTBase)tag);
            ret.func_74778_a("tileType", this.callback.getClass().getName());
        }

        private static TileSet construct(NBTTagCompound data) {
            try {
                String cn = data.func_74779_i("tileType");
                Block b = (Block)Block.field_149771_c.func_82594_a(data.func_74779_i("id"));
                int meta = data.func_74762_e("meta");
                TileCallback call = (TileCallback)Class.forName(cn).newInstance();
                call.readFromNBT(data.func_74775_l("tile"));
                return new TileSet(call, b, meta);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        protected String getTypeID() {
            return "Tile";
        }
    }

    static class SetBlock
    extends BlockPlace {
        private final Block block;
        private final int metadata;

        SetBlock(Block b) {
            this(b, 0);
        }

        SetBlock(Block b, int m) {
            this.block = b;
            this.metadata = m;
        }

        @Override
        public void place(World world, int x, int y, int z) {
            world.func_147465_d(x, y, z, this.block, this.metadata, 3);
            if (this.block.getLightValue((IBlockAccess)world, x, y, z) > 0) {
                world.func_147471_g(x, y, z);
                world.func_147479_m(x, y, z);
            }
        }

        @Override
        public final BlockKey asBlockKey() {
            return new BlockKey(this.block, this.metadata);
        }

        public final String toString() {
            return "SET " + this.asBlockKey().toString();
        }

        @Override
        public void writeToNBT(NBTTagCompound ret) {
            ret.func_74778_a("id", Block.field_149771_c.func_148750_c((Object)this.block));
            ret.func_74768_a("meta", this.metadata);
        }

        @Override
        protected String getTypeID() {
            return "Block";
        }
    }

    public static abstract class BlockPlace {
        public abstract void place(World var1, int var2, int var3, int var4);

        public abstract void writeToNBT(NBTTagCompound var1);

        public abstract BlockKey asBlockKey();

        public static BlockPlace readFromTag(NBTTagCompound tag) {
            String cl;
            switch (cl = tag.func_74779_i("type")) {
                case "Block": {
                    return new SetBlock((Block)Block.field_149771_c.func_82594_a(tag.func_74779_i("id")), tag.func_74762_e("meta"));
                }
                case "Tile": {
                    return TileSet.construct(tag);
                }
            }
            throw new UnreachableCodeException("Unrecognized BlockPlace type: " + cl);
        }

        public final NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            this.writeToNBT(tag);
            tag.func_74778_a("type", this.getTypeID());
            return tag;
        }

        protected abstract String getTypeID();
    }
}

