/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Worldgen;

import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public class OriginBlockCache {
    private final Collection<PositionedBlock> data = new HashSet<PositionedBlock>();
    public final int originX;
    public final int originY;
    public final int originZ;
    private ForgeDirection primaryDirection;

    public OriginBlockCache(int x, int y, int z, ForgeDirection dir) {
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        this.primaryDirection = dir;
    }

    public void flipX() {
        this.flip(0);
    }

    public void flipY() {
        this.flip(1);
    }

    public void flipZ() {
        this.flip(2);
    }

    private void flip(int i) {
        for (PositionedBlock b : this.data) {
            switch (i) {
                case 0: {
                    int dx = b.posX - this.originX;
                    b.posX = this.originX - dx;
                    break;
                }
                case 1: {
                    int dy = b.posY - this.originY;
                    b.posY = this.originY - dy;
                    break;
                }
                case 2: {
                    int dz = b.posZ - this.originZ;
                    b.posZ = this.originZ - dz;
                }
            }
        }
    }

    public void scale(double x, double y, double z) {
        for (PositionedBlock b : this.data) {
            int dx = b.posX - this.originX;
            int dy = b.posY - this.originY;
            int dz = b.posZ - this.originZ;
            b.posX = this.originX + (int)((double)dx * x);
            b.posY = this.originY + (int)((double)dy * y);
            b.posZ = this.originZ + (int)((double)dz * z);
        }
        ArrayList<PositionedBlock> c = new ArrayList<PositionedBlock>(this.data);
        for (PositionedBlock b : c) {
            for (int i = 0; i < (int)x; ++i) {
                for (int j = 0; j < (int)y; ++j) {
                    for (int k = 0; k < (int)z; ++k) {
                        this.data.add(new PositionedBlock(b.block, b.posX + i, b.posY + j, b.posZ + k));
                    }
                }
            }
        }
    }

    public void align(ForgeDirection dir) {
        for (PositionedBlock b : this.data) {
            int dx = b.posX - this.originX;
            int dy = b.posY - this.originY;
            int dz = b.posZ - this.originZ;
            if (Math.abs(dir.offsetX) != Math.abs(this.primaryDirection.offsetX)) {
                int sgn = (int)Math.signum(dir.offsetX + this.primaryDirection.offsetX);
                b.posX = this.originX + dz * sgn;
                b.posZ = this.originZ + dx * sgn;
                continue;
            }
            if (dir.offsetX == -this.primaryDirection.offsetX) {
                b.posX = this.originX - dx;
                continue;
            }
            if (dir.offsetZ != -this.primaryDirection.offsetZ) continue;
            b.posZ = this.originZ - dz;
        }
        this.primaryDirection = dir;
    }

    public void translate(int x, int y, int z) {
        Iterator<PositionedBlock> iterator = this.data.iterator();
        while (iterator.hasNext()) {
            PositionedBlock b;
            PositionedBlock positionedBlock = b = iterator.next();
            positionedBlock.posX = positionedBlock.posX + x;
            positionedBlock = b;
            positionedBlock.posY = positionedBlock.posY + y;
            positionedBlock = b;
            positionedBlock.posZ = positionedBlock.posZ + z;
        }
    }

    public void setBlock(int x, int y, int z, Block b) {
        this.setBlock(x, y, z, new ChunkSplicedGenerator.SetBlock(b));
    }

    public void setBlock(int x, int y, int z, Block b, int meta) {
        this.setBlock(x, y, z, new ChunkSplicedGenerator.SetBlock(b, meta));
    }

    public void setBlock(int x, int y, int z, ChunkSplicedGenerator.BlockPlace b) {
        this.data.add(new PositionedBlock(b, x, y, z));
    }

    public void setTileEntity(int x, int y, int z, Block b, int meta, ChunkSplicedGenerator.TileCallback tc) {
        this.data.add(new PositionedBlock(new ChunkSplicedGenerator.TileSet(tc, b, meta), x, y, z));
    }

    public void addToGenCache(ChunkSplicedGenerationCache world) {
        for (PositionedBlock b : this.data) {
            world.place(b.posX, b.posY, b.posZ, b.block);
        }
    }

    private static class PositionedBlock {
        private final ChunkSplicedGenerator.BlockPlace block;
        private int posX;
        private int posY;
        private int posZ;

        private PositionedBlock(ChunkSplicedGenerator.BlockPlace b, int x, int y, int z) {
            this.block = b;
            this.posX = x;
            this.posY = y;
            this.posZ = z;
        }

        public final int hashCode() {
            return this.posX + (this.posZ << 8) + (this.posY << 16);
        }

        public final boolean equals(Object o) {
            if (o instanceof PositionedBlock) {
                PositionedBlock p = (PositionedBlock)o;
                return p.posX == this.posX && p.posY == this.posY && p.posZ == this.posZ;
            }
            return false;
        }
    }
}

