/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Worldgen;

import Reika.DragonAPI.Instantiable.IO.ModLogger;
import Reika.DragonAPI.Libraries.Java.ReikaJVMParser;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class StackableBiomeDecorator
extends BiomeDecorator {
    private static LinkedList<DecoState> stateStack = new LinkedList();
    public static int STATE_STACK_LIMIT;

    public final void func_150512_a(World world, Random rand, BiomeGenBase biome, int x, int z) {
        if (!stateStack.isEmpty()) {
            // empty if block
        }
        if (stateStack.size() >= STATE_STACK_LIMIT) {
            this.getLogger().logError("STATE STACK IS TOO LARGE [" + stateStack.size() + "] TO SAFELY CONTINUE, ABORTING " + (Object)((Object)this) + " DECORATION IN CHUNK " + x + ", " + z);
            return;
        }
        stateStack.addLast(new DecoState(world, rand, x, z));
        this.updateFieldsFromStack();
        this.func_150513_a(biome);
        stateStack.removeLast();
        this.updateFieldsFromStack();
    }

    protected abstract ModLogger getLogger();

    private void updateFieldsFromStack() {
        DecoState s = stateStack.isEmpty() ? null : stateStack.getLast();
        this.field_76815_a = s != null ? s.world : null;
        this.field_76813_b = s != null ? s.rand : null;
        this.field_76814_c = s != null ? s.chunkX : 0;
        this.field_76811_d = s != null ? s.chunkZ : 0;
    }

    static {
        int limit = ReikaJVMParser.getArgumentInteger("-DragonAPI_DecoratorStackLimit", 250);
        STATE_STACK_LIMIT = limit > 0 ? limit : 250;
        ReikaJavaLibrary.pConsole("Biome state stack limit: " + STATE_STACK_LIMIT);
    }

    private static class DecoState {
        private final World world;
        private final Random rand;
        private final int chunkX;
        private final int chunkZ;

        private DecoState(World w, Random r, int x, int z) {
            this.world = w;
            this.rand = r;
            this.chunkX = x;
            this.chunkZ = z;
        }

        public String toString() {
            return this.chunkX + ", " + this.chunkZ + " in DIM" + this.world.field_73011_w.field_76574_g;
        }
    }
}

