/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.IO;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.IO.ReikaImageLoader;
import Reika.DragonAPI.IO.ReikaTextureBinder;
import Reika.DragonAPI.Instantiable.Data.Maps.NestedMap;
import Reika.DragonAPI.Instantiable.Event.Client.TextureReloadEvent;
import Reika.DragonAPI.Instantiable.IO.RemoteSourcedAsset;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackFileNotFoundException;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ReikaTextureHelper {
    private static final HashMap<TextureIdentifier, Integer> textures = new HashMap();
    private static final NestedMap<Class, String, TextureIdentifier> textureKeys = new NestedMap();
    private static final HashMap<ReikaDyeHelper, Integer> colorOverrides = new HashMap();
    private static boolean noColorPacks = false;
    public static final TextureMap dummyTextureMap = new TextureMap(-1, "");
    private static TextureMap itemTextureMap;
    public static final ReikaTextureBinder binder;
    public static final ResourceLocation font;
    private static final ResourceLocation particle;
    private static final ResourceLocation gui;
    private static final ResourceLocation hud;
    private static final ResourceLocation ench;

    public static boolean reload() {
        return Keyboard.isKeyDown((int)61) && Keyboard.isKeyDown((int)20);
    }

    public static void resetTexture(String tex) {
        textures.remove(ReikaTextureHelper.createTextureID(tex));
    }

    public static void resetTexture(Class c, String tex) {
        textures.remove(ReikaTextureHelper.createTextureID(c, tex));
    }

    public static int bindTexture(Class root, String tex) {
        return ReikaTextureHelper.bindTexture(root, tex, null);
    }

    public static int bindTexture(RemoteSourcedAsset rem) {
        if (ReikaTextureHelper.reload()) {
            textures.clear();
            colorOverrides.clear();
            MinecraftForge.EVENT_BUS.post((Event)new TextureReloadEvent());
            return 0;
        }
        TextureIdentifier id = ReikaTextureHelper.createTextureID(rem);
        Integer gl = textures.get(id);
        if (gl == null) {
            DragonAPICore.log("Loading dynamically sourced asset " + rem.path);
            try (InputStream data = rem.getData();){
                gl = ReikaTextureHelper.bindRawDataTexture(data);
            }
            catch (IOException e) {
                DragonAPICore.logError("Could not load asset!");
                e.printStackTrace();
                gl = binder.allocateAndSetupTexture(ReikaImageLoader.getMissingTex());
            }
            textures.put(id, gl);
        }
        GL11.glBindTexture((int)3553, (int)gl);
        return gl;
    }

    public static int bindTexture(Class root, String tex, ReikaImageLoader.ImageEditor img) {
        if (ReikaTextureHelper.reload()) {
            textures.clear();
            colorOverrides.clear();
            MinecraftForge.EVENT_BUS.post((Event)new TextureReloadEvent());
            return 0;
        }
        if (root == null) {
            throw new MisuseException("You cannot fetch a render texture with reference to a null class!");
        }
        String oldtex = tex;
        String s = root.getCanonicalName();
        String parent = s.substring(0, s.length() - root.getSimpleName().length() - 1).replaceAll("\\.", "/") + "/";
        if (tex.startsWith("/")) {
            tex = tex.substring(1);
        }
        String respath = tex.startsWith(parent) ? tex : parent + tex;
        TextureIdentifier id = ReikaTextureHelper.createTextureID(root, tex);
        Integer gl = textures.get(id);
        if (gl == null) {
            ArrayList<IResourcePack> li = ReikaTextureHelper.getCurrentResourcePacks();
            Collections.reverse(li);
            for (IResourcePack res : li) {
                gl = ReikaTextureHelper.bindPackTexture(root, respath, res, img);
                if (gl == null) continue;
                textures.put(id, gl);
                DragonAPICore.log("Texture Pack " + res.func_130077_b() + " contains an image for " + tex + ".");
                break;
            }
        }
        if (gl == null) {
            DragonAPICore.log("No texture packs contain an image for " + tex + ". Loading default.");
            gl = ReikaTextureHelper.bindClassReferencedTexture(root, oldtex, img);
            textures.put(id, gl);
        }
        GL11.glBindTexture((int)3553, (int)gl);
        return gl;
    }

    public static int bindFinalTexture(Class root, String tex) {
        TextureIdentifier id = ReikaTextureHelper.createTextureID(root, tex);
        Integer gl = textures.get(id);
        if (gl == null) {
            gl = ReikaTextureHelper.bindClassReferencedTexture(root, tex, null);
            textures.put(id, gl);
        }
        GL11.glBindTexture((int)3553, (int)gl);
        return gl;
    }

    private static Integer bindRawDataTexture(InputStream in) throws IOException {
        if (in == null) {
            DragonAPICore.logError("No image found!");
            return new Integer(binder.allocateAndSetupTexture(ReikaImageLoader.getMissingTex()));
        }
        BufferedImage img = ImageIO.read(in);
        if (img == null) {
            DragonAPICore.logError("No image found!");
            return new Integer(binder.allocateAndSetupTexture(ReikaImageLoader.getMissingTex()));
        }
        return new Integer(binder.allocateAndSetupTexture(img));
    }

    private static Integer bindClassReferencedTexture(Class root, String tex, ReikaImageLoader.ImageEditor editor) {
        BufferedImage img = ReikaImageLoader.readImage(root, tex, editor);
        if (img == null) {
            DragonAPICore.logError("No image found for " + tex + "!");
            return new Integer(binder.allocateAndSetupTexture(ReikaImageLoader.getMissingTex()));
        }
        return new Integer(binder.allocateAndSetupTexture(img));
    }

    public static int bindRawTexture(String tex) {
        TextureIdentifier id = ReikaTextureHelper.createTextureID(tex);
        Integer gl = textures.get(id);
        if (gl == null) {
            BufferedImage img = ReikaImageLoader.readHardPathImage(tex);
            if (img == null) {
                DragonAPICore.logError("No image found for " + tex + "!");
                gl = new Integer(binder.allocateAndSetupTexture(ReikaImageLoader.getMissingTex()));
                textures.put(id, gl);
            } else {
                gl = new Integer(binder.allocateAndSetupTexture(img));
                textures.put(id, gl);
            }
        }
        if (gl != null) {
            GL11.glBindTexture((int)3553, (int)gl);
        }
        return gl != null ? gl : 0;
    }

    public static int bindRawTexture(BufferedImage tex, String ids) {
        TextureIdentifier id = ReikaTextureHelper.createTextureID(ids);
        Integer gl = textures.get(id);
        if (gl == null) {
            gl = new Integer(binder.allocateAndSetupTexture(tex));
            textures.put(id, gl);
        }
        if (gl != null) {
            GL11.glBindTexture((int)3553, (int)gl);
        }
        return gl != null ? gl : 0;
    }

    private static Integer bindPackTexture(Class root, String tex, IResourcePack res, ReikaImageLoader.ImageEditor editor) {
        BufferedImage img = ReikaImageLoader.getImageFromResourcePack(tex, res, editor);
        return img != null ? new Integer(binder.allocateAndSetupTexture(img)) : null;
    }

    private static TextureIdentifier createTextureID(Class c, String tex) {
        TextureIdentifier ref = textureKeys.get(c, tex);
        if (ref == null) {
            ref = new ClassRefTexture(c, tex);
            textureKeys.put(c, tex, ref);
        }
        return ref;
    }

    private static TextureIdentifier createTextureID(String tex) {
        TextureIdentifier ref = textureKeys.get(null, tex);
        if (ref == null) {
            ref = new PathTexture(tex);
            textureKeys.put(null, tex, ref);
        }
        return ref;
    }

    private static TextureIdentifier createTextureID(RemoteSourcedAsset rem) {
        return ReikaTextureHelper.createTextureID(rem.reference, rem.path);
    }

    public static void bindTerrainTexture() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
    }

    public static void bindFontTexture() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(font);
    }

    public static void bindItemTexture() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
    }

    public static void bindGuiTexture() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(gui);
    }

    public static void bindEnchantmentTexture() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ench);
    }

    public static void bindHUDTexture() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(hud);
    }

    public static TextureMap getItemTextureMap() {
        if (itemTextureMap == null) {
            try {
                TextureManager mgr = Minecraft.func_71410_x().field_71446_o;
                Field f = mgr.getClass().getDeclaredField("listTickables");
                f.setAccessible(true);
                List li = (List)f.get(mgr);
                for (ITickableTextureObject obj : li) {
                    if (!(obj instanceof TextureMap) || ((TextureMap)obj).func_130086_a() != 1) continue;
                    itemTextureMap = (TextureMap)obj;
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return itemTextureMap;
    }

    public static int getIconHeight() {
        return 16;
    }

    public static IIcon getMissingIcon() {
        TextureMap tex = (TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b);
        return tex.func_110572_b("missingno");
    }

    public static ArrayList<IResourcePack> getCurrentResourcePacks() {
        ArrayList<IResourcePack> packs = new ArrayList<IResourcePack>();
        List li = Minecraft.func_71410_x().func_110438_M().func_110613_c();
        for (int i = 0; i < li.size(); ++i) {
            ResourcePackRepository.Entry e = (ResourcePackRepository.Entry)li.get(i);
            packs.add(e.func_110514_c());
        }
        return packs;
    }

    public static boolean isDefaultResourcePack() {
        return Minecraft.func_71410_x().func_110438_M().func_110613_c().isEmpty();
    }

    public static IResourcePack getDefaultResourcePack() {
        return Minecraft.func_71410_x().func_110438_M().field_110620_b;
    }

    public static InputStream getStreamFromTexturePack(String path, AbstractResourcePack pack) {
        return (InputStream)ReikaObfuscationHelper.invoke("getInputStreamByName", pack, path);
    }

    public static int getColorOverride(ReikaDyeHelper dye) {
        Integer color;
        if (ReikaTextureHelper.reload()) {
            colorOverrides.clear();
            noColorPacks = false;
        }
        if ((color = colorOverrides.get((Object)dye)) == null && !noColorPacks) {
            ReikaTextureHelper.initializeColorOverrides();
            color = colorOverrides.get((Object)dye);
        }
        return color != null ? color.intValue() : dye.getDefaultColor();
    }

    private static void initializeColorOverrides() {
        ArrayList<IResourcePack> li = ReikaTextureHelper.getCurrentResourcePacks();
        boolean loaded = false;
        for (int k = 0; k < li.size(); ++k) {
            AbstractResourcePack pack = (AbstractResourcePack)li.get(k);
            String path = "Reika/DragonAPI/dyecolor.txt";
            try (InputStream in = ReikaTextureHelper.getStreamFromTexturePack(path, pack);){
                if (in != null) {
                    try (BufferedReader p = new BufferedReader(new InputStreamReader(in));){
                        for (int i = 0; i < 16; ++i) {
                            String line = p.readLine();
                            String[] s = line.split(":");
                            int c = Color.decode(s[1]).getRGB();
                            Integer color = new Integer(c);
                            ReikaDyeHelper dye = ReikaDyeHelper.dyes[i];
                            colorOverrides.put(dye, color);
                        }
                    }
                    DragonAPICore.log("Found color override text file for texture pack " + pack.func_130077_b() + ".");
                    loaded = true;
                    continue;
                }
                if (!DragonOptions.LOGLOADING.getState()) continue;
                DragonAPICore.log("No color override found for texture pack " + pack.func_130077_b() + ".");
                continue;
            }
            catch (Exception e) {
                DragonAPICore.logError("Error reading color override text file for texture pack " + pack.func_130077_b() + ".");
                e.printStackTrace();
            }
        }
        if (!loaded) {
            DragonAPICore.log("Could not find color override text file in any resource packs. Using defaults.");
            for (int i = 0; i < 16; ++i) {
                ReikaDyeHelper dye = ReikaDyeHelper.dyes[i];
                int c = dye.getDefaultColor();
                Integer color = new Integer(c);
                colorOverrides.put(dye, color);
            }
            noColorPacks = true;
            return;
        }
    }

    public static void bindParticleTexture() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(particle);
    }

    public static int[][] getTextureData(IIcon ico, TextureMap map) {
        return map.func_110572_b(ico.func_94215_i()).func_147965_a(0);
    }

    public static void generateSpriteTextureData(String name, TextureMap map, int[][] ... data) {
        GenSprite tex = new GenSprite(name);
        tex.func_110968_a(ReikaJavaLibrary.makeListFrom(data));
        map.field_110574_e.put(name, tex);
    }

    static {
        binder = new ReikaTextureBinder();
        font = new ResourceLocation("textures/font/ascii.png");
        particle = new ResourceLocation("textures/particle/particles.png");
        gui = new ResourceLocation("textures/gui/widgets.png");
        hud = new ResourceLocation("textures/gui/icons.png");
        ench = new ResourceLocation("textures/misc/enchanted_item_glint.png");
        ReikaObfuscationHelper.registerExceptionHandler(new ResourcePackErrorSilencer());
    }

    private static abstract class TextureIdentifier {
        private TextureIdentifier() {
        }

        public abstract int hashCode();

        public abstract boolean equals(TextureIdentifier var1);

        public final boolean equals(Object o) {
            return o instanceof TextureIdentifier && this.equals(o);
        }
    }

    private static class ClassRefTexture
    extends TextureIdentifier {
        private final Class ref;
        private final String path;

        private ClassRefTexture(Class c, String p) {
            this.ref = c;
            this.path = p;
        }

        @Override
        public int hashCode() {
            return this.ref.hashCode() ^ this.path.hashCode();
        }

        @Override
        public boolean equals(TextureIdentifier o) {
            return o instanceof ClassRefTexture && ((ClassRefTexture)o).ref == this.ref && ((ClassRefTexture)o).path.equals(this.path);
        }
    }

    private static class PathTexture
    extends TextureIdentifier {
        private final String path;

        private PathTexture(String p) {
            this.path = p;
        }

        @Override
        public int hashCode() {
            return this.path.hashCode();
        }

        @Override
        public boolean equals(TextureIdentifier o) {
            return o instanceof PathTexture && ((PathTexture)o).path.equals(this.path);
        }
    }

    private static class GenSprite
    extends TextureAtlasSprite {
        protected GenSprite(String s) {
            super(s);
        }
    }

    private static class ResourcePackErrorSilencer
    implements ReikaObfuscationHelper.ReflectiveAccessExceptionHandler {
        private ResourcePackErrorSilencer() {
        }

        @Override
        public boolean handleException(Exception e) {
            return !(e.getCause() instanceof ResourcePackFileNotFoundException);
        }
    }
}

