/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.MathSci;

import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ChemicalElement;
import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaTimeHelper;
import java.util.ArrayList;
import net.minecraft.util.EnumChatFormatting;

public enum Isotopes implements ChemicalElement
{
    C14(5730.0, ReikaTimeHelper.YEAR, "Carbon-14", ElementGroup.NONMETAL),
    U235(7.04E8, ReikaTimeHelper.YEAR, "Uranium-235", ElementGroup.LANTHACTINIDE),
    U238(4.468E9, ReikaTimeHelper.YEAR, "Uranium-238", ElementGroup.LANTHACTINIDE),
    Pu239(2410.0, ReikaTimeHelper.YEAR, "Plutonium-239", ElementGroup.LANTHACTINIDE, true),
    Pu244(8.08E7, ReikaTimeHelper.YEAR, "Plutonium-244", ElementGroup.LANTHACTINIDE),
    Th232(1.405E10, ReikaTimeHelper.YEAR, "Thorium-232", ElementGroup.LANTHACTINIDE),
    Rn222(3.8235, ReikaTimeHelper.DAY, "Radon-222", ElementGroup.NONMETAL, true),
    Ra226(1601.0, ReikaTimeHelper.YEAR, "Radium-226", ElementGroup.ALKALI, true),
    Sr90(28.9, ReikaTimeHelper.YEAR, "Strontium-90", ElementGroup.ALKALI, true),
    Po210(138.376, ReikaTimeHelper.DAY, "Polonium-210", ElementGroup.TRANSITION, true),
    Cs134(2.065, ReikaTimeHelper.YEAR, "Cesium-134", ElementGroup.ALKALI),
    Xe135(6.57, ReikaTimeHelper.HOUR, "Xenon-135", ElementGroup.NONMETAL),
    Zr93(1530000.0, ReikaTimeHelper.YEAR, "Zirconium-93", ElementGroup.TRANSITION),
    Mo99(65.94, ReikaTimeHelper.HOUR, "Molybdenum-99", ElementGroup.TRANSITION),
    Cs137(30.17, ReikaTimeHelper.YEAR, "Cesium-137", ElementGroup.ALKALI, true),
    Tc99(211000.0, ReikaTimeHelper.YEAR, "Technetium-99", ElementGroup.TRANSITION),
    I131(8.02, ReikaTimeHelper.DAY, "Iodine-131", ElementGroup.NONMETAL, true),
    Pm147(2.62, ReikaTimeHelper.YEAR, "Promethium-147", ElementGroup.LANTHACTINIDE),
    I129(1.57E7, ReikaTimeHelper.YEAR, "Iodine-129", ElementGroup.NONMETAL),
    Sm151(90.0, ReikaTimeHelper.YEAR, "Samarium-151", ElementGroup.LANTHACTINIDE),
    Ru106(373.6, ReikaTimeHelper.DAY, "Ruthenium-106", ElementGroup.TRANSITION),
    Kr85(10.78, ReikaTimeHelper.YEAR, "Krypton-85", ElementGroup.NONMETAL),
    Pd107(6500000.0, ReikaTimeHelper.YEAR, "Palladium-107", ElementGroup.TRANSITION),
    Se79(327000.0, ReikaTimeHelper.YEAR, "Selenium-79", ElementGroup.NONMETAL),
    Gd155(4.76, ReikaTimeHelper.YEAR, "Gadolinium-155", ElementGroup.LANTHACTINIDE),
    Sb125(2.76, ReikaTimeHelper.YEAR, "Antimony-125", ElementGroup.TRANSITION),
    Sn126(230000.0, ReikaTimeHelper.YEAR, "Tin-126", ElementGroup.TRANSITION),
    Xe136(1.0E22, ReikaTimeHelper.YEAR, "Xenon-136", ElementGroup.NONMETAL),
    I135(6.6, ReikaTimeHelper.HOUR, "Iodine-135", ElementGroup.NONMETAL),
    Xe131(12.0, ReikaTimeHelper.DAY, "Xenon-131", ElementGroup.NONMETAL),
    Ru103(1.69, ReikaTimeHelper.TICK, "Ruthenium-103", ElementGroup.TRANSITION),
    Pm149(53.08, ReikaTimeHelper.HOUR, "Promethium-149", ElementGroup.LANTHACTINIDE),
    Rh105(35.36, ReikaTimeHelper.HOUR, "Rhodium-105", ElementGroup.TRANSITION);

    private final double half;
    public final int atomicWeight;
    public final String element;
    private final ReikaTimeHelper base;
    private final String name;
    public final boolean extraDanger;
    public final ElementGroup group;
    private DecayData decay;
    private static final Isotopes[] isoList;

    private Isotopes(double t, ReikaTimeHelper time, String n2, ElementGroup g) {
        this(t, time, n2, g, false);
    }

    private Isotopes(double t, ReikaTimeHelper time, String n2, ElementGroup g, boolean d) {
        this.half = t;
        this.base = time;
        this.name = n2;
        this.extraDanger = d;
        this.group = g;
        String s = this.name();
        while (!Character.isDigit(s.charAt(0))) {
            s = s.substring(1);
        }
        this.atomicWeight = Integer.parseInt(s);
        s = this.name();
        while (Character.isDigit(s.charAt(s.length() - 1))) {
            s = s.substring(0, s.length() - 1);
        }
        this.element = s;
    }

    public static Isotopes getIsotope(int i) {
        return isoList[i];
    }

    public static int getNumberIsotopes() {
        return isoList.length;
    }

    public double getHalfLife() {
        return this.half * (double)this.base.getDuration();
    }

    public double getMCHalfLife() {
        return this.half * (double)this.base.getMinecraftDuration();
    }

    public String toString() {
        return this.name;
    }

    public String getDisplayName() {
        if (this.extraDanger) {
            return EnumChatFormatting.RED.toString() + this.name;
        }
        return this.name;
    }

    public DecayData getDecay() {
        return this.decay;
    }

    @Override
    public int getAtomicWeight() {
        return this.atomicWeight;
    }

    @Override
    public String getChemicalSymbol() {
        return this.element;
    }

    public String getHalfLifeAsDisplay() {
        return String.format("%.3f%s%s", ReikaMathLibrary.getThousandBase(this.half), ReikaEngLibrary.getSIPrefix(this.half), this.base.getAbbreviation());
    }

    private static DecayData computeDecayData(Isotopes s) {
        ArrayList<ChemicalElement> li = new ArrayList<ChemicalElement>(ReikaJavaLibrary.makeListFromArray(isoList));
        li.add(new ChemicalElement(){

            @Override
            public int getAtomicWeight() {
                return 204;
            }

            @Override
            public String getChemicalSymbol() {
                return "Pb";
            }
        });
        li.add(new ChemicalElement(){

            @Override
            public int getAtomicWeight() {
                return 206;
            }

            @Override
            public String getChemicalSymbol() {
                return "Pb";
            }
        });
        li.add(new ChemicalElement(){

            @Override
            public int getAtomicWeight() {
                return 207;
            }

            @Override
            public String getChemicalSymbol() {
                return "Pb";
            }
        });
        li.add(new ChemicalElement(){

            @Override
            public int getAtomicWeight() {
                return 208;
            }

            @Override
            public String getChemicalSymbol() {
                return "Pb";
            }
        });
        for (ChemicalElement s2 : li) {
            if (s2.getAtomicWeight() != s.atomicWeight + 1) continue;
            return new DecayData(s2, 1.0);
        }
        for (ChemicalElement s2 : li) {
            if (s2.getAtomicWeight() != s.atomicWeight + 2) continue;
            return new DecayData(s2, 0.5);
        }
        ChemicalElement use = null;
        for (ChemicalElement s2 : li) {
            if (s2 instanceof Isotopes && s2 == s || s2.getAtomicWeight() > s.atomicWeight - 3 || use != null && s2.getAtomicWeight() <= use.getAtomicWeight()) continue;
            use = s2;
        }
        return use == null ? null : new DecayData(use, (double)s.atomicWeight / (double)use.getAtomicWeight());
    }

    static {
        for (Isotopes s : isoList = Isotopes.values()) {
            s.decay = Isotopes.computeDecayData(s);
        }
    }

    public static class DecayData {
        public final ChemicalElement isotope;
        public final double amount;

        private DecayData(ChemicalElement iso, double amt) {
            this.isotope = iso;
            this.amount = amt;
        }
    }

    public static enum ElementGroup {
        ALKALI("Alkali Metals"),
        TRANSITION("Transition Metals"),
        LANTHACTINIDE("Lanthanides and Actinides"),
        NONMETAL("Nonmetals");

        public final String displayName;

        private ElementGroup(String n2) {
            this.displayName = n2;
        }
    }
}

