/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public final class ReikaNBTHelper
extends DragonAPICore {
    private static final HashMap<Class, EnumIO> enumIOMap = new HashMap();

    public static void writeInvToNBT(ItemStack[] inv, NBTTagCompound NBT) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            inv[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        NBT.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public static ItemStack[] getInvFromNBT(NBTTagCompound NBT) {
        NBTTagList nbttaglist = NBT.func_150295_c("Items", NBTTypes.COMPOUND.ID);
        ItemStack[] inv = new ItemStack[nbttaglist.func_74745_c()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= inv.length) continue;
            inv[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
        return inv;
    }

    public static Fluid getFluidFromNBT(NBTTagCompound NBT) {
        String name = NBT.func_74779_i("liquid");
        if (name == null || name.isEmpty() || name.equals("empty")) {
            return null;
        }
        String repl = ReikaFluidHelper.getFluidNameSwap(name);
        if (repl != null && FluidRegistry.getFluid((String)repl) != null) {
            name = repl;
        }
        return FluidRegistry.getFluid((String)name);
    }

    public static void writeFluidToNBT(NBTTagCompound NBT, Fluid f) {
        String name = f != null ? f.getName() : "empty";
        NBT.func_74778_a("liquid", name);
    }

    public static Object getValue(NBTBase NBT) {
        return ReikaNBTHelper.getValue(NBT, null);
    }

    public static Object getValue(NBTBase NBT, NBTIO converter) {
        if (converter != null && converter.acceptsTag(NBT)) {
            return converter.createFromNBT(NBT);
        }
        if (NBT instanceof NBTTagInt) {
            return ((NBTTagInt)NBT).func_150287_d();
        }
        if (NBT instanceof NBTTagByte) {
            return ((NBTTagByte)NBT).func_150290_f();
        }
        if (NBT instanceof NBTTagShort) {
            return ((NBTTagShort)NBT).func_150289_e();
        }
        if (NBT instanceof NBTTagLong) {
            return ((NBTTagLong)NBT).func_150291_c();
        }
        if (NBT instanceof NBTTagFloat) {
            return Float.valueOf(((NBTTagFloat)NBT).func_150288_h());
        }
        if (NBT instanceof NBTTagDouble) {
            return ((NBTTagDouble)NBT).func_150286_g();
        }
        if (NBT instanceof NBTTagIntArray) {
            return ((NBTTagIntArray)NBT).func_150302_c();
        }
        if (NBT instanceof NBTTagString) {
            return ((NBTTagString)NBT).func_150285_a_();
        }
        if (NBT instanceof NBTTagByteArray) {
            return ((NBTTagByteArray)NBT).func_150292_c();
        }
        if (NBT instanceof NBTTagCompound) {
            if (((NBTTagCompound)NBT).func_74767_n("flag_isItemStack")) {
                return ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)NBT));
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            NBTTagCompound tag = (NBTTagCompound)NBT;
            for (Object o : tag.func_150296_c()) {
                String s = (String)o;
                map.put(s, ReikaNBTHelper.getValue(tag.func_74781_a(s), converter));
            }
            return map;
        }
        if (NBT instanceof NBTTagList) {
            ArrayList<Object> li = new ArrayList<Object>();
            for (Object o : ((NBTTagList)NBT).field_74747_a) {
                li.add(ReikaNBTHelper.getValue((NBTBase)o, converter));
            }
            return li;
        }
        return null;
    }

    public static NBTBase getTagForObject(Object o) {
        return ReikaNBTHelper.getTagForObject(o, null);
    }

    public static NBTBase getTagForObject(Object o, NBTIO converter) {
        if (converter != null && converter.acceptsType(o)) {
            return converter.convertToNBT(o);
        }
        if (o instanceof Integer || o.getClass() == Integer.TYPE) {
            return new NBTTagInt(((Integer)o).intValue());
        }
        if (o instanceof Byte || o.getClass() == Byte.TYPE) {
            return new NBTTagByte(((Byte)o).byteValue());
        }
        if (o instanceof Short || o.getClass() == Short.class) {
            return new NBTTagShort(((Short)o).shortValue());
        }
        if (o instanceof Long || o.getClass() == Long.class) {
            return new NBTTagLong(((Long)o).longValue());
        }
        if (o instanceof Float || o.getClass() == Float.class) {
            return new NBTTagFloat(((Float)o).floatValue());
        }
        if (o instanceof Double || o.getClass() == Double.class) {
            return new NBTTagDouble(((Double)o).doubleValue());
        }
        if (o instanceof int[]) {
            return new NBTTagIntArray((int[])o);
        }
        if (o instanceof String || o.getClass() == String.class) {
            return new NBTTagString((String)o);
        }
        if (o instanceof byte[]) {
            return new NBTTagByteArray((byte[])o);
        }
        if (o instanceof Map) {
            NBTTagCompound tag = new NBTTagCompound();
            Map m = (Map)o;
            for (Object k : m.keySet()) {
                if (!(k instanceof String)) continue;
                tag.func_74782_a((String)k, ReikaNBTHelper.getTagForObject(m.get(k), converter));
            }
            return tag;
        }
        if (o instanceof List || o instanceof Set) {
            NBTTagList li = new NBTTagList();
            for (Object o2 : (Collection)o) {
                li.func_74742_a(ReikaNBTHelper.getTagForObject(o2, converter));
            }
            return li;
        }
        if (o instanceof NBTBase) {
            return (NBTBase)o;
        }
        if (o instanceof ItemStack) {
            NBTTagCompound tag = ((ItemStack)o).func_77955_b(new NBTTagCompound());
            tag.func_74757_a("flag_isItemStack", true);
            return tag;
        }
        return null;
    }

    public static boolean isIntNumberTag(NBTBase tag) {
        return tag instanceof NBTTagInt || tag instanceof NBTTagByte || tag instanceof NBTTagShort || tag instanceof NBTTagLong;
    }

    public static boolean isNumberTag(NBTBase tag) {
        return ReikaNBTHelper.isIntNumberTag(tag) || tag instanceof NBTTagFloat || tag instanceof NBTTagDouble;
    }

    public static NBTBase compressNumber(NBTBase tag) {
        if (!ReikaNBTHelper.isIntNumberTag(tag)) {
            throw new MisuseException("Only integer-type numbers (byte, short, int, and long) can be compressed!");
        }
        long value = (Long)ReikaNBTHelper.getValue(tag);
        if (value > Integer.MAX_VALUE) {
            return new NBTTagLong(value);
        }
        if (value > 32767L) {
            return new NBTTagInt((int)value);
        }
        if (value > 127L) {
            return new NBTTagShort((short)value);
        }
        return new NBTTagByte((byte)value);
    }

    public static ArrayList<String> parseNBTAsLines(NBTTagCompound nbt) {
        return ReikaNBTHelper.parseNBTAsLines(nbt, 0);
    }

    private static ArrayList<String> parseNBTAsLines(NBTTagCompound nbt, int indent) {
        ArrayList<String> li = new ArrayList<String>();
        Iterator it = nbt.func_150296_c().iterator();
        String idt = ReikaStringParser.getNOf("  ", indent);
        for (Object o : nbt.func_150296_c()) {
            String key = (String)o;
            NBTBase b = nbt.func_74781_a(key);
            if (b instanceof NBTTagCompound) {
                li.add(idt + key + ": ");
                li.addAll(ReikaNBTHelper.parseNBTAsLines((NBTTagCompound)b, indent + 1));
                continue;
            }
            li.add(idt + key + ": " + b.toString());
        }
        return li;
    }

    public static void combineNBT(NBTTagCompound tag1, NBTTagCompound tag2) {
        if (tag2 == null || tag2.func_82582_d()) {
            return;
        }
        for (Object o : tag2.func_150296_c()) {
            String s = (String)o;
            NBTBase key = tag2.func_74781_a(s);
            tag1.func_74782_a(s, ReikaNBTHelper.combineTags(tag1.func_74781_a(s), key.func_74737_b()));
        }
    }

    private static NBTBase combineTags(NBTBase a, NBTBase b) {
        if (a != null && b == null) {
            return a;
        }
        if (a == null || a.getClass() != b.getClass()) {
            return b;
        }
        if (a instanceof NBTTagCompound) {
            ReikaNBTHelper.combineNBT((NBTTagCompound)a, (NBTTagCompound)b);
            return a;
        }
        if (a instanceof NBTTagList) {
            for (Object o : ((NBTTagList)b).field_74747_a) {
                ((NBTTagList)a).func_74742_a((NBTBase)o);
            }
        }
        return b;
    }

    public static void clearTagCompound(NBTTagCompound dat) {
        ArrayList tags = new ArrayList(dat.func_150296_c());
        for (String tag : tags) {
            dat.func_82580_o(tag);
        }
    }

    public static void copyNBT(NBTTagCompound from, NBTTagCompound to) {
        ArrayList tags = new ArrayList(from.func_150296_c());
        for (String tag : tags) {
            to.func_74782_a(tag, from.func_74781_a(tag).func_74737_b());
        }
    }

    public static int compareNBTTags(NBTTagCompound o1, NBTTagCompound o2) {
        if (o1 == o2 || o1 != null && o1.equals((Object)o2)) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return Integer.compare(o1.hashCode(), o2.hashCode());
    }

    public static boolean areNBTTagsEqual(NBTTagCompound tag1, NBTTagCompound tag2) {
        if (tag1 == tag2) {
            return true;
        }
        if (tag1 == null || tag2 == null) {
            return false;
        }
        return tag1.equals((Object)tag2);
    }

    public static boolean tagContains(NBTTagCompound tag, NBTTagCompound inner) {
        Set set = inner.func_150296_c();
        for (String s : set) {
            NBTBase b2;
            NBTBase b1 = inner.func_74781_a(s);
            if (b1 == (b2 = tag.func_74781_a(s))) continue;
            if (b1 == null || b2 == null) {
                return false;
            }
            if (b1.equals((Object)b2)) continue;
            return false;
        }
        return true;
    }

    public static NBTTypes getTagType(NBTBase base) {
        return (NBTTypes)((Object)NBTTypes.IDMap.get(base.func_74732_a()));
    }

    public static void overwriteNBT(NBTTagCompound tag, NBTTagCompound over) {
        for (Object o : over.func_150296_c()) {
            NBTBase b = over.func_74781_a((String)o);
            tag.func_74782_a((String)o, b);
        }
    }

    public static void addListToTags(NBTTagList tag, List<Object> li) {
        for (Object o : li) {
            NBTBase b = ReikaNBTHelper.getTagForObject(o);
            if (b == null) continue;
            tag.func_74742_a(b);
        }
    }

    public static void addMapToTags(NBTTagCompound tag, HashMap<String, Object> map) {
        for (String s : map.keySet()) {
            Object o = map.get(s);
            NBTBase b = ReikaNBTHelper.getTagForObject(o);
            if (b == null) continue;
            tag.func_74782_a(s, b);
        }
    }

    public static HashMap<String, ?> readMapFromNBT(NBTTagCompound tag) {
        return (HashMap)ReikaNBTHelper.getValue((NBTBase)tag);
    }

    public static void writeMapToNBT(String s, NBTTagCompound tag, Map<String, ?> map) {
        NBTBase dat = ReikaNBTHelper.getTagForObject(map);
        tag.func_74782_a(s, dat);
    }

    public static <K, V> void writeMapToNBT(Map<K, V> map, NBTTagList li, NBTIO<K> converterK, NBTIO<V> converterV) {
        for (Map.Entry<K, V> e : map.entrySet()) {
            NBTTagCompound entry = new NBTTagCompound();
            entry.func_74782_a("key", ReikaNBTHelper.getTagForObject(e.getKey(), converterK));
            entry.func_74782_a("value", ReikaNBTHelper.getTagForObject(e.getValue(), converterV));
            li.func_74742_a((NBTBase)entry);
        }
    }

    public static <K, V> void readMapFromNBT(Map<K, V> map, NBTTagList li, NBTIO<K> converterK, NBTIO<V> converterV) {
        map.clear();
        for (Object o : li.field_74747_a) {
            NBTTagCompound entry = (NBTTagCompound)o;
            Object key = ReikaNBTHelper.getValue(entry.func_74781_a("key"), converterK);
            Object val = ReikaNBTHelper.getValue(entry.func_74781_a("value"), converterV);
            map.put(key, val);
        }
    }

    public static <E> void writeCollectionToNBT(Collection<E> c, NBTTagCompound NBT, String key) {
        ReikaNBTHelper.writeCollectionToNBT(c, NBT, key, null);
    }

    public static <E> void writeCollectionToNBT(Collection<E> c, NBTTagCompound NBT, String key, NBTIO<E> converter) {
        NBTTagList li = new NBTTagList();
        for (E o : c) {
            NBTBase b = ReikaNBTHelper.getTagForObject(o, converter);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("value", b);
            li.func_74742_a((NBTBase)tag);
        }
        NBT.func_74782_a(key, (NBTBase)li);
    }

    public static <E> void readCollectionFromNBT(Collection<E> c, NBTTagCompound NBT, String key) {
        ReikaNBTHelper.readCollectionFromNBT(c, NBT, key, null);
    }

    public static <E> void readCollectionFromNBT(Collection<E> c, NBTTagCompound NBT, String key, NBTIO<E> converter) {
        c.clear();
        NBTTagList li = NBT.func_150295_c(key, NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            NBTTagCompound tag = (NBTTagCompound)o;
            NBTBase b = tag.func_74781_a("value");
            c.add(ReikaNBTHelper.getValue(b, converter));
        }
    }

    public static NBTBase getNestedNBTTag(NBTTagCompound tag, ArrayList<String> li, String name) {
        for (String s : li) {
            if ((tag = tag.func_74775_l(s)) != null && !tag.func_82582_d()) continue;
            return null;
        }
        return tag.func_74781_a(name);
    }

    public static void replaceTag(NBTTagCompound NBT, String s, NBTBase tag) {
        NBT.func_74782_a(s, tag);
    }

    public static void replaceTag(NBTTagList NBT, int idx, NBTBase tag) {
        NBT.field_74747_a.remove(idx);
        NBT.field_74747_a.add(idx, tag);
    }

    public static NBTIO<? extends Enum> getEnumConverter(Class<? extends Enum> c) {
        EnumIO handler = enumIOMap.get(c);
        if (handler == null) {
            handler = new EnumIO(c);
            enumIOMap.put(c, handler);
        }
        return handler;
    }

    private static class EnumIO
    implements NBTIO<Enum> {
        private final Enum[] objects;
        private final Class enumType;

        private EnumIO(Class<? extends Enum> c) {
            this.objects = c.getEnumConstants();
            this.enumType = c;
        }

        @Override
        public Enum createFromNBT(NBTBase nbt) {
            return this.objects[((NBTTagInt)nbt).func_150287_d()];
        }

        @Override
        public NBTBase convertToNBT(Enum obj) {
            return new NBTTagInt(obj.ordinal());
        }

        @Override
        public boolean acceptsType(Object o) {
            return o instanceof Enum;
        }

        @Override
        public boolean acceptsTag(NBTBase tag) {
            return tag instanceof NBTTagInt;
        }
    }

    public static class UUIDConverter
    implements NBTIO<UUID> {
        public static final UUIDConverter instance = new UUIDConverter();

        private UUIDConverter() {
        }

        @Override
        public UUID createFromNBT(NBTBase nbt) {
            return UUID.fromString(((NBTTagString)nbt).func_150285_a_());
        }

        @Override
        public NBTBase convertToNBT(UUID obj) {
            return new NBTTagString(obj.toString());
        }

        @Override
        public boolean acceptsType(Object o) {
            return o instanceof UUID;
        }

        @Override
        public boolean acceptsTag(NBTBase tag) {
            return tag instanceof NBTTagString;
        }
    }

    public static class KeyedItemStackConverter
    implements NBTIO<KeyedItemStack> {
        public static final KeyedItemStackConverter instance = new KeyedItemStackConverter();

        private KeyedItemStackConverter() {
        }

        @Override
        public KeyedItemStack createFromNBT(NBTBase nbt) {
            return KeyedItemStack.readFromNBT((NBTTagCompound)nbt);
        }

        @Override
        public NBTBase convertToNBT(KeyedItemStack obj) {
            NBTTagCompound ret = new NBTTagCompound();
            obj.writeToNBT(ret);
            return ret;
        }

        @Override
        public boolean acceptsType(Object o) {
            return o instanceof KeyedItemStack;
        }

        @Override
        public boolean acceptsTag(NBTBase tag) {
            return tag instanceof NBTTagCompound;
        }
    }

    public static class ItemStackConverter
    implements NBTIO<ItemStack> {
        public static final ItemStackConverter instance = new ItemStackConverter();

        private ItemStackConverter() {
        }

        @Override
        public ItemStack createFromNBT(NBTBase nbt) {
            return ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbt));
        }

        @Override
        public NBTBase convertToNBT(ItemStack obj) {
            NBTTagCompound ret = new NBTTagCompound();
            obj.func_77955_b(ret);
            return ret;
        }

        @Override
        public boolean acceptsType(Object o) {
            return o instanceof ItemStack;
        }

        @Override
        public boolean acceptsTag(NBTBase tag) {
            return tag instanceof NBTTagCompound;
        }
    }

    public static class ItemConverter
    implements NBTIO<Item> {
        public static final ItemConverter instance = new ItemConverter();

        private ItemConverter() {
        }

        @Override
        public Item createFromNBT(NBTBase nbt) {
            return (Item)Item.field_150901_e.func_82594_a(((NBTTagString)nbt).func_150285_a_());
        }

        @Override
        public NBTBase convertToNBT(Item obj) {
            return new NBTTagString(Item.field_150901_e.func_148750_c((Object)obj));
        }

        @Override
        public boolean acceptsType(Object o) {
            return o instanceof Item;
        }

        @Override
        public boolean acceptsTag(NBTBase tag) {
            return tag instanceof NBTTagString;
        }
    }

    public static class BlockConverter
    implements NBTIO<Block> {
        public static final BlockConverter instance = new BlockConverter();

        private BlockConverter() {
        }

        @Override
        public Block createFromNBT(NBTBase nbt) {
            return Block.func_149684_b((String)((NBTTagString)nbt).func_150285_a_());
        }

        @Override
        public NBTBase convertToNBT(Block obj) {
            return new NBTTagString(Block.field_149771_c.func_148750_c((Object)obj));
        }

        @Override
        public boolean acceptsType(Object o) {
            return o instanceof Block;
        }

        @Override
        public boolean acceptsTag(NBTBase tag) {
            return tag instanceof NBTTagString;
        }
    }

    public static interface NBTIO<V> {
        public V createFromNBT(NBTBase var1);

        public NBTBase convertToNBT(V var1);

        public boolean acceptsType(Object var1);

        public boolean acceptsTag(NBTBase var1);
    }

    public static enum NBTTypes {
        INT(new NBTTagInt(0).func_74732_a()),
        BYTE(new NBTTagByte(0).func_74732_a()),
        SHORT(new NBTTagShort(0).func_74732_a()),
        FLOAT(new NBTTagFloat(0.0f).func_74732_a()),
        DOUBLE(new NBTTagDouble(0.0).func_74732_a()),
        LONG(new NBTTagLong(0L).func_74732_a()),
        INTA(new NBTTagIntArray(new int[0]).func_74732_a()),
        BYTEA(new NBTTagByteArray(new byte[0]).func_74732_a()),
        STRING(new NBTTagString("").func_74732_a()),
        LIST(new NBTTagList().func_74732_a()),
        COMPOUND(new NBTTagCompound().func_74732_a()),
        END(0);

        public final int ID;
        private static final NBTTypes[] list;
        private static final HashMap<Integer, NBTTypes> IDMap;

        private NBTTypes(int id) {
            this.ID = id;
        }

        static {
            list = NBTTypes.values();
            IDMap = new HashMap();
            for (int i = 0; i < list.length; ++i) {
                IDMap.put(NBTTypes.list[i].ID, list[i]);
            }
        }
    }
}

