/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.Bees;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Interfaces.BlockCheck;
import forestry.api.apiculture.FlowerManager;
import forestry.api.genetics.IFlower;
import forestry.api.genetics.IFlowerAcceptableRule;
import forestry.api.genetics.IFlowerGrowthHelper;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IFlowerRegistry;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class BlockCheckFlowerProvider
implements IFlowerProvider,
IFlowerAcceptableRule {
    public final BlockCheck block;
    private final String id;

    public BlockCheckFlowerProvider(Block b, String id) {
        this(b, -1, id);
    }

    public BlockCheckFlowerProvider(Block b, int meta, String id) {
        this(new BlockKey(b, meta), id);
    }

    public BlockCheckFlowerProvider(BlockCheck bk, String id) {
        this.block = bk;
        this.id = id;
        FlowerManager.flowerRegistry.registerAcceptableFlower(this.block.asBlockKey().blockID, this.block.asBlockKey().metadata, new String[]{this.id});
        FlowerManager.flowerRegistry.registerAcceptableFlowerRule((IFlowerAcceptableRule)this, new String[]{this.id});
    }

    public final String getFlowerType() {
        return this.id;
    }

    public final boolean isAcceptedFlower(World world, int x, int y, int z) {
        return this.block.matchInWorld(world, x, y, z);
    }

    public boolean isAcceptedPollinatable(World world, IPollinatable ip) {
        return false;
    }

    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        return products;
    }

    @Deprecated
    public final boolean growFlower(World world, IIndividual individual, int x, int y, int z) {
        return false;
    }

    public final Set<IFlower> getFlowers() {
        return new HashSet<IFlower>();
    }

    public boolean growFlower(IFlowerGrowthHelper helper, String flowerType, World world, int x, int y, int z) {
        return false;
    }

    public final boolean growFlower(IFlowerRegistry fr, String flowerType, World world, IIndividual individual, int x, int y, int z) {
        return false;
    }

    public final boolean isAcceptableFlower(String flowerType, World world, int x, int y, int z) {
        return this.id.equals(flowerType) && this.block.matchInWorld(world, x, y, z);
    }
}

