/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.Bees;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.SphericalVector;
import Reika.DragonAPI.Interfaces.EntityPathfinder;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Bees.BeeAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.BeeEvent;
import Reika.DragonAPI.ModInteract.Bees.BeeSpecies;
import Reika.DragonAPI.ModInteract.Bees.ButterflyAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.TreeAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.TreeSpecies;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModList;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleGrowth;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAllelePlantType;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.api.lepidopterology.IEntityButterfly;
import forestry.api.multiblock.IAlvearyController;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import org.apache.commons.lang3.text.WordUtils;

public class ReikaBeeHelper {
    private static Field beeHealth;
    private static final HashSet<String> allBees;
    private static final HashMap<ChunkCoordinates, CachedTerritory> territoryCache;
    private static Class geneTemplate;
    private static Method addSample;
    private static Class geneSample;
    private static Constructor geneSampleCtr;
    private static Class geneSampleItem;
    private static Method geneSampleGetItem;
    private static Method setTreeLeaf;
    private static Method setTreeLeafOwner;
    private static Method getTreeLeaf;
    private static Method treeHasFruit;
    private static Method updatePacket;
    private static Field deco;
    private static Field treeRipeness;
    private static Field treeRipeTime;
    private static Class butterflyStateEnum;
    private static Class butterfly;
    private static Field butterflyState;
    private static Field butterflyTarget;

    public static void buildSpeciesList() {
        allBees.clear();
        for (IAllele ia : AlleleManager.alleleRegistry.getRegisteredAlleles((IChromosomeType)EnumBeeChromosome.SPECIES)) {
            if (ia == null || ia.getUID() == null) continue;
            allBees.add(ia.getUID());
        }
    }

    public static Set<String> getAllBeeSpecies() {
        if (allBees.isEmpty()) {
            ReikaBeeHelper.buildSpeciesList();
        }
        return Collections.unmodifiableSet(allBees);
    }

    public static String getRandomBeeSpecies() {
        return ReikaJavaLibrary.getRandomCollectionEntry(DragonAPICore.rand, ReikaBeeHelper.getAllBeeSpecies());
    }

    public static final ItemStack getBeeItem(String bee, EnumBeeType type) {
        return ReikaBeeHelper.getBeeItem(ReikaWorldHelper.getBasicReferenceWorld(), bee, type);
    }

    public static final ItemStack getBeeItem(World world, String bee, EnumBeeType type) {
        IBeeRoot root = BeeManager.beeRoot;
        return root.getMemberStack((IIndividual)root.getBee(world, root.templateAsGenome(root.getTemplate(bee))), type.ordinal());
    }

    public static final ItemStack getTreeItem(String Tree, EnumGermlingType type) {
        return ReikaBeeHelper.getTreeItem(ReikaWorldHelper.getBasicReferenceWorld(), Tree, type);
    }

    public static final ItemStack getTreeItem(World world, String Tree, EnumGermlingType type) {
        ITreeRoot root = TreeManager.treeRoot;
        return root.getMemberStack((IIndividual)root.getTree(world, root.templateAsGenome(root.getTemplate(Tree))), type.ordinal());
    }

    public static final ItemStack getButterflyItem(String Butterfly, EnumFlutterType type) {
        IButterflyRoot root = ButterflyManager.butterflyRoot;
        return root.getMemberStack((IIndividual)root.templateAsIndividual(root.getTemplate(Butterfly)), type.ordinal());
    }

    public static void analyzeBee(ItemStack is) {
        IIndividual bee;
        if (is != null && (bee = AlleleManager.alleleRegistry.getIndividual(is)) != null) {
            bee.analyze();
            ReikaBeeHelper.saveBee(bee, is);
        }
    }

    public static void ageBee(World world, ItemStack is, float modifier) {
        IIndividual bee;
        if (is != null && (bee = AlleleManager.alleleRegistry.getIndividual(is)) instanceof IBee) {
            ((IBee)bee).age(world, modifier);
            ReikaBeeHelper.saveBee(bee, is);
        }
    }

    public static void rejuvenateBee(IAlvearyController iac, ItemStack is) {
        IIndividual bee;
        if (is != null && (bee = AlleleManager.alleleRegistry.getIndividual(is)) instanceof IBee) {
            int max = ((IBee)bee).getMaxHealth();
            ReikaBeeHelper.setBeeHealth(iac, (IBee)bee, max);
            ReikaBeeHelper.saveBee(bee, is);
        }
    }

    private static void setBeeHealth(IAlvearyController iac, IBee bee, int health) {
        try {
            beeHealth.set(bee, health);
            MinecraftForge.EVENT_BUS.post((Event)new BeeEvent.BeeSetHealthEvent((IBeeHousing)iac, iac.getBeekeepingLogic(), bee));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void rejuvenateBee(IBeeHousing te, IBeekeepingLogic lgc, ItemStack is) {
        IIndividual bee;
        if (is != null && (bee = AlleleManager.alleleRegistry.getIndividual(is)) instanceof IBee) {
            int max = ((IBee)bee).getMaxHealth();
            ReikaBeeHelper.setBeeHealth(te, lgc, (IBee)bee, max);
            ReikaBeeHelper.saveBee(bee, is);
        }
    }

    private static void setBeeHealth(IBeeHousing te, IBeekeepingLogic lgc, IBee bee, int health) {
        try {
            beeHealth.set(bee, health);
            MinecraftForge.EVENT_BUS.post((Event)new BeeEvent.BeeSetHealthEvent(te, lgc, bee));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isGenedItem(ItemStack is) {
        return BeeManager.beeRoot.getType(is) != EnumBeeType.NONE || TreeManager.treeRoot.getType(is) != EnumGermlingType.NONE || ButterflyManager.butterflyRoot.getType(is) != EnumFlutterType.NONE;
    }

    public static boolean isBee(ItemStack is) {
        return is.func_77973_b() == ForestryHandler.ItemEntry.DRONE.getItem() || is.func_77973_b() == ForestryHandler.ItemEntry.PRINCESS.getItem() || is.func_77973_b() == ForestryHandler.ItemEntry.QUEEN.getItem();
    }

    public static void setPristine(ItemStack is, boolean flag) {
        IIndividual bee = AlleleManager.alleleRegistry.getIndividual(is);
        if (bee instanceof IBee) {
            ((IBee)bee).setIsNatural(flag);
            ReikaBeeHelper.saveBee(bee, is);
        }
    }

    private static void saveBee(IIndividual bee, ItemStack is) {
        NBTTagCompound tag = new NBTTagCompound();
        bee.writeToNBT(tag);
        is.field_77990_d = tag;
    }

    private static void saveBee(IGenome bee, ItemStack is) {
        NBTTagCompound tag = new NBTTagCompound();
        bee.writeToNBT(tag);
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_74782_a("Genome", (NBTBase)tag);
    }

    public static int getToleranceValue(EnumTolerance t) {
        return t == EnumTolerance.NONE ? 0 : ReikaMathLibrary.getWithinBoundsElse(Character.getNumericValue(t.name().charAt(t.name().length() - 1)), 0, 5, 0);
    }

    public static BeeAlleleRegistry.Tolerance getToleranceType(EnumTolerance t) {
        if (t == EnumTolerance.NONE) {
            return BeeAlleleRegistry.Tolerance.NONE;
        }
        String s = t.name().substring(0, t.name().indexOf(95));
        return BeeAlleleRegistry.Tolerance.valueOf(s);
    }

    public static EnumTolerance getOneBetterTolerance(EnumTolerance t) {
        BeeAlleleRegistry.Tolerance type = ReikaBeeHelper.getToleranceType(t);
        int val = ReikaBeeHelper.getToleranceValue(t);
        if (val > 0 && val < 5) {
            return ReikaBeeHelper.getTolerance(type, ++val);
        }
        return null;
    }

    public static EnumTolerance getTolerance(BeeAlleleRegistry.Tolerance type, int val) {
        String s = val > 0 ? type.name() + "_" + val : type.name();
        return EnumTolerance.valueOf((String)s);
    }

    public static void setGene(ItemStack queen, IBeeGenome ibg, EnumBeeChromosome gene, IAllele value, boolean inactive) {
        boolean ana = AlleleManager.alleleRegistry.getIndividual(queen).isAnalyzed();
        IChromosome[] ic = ibg.getChromosomes();
        IAllele[] arr = BeeManager.beeRoot.getDefaultTemplate();
        IAllele[] arr2 = BeeManager.beeRoot.getDefaultTemplate();
        for (int i = 0; i < arr.length; ++i) {
            if (ic[i] == null) continue;
            arr[i] = ic[i].getActiveAllele();
            arr2[i] = ic[i].getInactiveAllele();
        }
        arr[gene.ordinal()] = value;
        if (inactive) {
            arr2[gene.ordinal()] = value;
        }
        IBeeGenome repl = BeeManager.beeRoot.templateAsGenome(arr, arr2);
        ReikaBeeHelper.saveBee((IGenome)repl, queen);
        if (ana) {
            ReikaBeeHelper.analyzeBee(queen);
        }
    }

    public static void setGene(ItemStack queen, ITreeGenome ibg, EnumTreeChromosome gene, IAllele value, boolean inactive) {
        boolean ana = AlleleManager.alleleRegistry.getIndividual(queen).isAnalyzed();
        IChromosome[] ic = ibg.getChromosomes();
        IAllele[] arr = TreeManager.treeRoot.getDefaultTemplate();
        IAllele[] arr2 = TreeManager.treeRoot.getDefaultTemplate();
        for (int i = 0; i < arr.length; ++i) {
            if (ic[i] == null) continue;
            arr[i] = ic[i].getActiveAllele();
            arr2[i] = ic[i].getInactiveAllele();
        }
        arr[gene.ordinal()] = value;
        if (inactive) {
            arr2[gene.ordinal()] = value;
        }
        ITreeGenome repl = TreeManager.treeRoot.templateAsGenome(arr, arr2);
        ReikaBeeHelper.saveBee((IGenome)repl, queen);
        if (ana) {
            ReikaBeeHelper.analyzeBee(queen);
        }
    }

    public static void setGene(ItemStack queen, IButterflyGenome ibg, EnumButterflyChromosome gene, IAllele value, boolean inactive) {
        boolean ana = AlleleManager.alleleRegistry.getIndividual(queen).isAnalyzed();
        IChromosome[] ic = ibg.getChromosomes();
        IAllele[] arr = ButterflyManager.butterflyRoot.getDefaultTemplate();
        IAllele[] arr2 = ButterflyManager.butterflyRoot.getDefaultTemplate();
        for (int i = 0; i < arr.length; ++i) {
            if (ic[i] == null) continue;
            arr[i] = ic[i].getActiveAllele();
            arr2[i] = ic[i].getInactiveAllele();
        }
        arr[gene.ordinal()] = value;
        if (inactive) {
            arr2[gene.ordinal()] = value;
        }
        IButterflyGenome repl = ButterflyManager.butterflyRoot.templateAsGenome(arr, arr2);
        ReikaBeeHelper.saveBee((IGenome)repl, queen);
        if (ana) {
            ReikaBeeHelper.analyzeBee(queen);
        }
    }

    public static BeeAlleleRegistry.BeeGene getGeneEnum(EnumBeeChromosome gene, IBeeGenome ibg) {
        switch (gene) {
            case EFFECT: {
                return (BeeAlleleRegistry.BeeGene)BeeAlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), BeeAlleleRegistry.Effect.class);
            }
            case FERTILITY: {
                return (BeeAlleleRegistry.BeeGene)BeeAlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), BeeAlleleRegistry.Fertility.class);
            }
            case FLOWERING: {
                return (BeeAlleleRegistry.BeeGene)BeeAlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), BeeAlleleRegistry.Flowering.class);
            }
            case FLOWER_PROVIDER: {
                return (BeeAlleleRegistry.BeeGene)BeeAlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), BeeAlleleRegistry.Flower.class);
            }
            case HUMIDITY_TOLERANCE: {
                return ReikaBeeHelper.getToleranceType(ibg.getToleranceHumid());
            }
            case TEMPERATURE_TOLERANCE: {
                return ReikaBeeHelper.getToleranceType(ibg.getToleranceTemp());
            }
            case LIFESPAN: {
                return (BeeAlleleRegistry.BeeGene)BeeAlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), BeeAlleleRegistry.Life.class);
            }
            case SPEED: {
                return (BeeAlleleRegistry.BeeGene)BeeAlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), BeeAlleleRegistry.Speeds.class);
            }
            case TERRITORY: {
                return (BeeAlleleRegistry.BeeGene)BeeAlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), BeeAlleleRegistry.Territory.class);
            }
        }
        return null;
    }

    public static IAllele getToleranceGene(EnumTolerance t) {
        return ReikaBeeHelper.getToleranceGene(ReikaBeeHelper.getToleranceType(t), ReikaBeeHelper.getToleranceValue(t));
    }

    public static IAllele getToleranceGene(BeeAlleleRegistry.Tolerance d, int i) {
        String s = i > 0 ? String.format("%s%d", d.tag, Math.min(Math.abs(i), 5)) : BeeAlleleRegistry.Tolerance.NONE.tag;
        return AlleleManager.alleleRegistry.getAllele(s);
    }

    public static void runProductionCycle(IBeeHousing ibh) {
        ItemStack[] ret;
        IIndividual bee;
        ItemStack is;
        if (ibh.getBeekeepingLogic().canWork() && (is = ibh.getBeeInventory().getQueen()) != null && (bee = AlleleManager.alleleRegistry.getIndividual(is)) instanceof IBee && (ret = ((IBee)bee).produceStacks(ibh)) != null) {
            for (int i = 0; i < ret.length; ++i) {
                ItemStack in = ret[i];
                ibh.getBeeInventory().addProduct(in, false);
            }
        }
    }

    public static IAlleleBoolean getBooleanAllele(boolean value) {
        return (IAlleleBoolean)AlleleManager.alleleRegistry.getAllele("forestry.bool" + WordUtils.capitalize((String)Boolean.toString(value)));
    }

    public static IAlleleInteger getIntegerAllele(int value) {
        return (IAlleleInteger)AlleleManager.alleleRegistry.getAllele("forestry.i" + value + "d");
    }

    public static void setBeeMate(IBee ii, IBee repl) {
        ii.mate((IIndividual)repl);
    }

    public static ArrayList<String> getGenesAsStringList(ItemStack is) {
        IIndividual ii = AlleleManager.alleleRegistry.getIndividual(is);
        return ii != null ? ReikaBeeHelper.getGenesAsStringList(ii.getGenome()) : new ArrayList<String>();
    }

    public static ArrayList<String> getGenesAsStringList(IGenome ig) {
        ArrayList<String> li;
        block4: {
            block5: {
                block3: {
                    li = new ArrayList<String>();
                    if (!(ig instanceof IBeeGenome)) break block3;
                    IAlleleBeeSpecies sp1 = (IAlleleBeeSpecies)ig.getPrimary();
                    IAlleleBeeSpecies sp2 = (IAlleleBeeSpecies)ig.getSecondary();
                    EnumBeeChromosome[] order = new EnumBeeChromosome[]{EnumBeeChromosome.SPECIES, EnumBeeChromosome.LIFESPAN, EnumBeeChromosome.SPEED, EnumBeeChromosome.FLOWERING, EnumBeeChromosome.FLOWER_PROVIDER, EnumBeeChromosome.FERTILITY, EnumBeeChromosome.TERRITORY, EnumBeeChromosome.EFFECT, EnumBeeChromosome.NOCTURNAL, EnumBeeChromosome.TOLERANT_FLYER, EnumBeeChromosome.CAVE_DWELLING};
                    for (int i = 0; i < order.length; ++i) {
                        IAllele ia1 = ig.getActiveAllele((IChromosomeType)order[i]);
                        IAllele ia2 = ig.getInactiveAllele((IChromosomeType)order[i]);
                        li.add(ReikaBeeHelper.getGeneDisplay(ia1, order[i], true, true) + " / " + ReikaBeeHelper.getGeneDisplay(ia2, order[i], false, false));
                        if (order[i] != EnumBeeChromosome.EFFECT) continue;
                        String t1 = ReikaBeeHelper.getTemperatureDisplay((IAlleleSpecies)sp1, (IAlleleTolerance)ig.getActiveAllele((IChromosomeType)EnumBeeChromosome.TEMPERATURE_TOLERANCE), true, true);
                        String t2 = ReikaBeeHelper.getTemperatureDisplay((IAlleleSpecies)sp2, (IAlleleTolerance)ig.getInactiveAllele((IChromosomeType)EnumBeeChromosome.TEMPERATURE_TOLERANCE), false, false);
                        li.add(t1 + " / " + t2);
                        String h1 = ReikaBeeHelper.getHumidityDisplay((IAlleleSpecies)sp1, (IAlleleTolerance)ig.getActiveAllele((IChromosomeType)EnumBeeChromosome.HUMIDITY_TOLERANCE), true, true);
                        String h2 = ReikaBeeHelper.getHumidityDisplay((IAlleleSpecies)sp2, (IAlleleTolerance)ig.getInactiveAllele((IChromosomeType)EnumBeeChromosome.HUMIDITY_TOLERANCE), false, false);
                        li.add(h1 + " / " + h2);
                    }
                    break block4;
                }
                if (!(ig instanceof ITreeGenome)) break block5;
                IAlleleTreeSpecies sp1 = (IAlleleTreeSpecies)ig.getPrimary();
                IAlleleTreeSpecies sp2 = (IAlleleTreeSpecies)ig.getSecondary();
                EnumTreeChromosome[] order = new EnumTreeChromosome[]{EnumTreeChromosome.SPECIES, EnumTreeChromosome.FERTILITY, EnumTreeChromosome.MATURATION, EnumTreeChromosome.HEIGHT, EnumTreeChromosome.GIRTH, EnumTreeChromosome.YIELD, EnumTreeChromosome.SAPPINESS, EnumTreeChromosome.FIREPROOF, EnumTreeChromosome.EFFECT, EnumTreeChromosome.GROWTH, EnumTreeChromosome.PLANT, EnumTreeChromosome.FRUITS};
                for (int i = 0; i < order.length; ++i) {
                    IAllele ia1 = ig.getActiveAllele((IChromosomeType)order[i]);
                    IAllele ia2 = ig.getInactiveAllele((IChromosomeType)order[i]);
                    li.add(ReikaBeeHelper.getGeneDisplay((ITreeGenome)ig, ia1, order[i], true, true) + " / " + ReikaBeeHelper.getGeneDisplay((ITreeGenome)ig, ia2, order[i], false, false));
                }
                break block4;
            }
            if (!(ig instanceof IButterflyGenome)) break block4;
            IAlleleButterflySpecies sp1 = (IAlleleButterflySpecies)ig.getPrimary();
            IAlleleButterflySpecies sp2 = (IAlleleButterflySpecies)ig.getSecondary();
            EnumButterflyChromosome[] order = new EnumButterflyChromosome[]{EnumButterflyChromosome.SPECIES, EnumButterflyChromosome.SIZE, EnumButterflyChromosome.SPEED, EnumButterflyChromosome.LIFESPAN, EnumButterflyChromosome.METABOLISM, EnumButterflyChromosome.FERTILITY, EnumButterflyChromosome.EFFECT, EnumButterflyChromosome.NOCTURNAL, EnumButterflyChromosome.TOLERANT_FLYER, EnumButterflyChromosome.FIRE_RESIST};
            for (int i = 0; i < order.length; ++i) {
                IAllele ia1 = ig.getActiveAllele((IChromosomeType)order[i]);
                IAllele ia2 = ig.getInactiveAllele((IChromosomeType)order[i]);
                li.add(ReikaBeeHelper.getGeneDisplay((IButterflyGenome)ig, ia1, order[i], true, true) + " / " + ReikaBeeHelper.getGeneDisplay((IButterflyGenome)ig, ia2, order[i], false, false));
                if (order[i] != EnumButterflyChromosome.EFFECT) continue;
                String t1 = ReikaBeeHelper.getTemperatureDisplay((IAlleleSpecies)sp1, (IAlleleTolerance)ig.getActiveAllele((IChromosomeType)EnumButterflyChromosome.TEMPERATURE_TOLERANCE), true, true);
                String t2 = ReikaBeeHelper.getTemperatureDisplay((IAlleleSpecies)sp2, (IAlleleTolerance)ig.getInactiveAllele((IChromosomeType)EnumButterflyChromosome.TEMPERATURE_TOLERANCE), false, false);
                li.add(t1 + " / " + t2);
                String h1 = ReikaBeeHelper.getHumidityDisplay((IAlleleSpecies)sp1, (IAlleleTolerance)ig.getActiveAllele((IChromosomeType)EnumButterflyChromosome.HUMIDITY_TOLERANCE), true, true);
                String h2 = ReikaBeeHelper.getHumidityDisplay((IAlleleSpecies)sp2, (IAlleleTolerance)ig.getInactiveAllele((IChromosomeType)EnumButterflyChromosome.HUMIDITY_TOLERANCE), false, false);
                li.add(h1 + " / " + h2);
            }
        }
        return li;
    }

    public static String getTemperatureDisplay(IAlleleSpecies bee, IAlleleTolerance tol, boolean title, boolean primary) {
        EnumChatFormatting ec = primary ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        String ret = ec + AlleleManager.climateHelper.toDisplay(bee.getTemperature()) + "/" + tol.getName() + EnumChatFormatting.RESET;
        if (title) {
            ret = EnumChatFormatting.LIGHT_PURPLE + "Temperature: " + EnumChatFormatting.RESET + ret;
        }
        return ret;
    }

    public static String getHumidityDisplay(IAlleleSpecies bee, IAlleleTolerance tol, boolean title, boolean primary) {
        EnumChatFormatting ec = primary ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        String ret = ec + AlleleManager.climateHelper.toDisplay(bee.getHumidity()) + "/" + tol.getName() + EnumChatFormatting.RESET;
        if (title) {
            ret = EnumChatFormatting.LIGHT_PURPLE + "Humidity: " + EnumChatFormatting.RESET + ret;
        }
        return ret;
    }

    public static String getGeneDisplay(IButterflyGenome itg, IAllele gene, EnumButterflyChromosome type, boolean title, boolean primary) {
        EnumChatFormatting ec = primary ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        String tag = "";
        String val = gene.getName();
        switch (type) {
            case EFFECT: {
                tag = "for.gui.effect";
                break;
            }
            case FERTILITY: {
                tag = "for.gui.fertility";
                val = ((IAlleleInteger)gene).getValue() + "x";
                break;
            }
            case SPECIES: {
                tag = "for.gui.species";
                break;
            }
            case TERRITORY: {
                tag = "for.gui.area";
                IAlleleArea ia = (IAlleleArea)gene;
                val = val + " (" + ia.getValue()[0] + "x" + ia.getValue()[1] + "x" + ia.getValue()[2] + ")";
                break;
            }
            case FLOWER_PROVIDER: {
                tag = "for.gui.flowers";
                break;
            }
            case LIFESPAN: {
                tag = "for.gui.life";
                val = val + ReikaBeeHelper.getLifeDisplay(itg);
                break;
            }
            case METABOLISM: {
                tag = "for.gui.metabolism";
                val = ((IAlleleInteger)gene).getValue() + "x";
                break;
            }
            case SIZE: {
                tag = "for.gui.size";
                val = val + " (" + ((IAlleleFloat)gene).getValue() / ButterflyAlleleRegistry.Size.AVERAGE.getAllele().getValue() + "x)";
                break;
            }
            case SPEED: {
                tag = "for.gui.maxspeed";
                val = val + " (" + ((IAlleleFloat)gene).getValue() * 10.0f + " m/s)";
                break;
            }
            case NOCTURNAL: {
                tag = "for.gui.nocturnal";
                val = StatCollector.func_74838_a((String)(((IAlleleBoolean)gene).getValue() ? "for.yes" : "for.no"));
                break;
            }
            case FIRE_RESIST: {
                tag = "for.gui.fireresist";
                val = StatCollector.func_74838_a((String)(((IAlleleBoolean)gene).getValue() ? "for.yes" : "for.no"));
                break;
            }
            case TOLERANT_FLYER: {
                tag = "for.gui.flyer";
                val = StatCollector.func_74838_a((String)(((IAlleleBoolean)gene).getValue() ? "for.yes" : "for.no"));
                break;
            }
            case HUMIDITY_TOLERANCE: {
                tag = "for.gui.tolerance";
                break;
            }
            case TEMPERATURE_TOLERANCE: {
                tag = "for.gui.tolerance";
            }
        }
        return title ? EnumChatFormatting.LIGHT_PURPLE + StatCollector.func_74838_a((String)tag) + ": " + EnumChatFormatting.RESET + ec + val + EnumChatFormatting.RESET : ec + val + EnumChatFormatting.RESET;
    }

    private static String getLifeDisplay(IButterflyGenome gene) {
        return " (" + gene.getLifespan() + " ticks) [UNIMPLEMENTED]";
    }

    public static String getGeneDisplay(ITreeGenome itg, IAllele gene, EnumTreeChromosome type, boolean title, boolean primary) {
        EnumChatFormatting ec = primary ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        String tag = "";
        String val = gene.getName();
        switch (type) {
            case EFFECT: {
                tag = "for.gui.effect";
                break;
            }
            case MATURATION: {
                tag = "for.gui.maturity";
                val = val + " (" + ((IAlleleInteger)gene).getValue() + " growth ticks)";
                break;
            }
            case FERTILITY: {
                tag = "for.gui.fertility";
                val = val + " (" + ((IAlleleFloat)gene).getValue() * 100.0f + " %/leaf)";
                break;
            }
            case HEIGHT: {
                tag = "for.gui.height";
                val = val + " (" + ((IAlleleFloat)gene).getValue() + "x)";
                break;
            }
            case YIELD: {
                tag = "for.gui.yield";
                val = val + " (" + ((IAlleleFloat)gene).getValue() / TreeAlleleRegistry.Yield.LOW.getAllele().getValue() + "x)";
                break;
            }
            case SAPPINESS: {
                tag = "for.gui.sappiness";
                val = val + " (" + ((IAlleleFloat)gene).getValue() / TreeAlleleRegistry.Sappiness.LOW.getAllele().getValue() + "x)";
                break;
            }
            case GIRTH: {
                tag = "for.gui.girth";
                val = ((IAlleleInteger)gene).getValue() + "x" + ((IAlleleInteger)gene).getValue();
                break;
            }
            case SPECIES: {
                tag = "for.gui.species";
                break;
            }
            case FRUITS: {
                tag = "for.gui.fruits";
                IFruitProvider iaf = ((IAlleleFruit)gene).getProvider();
                val = StatCollector.func_74838_a((String)("for." + iaf.getDescription()));
                if (!(iaf instanceof TreeSpecies.NoLocaleDescriptionFruit)) break;
                val = ((TreeSpecies.NoLocaleDescriptionFruit)iaf).getDirectDescription();
                break;
            }
            case PLANT: {
                tag = "for.gui.native";
                val = StatCollector.func_74838_a((String)(primary ? itg.getPrimary().getPlantType().toString() : itg.getSecondary().getPlantType().toString()));
                break;
            }
            case GROWTH: {
                tag = "for.gui.growth";
                val = StatCollector.func_74838_a((String)((IAlleleGrowth)gene).getProvider().getDescription());
                break;
            }
            case TERRITORY: {
                tag = "for.gui.area";
                IAlleleArea ia = (IAlleleArea)gene;
                val = val + " (" + ia.getValue()[0] + "x" + ia.getValue()[1] + "x" + ia.getValue()[2] + ")";
                break;
            }
            case FIREPROOF: {
                tag = "for.gui.fireproof";
                val = StatCollector.func_74838_a((String)(((IAlleleBoolean)gene).getValue() ? "for.yes" : "for.no"));
                break;
            }
        }
        return title ? EnumChatFormatting.LIGHT_PURPLE + StatCollector.func_74838_a((String)tag) + ": " + EnumChatFormatting.RESET + ec + val + EnumChatFormatting.RESET : ec + val + EnumChatFormatting.RESET;
    }

    public static String getGeneDisplay(IAllele gene, EnumBeeChromosome type, boolean title, boolean primary) {
        EnumChatFormatting ec = primary ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        String tag = "";
        String val = gene.getName();
        switch (type) {
            case EFFECT: {
                tag = "for.gui.effect";
                break;
            }
            case FERTILITY: {
                tag = "for.gui.fertility";
                val = val + " (" + ((IAlleleInteger)gene).getValue() + ")";
                break;
            }
            case FLOWERING: {
                tag = "for.gui.pollination";
                val = val + " (" + ((IAlleleInteger)gene).getValue() * 20 * 60 / 550 + "/min)";
                break;
            }
            case FLOWER_PROVIDER: {
                tag = "for.gui.flowers";
                break;
            }
            case HUMIDITY_TOLERANCE: {
                tag = "for.gui.tolerance";
                break;
            }
            case TEMPERATURE_TOLERANCE: {
                tag = "for.gui.tolerance";
                break;
            }
            case LIFESPAN: {
                tag = "for.gui.life";
                val = val + " (" + ((IAlleleInteger)gene).getValue() + ")";
                break;
            }
            case SPECIES: {
                tag = "for.gui.species";
                break;
            }
            case SPEED: {
                tag = "for.gui.worker";
                val = val + " (" + ((IAlleleFloat)gene).getValue() + "x)";
                break;
            }
            case TERRITORY: {
                tag = "for.gui.area";
                IAlleleArea ia = (IAlleleArea)gene;
                val = val + " (" + ia.getValue()[0] + "x" + ia.getValue()[1] + "x" + ia.getValue()[2] + ")";
                break;
            }
            case NOCTURNAL: {
                tag = "for.gui.nocturnal";
                val = StatCollector.func_74838_a((String)(((IAlleleBoolean)gene).getValue() ? "for.yes" : "for.no"));
                break;
            }
            case CAVE_DWELLING: {
                tag = "for.gui.cave";
                val = StatCollector.func_74838_a((String)(((IAlleleBoolean)gene).getValue() ? "for.yes" : "for.no"));
                break;
            }
            case TOLERANT_FLYER: {
                tag = "for.gui.flyer";
                val = StatCollector.func_74838_a((String)(((IAlleleBoolean)gene).getValue() ? "for.yes" : "for.no"));
                break;
            }
        }
        return title ? EnumChatFormatting.LIGHT_PURPLE + StatCollector.func_74838_a((String)tag) + ": " + EnumChatFormatting.RESET + ec + val + EnumChatFormatting.RESET : ec + val + EnumChatFormatting.RESET;
    }

    public static IBeeRoot getBeeRoot() {
        return (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
    }

    public static ITreeRoot getTreeRoot() {
        return (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");
    }

    public static IButterflyRoot getButterflyRoot() {
        return ButterflyManager.butterflyRoot;
    }

    public static boolean isPristine(ItemStack is) {
        IIndividual bee = AlleleManager.alleleRegistry.getIndividual(is);
        return bee instanceof IBee && ((IBee)bee).isNatural();
    }

    public static IGenome getGenome(ItemStack is) {
        IIndividual bee = AlleleManager.alleleRegistry.getIndividual(is);
        return bee != null ? bee.getGenome() : null;
    }

    public static IBee getBee(ItemStack is) {
        IIndividual bee = AlleleManager.alleleRegistry.getIndividual(is);
        return bee instanceof IBee ? (IBee)bee : null;
    }

    public static IAlleleSpecies getSpecies(ItemStack is) {
        IGenome ig = ReikaBeeHelper.getGenome(is);
        return ig != null ? ig.getPrimary() : null;
    }

    public static boolean isDefaultJubilance(IBeeGenome ibg, IBeeHousing ibh) {
        return ReikaBeeHelper.isDefaultJubilance(ibg.getPrimary(), ibg, ibh);
    }

    public static boolean isDefaultJubilance(IAlleleBeeSpecies ias, IBeeGenome ibg, IBeeHousing ibh) {
        return BeeManager.jubilanceFactory.getDefault().isJubilant(ias, ibg, ibh);
    }

    public static float getTemperatureRangeCenter(EnumTemperature t) {
        switch (t) {
            case ICY: {
                return -0.1f;
            }
            case COLD: {
                return 0.175f;
            }
            case NORMAL: {
                return 0.6f;
            }
            case WARM: {
                return 0.925f;
            }
            case HOT: {
                return 1.1f;
            }
            case HELLISH: {
                return 2.0f;
            }
        }
        return Float.NaN;
    }

    public static float getHumidityRangeCenter(EnumHumidity h) {
        switch (h) {
            case ARID: {
                return 0.15f;
            }
            case NORMAL: {
                return 0.5f;
            }
            case DAMP: {
                return 1.0f;
            }
        }
        return Float.NaN;
    }

    public static boolean isTree(ItemStack is) {
        return is.func_77973_b() == ForestryHandler.ItemEntry.SAPLING.getItem();
    }

    public static boolean isPollen(ItemStack is) {
        return is.func_77973_b() == ForestryHandler.ItemEntry.TREEPOLLEN.getItem();
    }

    public static boolean isButterfly(ItemStack is) {
        return is.func_77973_b() == ForestryHandler.ItemEntry.BUTTERFLY.getItem();
    }

    public static boolean isCaterpillar(ItemStack is) {
        return is.func_77973_b() == ForestryHandler.ItemEntry.CATERPILLAR.getItem();
    }

    public static boolean isButterfly(Entity e) {
        return e instanceof IEntityButterfly;
    }

    private static int[] getFinalTerritory(IBeeGenome ibg, IBeeHousing ibh) {
        float f = 1.0f;
        for (IBeeModifier ibm : ibh.getBeeModifiers()) {
            f *= ibm.getTerritoryModifier(ibg, f);
        }
        int[] ret = ibg.getTerritory();
        int i = 0;
        while (i < ret.length) {
            int n = i++;
            ret[n] = (int)((float)ret[n] * f);
        }
        return ret;
    }

    public static ItemStack getGeneTemplate(BeeSpecies bee) {
        return ReikaBeeHelper.getGeneTemplate(bee.getSpeciesTemplate(), (ISpeciesRoot)ReikaBeeHelper.getBeeRoot());
    }

    public static ItemStack getGeneTemplate(IIndividual ii) {
        return ReikaBeeHelper.getGeneTemplate(ReikaBeeHelper.getBeeRoot().getTemplate(ii.getIdent()), AlleleManager.alleleRegistry.getSpeciesRoot(ii.getClass()));
    }

    public static ItemStack getGeneTemplate(IAllele[] genes, ISpeciesRoot root) {
        ItemStack template = ReikaItemHelper.lookupItem("gendustry:GeneTemplate");
        if (template.func_77973_b().getClass() != geneTemplate) {
            throw new MisuseException("You can only put genes on a template!");
        }
        for (int i = 0; i < genes.length; ++i) {
            IAllele gene = genes[i];
            if (gene == null) continue;
            try {
                Object sample = geneSampleCtr.newInstance(root, i, gene);
                addSample.invoke((Object)template.func_77973_b(), template, sample);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return template;
    }

    public static ItemStack getGeneSample(IChromosomeType ic, IAllele ie) {
        ItemStack item = ReikaItemHelper.lookupItem("gendustry:GeneSample");
        try {
            Object sample = geneSampleCtr.newInstance(ic.getSpeciesRoot(), ic.ordinal(), ie);
            ItemStack ret = (ItemStack)geneSampleGetItem.invoke((Object)item.func_77973_b(), sample);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Item getGendustrySampleItem() {
        return ModList.GENDUSTRY.isLoaded() ? GameRegistry.findItem((String)ModList.GENDUSTRY.modLabel, (String)"GeneSample") : null;
    }

    public static Item getBinnieSampleItem() {
        return Loader.isModLoaded((String)"Genetics") ? GameRegistry.findItem((String)"Genetics", (String)"serum") : null;
    }

    public static void setTree(TileEntity leaf, ITree tree) {
        try {
            setTreeLeaf.invoke((Object)leaf, tree);
            updatePacket.invoke((Object)leaf, new Object[0]);
            leaf.field_145850_b.func_147458_c(leaf.field_145851_c, leaf.field_145848_d, leaf.field_145849_e, leaf.field_145851_c, leaf.field_145848_d, leaf.field_145849_e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setTreeOwner(TileEntity leaf, GameProfile owner) {
        try {
            setTreeLeafOwner.invoke((Object)leaf, owner);
            updatePacket.invoke((Object)leaf, new Object[0]);
            leaf.field_145850_b.func_147458_c(leaf.field_145851_c, leaf.field_145848_d, leaf.field_145849_e, leaf.field_145851_c, leaf.field_145848_d, leaf.field_145849_e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setTreeLeafDecorative(TileEntity leaf, boolean decor) {
        try {
            deco.setBoolean(leaf, decor);
            updatePacket.invoke((Object)leaf, new Object[0]);
            leaf.field_145850_b.func_147458_c(leaf.field_145851_c, leaf.field_145848_d, leaf.field_145849_e, leaf.field_145851_c, leaf.field_145848_d, leaf.field_145849_e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ITree getTree(TileEntity leaf) {
        try {
            return (ITree)getTreeLeaf.invoke((Object)leaf, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean hasFruit(TileEntity leaf) {
        try {
            return (Boolean)treeHasFruit.invoke((Object)leaf, new Object[0]) != false && treeRipeness.getInt(leaf) >= treeRipeTime.getShort(leaf);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void setTreeRipeness(TileEntity leaf, int val) {
        try {
            if (val == -1) {
                val = treeRipeTime.getShort(leaf);
            }
            treeRipeness.setInt(leaf, val);
            updatePacket.invoke((Object)leaf, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getTreeRipeness(TileEntity leaf) {
        try {
            return treeRipeness.getInt(leaf);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static IAllelePlantType getAlleleForPlantType(EnumPlantType plantType) {
        return (IAllelePlantType)AlleleManager.alleleRegistry.getAllele("forestry.plantType" + ReikaStringParser.capFirstChar(plantType.name()));
    }

    public static void attractButterflies(World world, double x, double y, double z, double r, EntityPathfinder path) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(x - r), (double)(y - r), (double)(z - r), (double)(x + r), (double)(y + r), (double)(z + r));
        for (EntityCreature e : world.func_72872_a(IEntityButterfly.class, box)) {
            int idz;
            int idy;
            ReikaBeeHelper.setButterflyState(e, "FLYING");
            boolean flag = false;
            if (path != null) {
                if (path.isInRange((Entity)e)) {
                    DecimalPosition c = path.getNextWaypoint((Entity)e);
                    if (c != null) {
                        flag = true;
                        SphericalVector vec = SphericalVector.fromCartesian(x - e.field_70165_t, y - e.field_70163_u, z - e.field_70161_v);
                        e.func_70012_b(c.xCoord, c.yCoord, c.zCoord, (float)vec.rotation, (float)vec.inclination);
                    }
                } else {
                    flag = true;
                }
            }
            if (flag) continue;
            if (!(e.func_70092_e(x, y, z) <= 32.0)) {
                // empty if block
            }
            double dx = x - e.field_70165_t;
            double dy = y - e.field_70163_u;
            double dz = z - e.field_70161_v;
            double dd = ReikaMathLibrary.py3d(dx, dy, dz);
            SphericalVector vec = SphericalVector.fromCartesian(dx, dy, dz);
            e.field_70125_A = (float)vec.inclination;
            e.field_70177_z = e.field_70759_as = (float)vec.rotation;
            double v = 0.125;
            double vx = v * dx / dd;
            double vy = v * dy / dd;
            double vz = v * dz / dd;
            int idx = MathHelper.func_76128_c((double)(e.field_70165_t + vx * 5.0));
            Block b = world.func_147439_a(idx, idy = MathHelper.func_76128_c((double)(e.field_70163_u + vy * 5.0)), idz = MathHelper.func_76128_c((double)(e.field_70161_v + vz * 5.0)));
            if (b.func_149688_o().func_76230_c() && b.func_149668_a(world, idx, idy, idz) != null) {
                vx *= -1.0;
                vz *= -1.0;
                vy += 0.25;
            }
            e.field_70159_w = vx;
            e.field_70181_x = vy;
            e.field_70179_y = vz;
            e.field_70133_I = true;
        }
    }

    private static void setButterflyState(EntityCreature e, String val) {
        try {
            Object entry = Enum.valueOf(butterflyStateEnum, val);
            butterflyState.set(e, entry);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void collectButterflies(World world, AxisAlignedBB box, EntityPlayer ep) {
        for (IEntityButterfly e : world.func_72872_a(IEntityButterfly.class, box)) {
            ItemStack is;
            IButterfly fly;
            if (e.getEntity().field_70128_L || e.getEntity().func_110143_aJ() <= 0.0f || (fly = e.getButterfly()) == null || (is = ButterflyManager.butterflyRoot.getMemberStack((IIndividual)fly, EnumFlutterType.BUTTERFLY.ordinal())) == null) continue;
            e.getEntity().func_70106_y();
            ReikaSoundHelper.playSoundAtEntity(world, (Entity)e.getEntity(), "random.pop", 0.5f, 2.0f);
            is = is.func_77946_l();
            if (ep != null) {
                if (MinecraftForge.EVENT_BUS.post((Event)new EntityItemPickupEvent(ep, new EntityItem(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, is)))) continue;
                ReikaPlayerAPI.addOrDropItem(is, ep);
                continue;
            }
            ReikaItemHelper.dropItem((Entity)e.getEntity(), is);
        }
    }

    public static Class getButterflyClass() {
        return butterfly;
    }

    public static ItemStack convertToBasicSpeciesTemplate(ItemStack is) {
        IAlleleSpecies iae;
        IIndividual ii;
        ISpeciesRoot isr = AlleleManager.alleleRegistry.getSpeciesRoot(is);
        if (isr != null && (ii = isr.getMember(is)) != null && (iae = ii.getGenome().getPrimary()) != null) {
            IAllele[] genes = isr.getTemplate(iae.getUID());
            int type = ((Enum)isr.getType(is)).ordinal();
            ii = isr.templateAsIndividual(genes);
            is = isr.getMemberStack(ii, type);
        }
        return is;
    }

    public static ISpeciesType getSpeciesType(ItemStack is) {
        ISpeciesRoot isr = AlleleManager.alleleRegistry.getSpeciesRoot(is);
        return isr != null ? isr.getType(is) : null;
    }

    public static int[] getEffectiveTerritory(IBeeHousing ibh, ChunkCoordinates c, IBeeGenome ibg, long time) {
        CachedTerritory t = territoryCache.get(c);
        if (t == null || t.territory == null || t.age >= 20) {
            if (t == null) {
                t = new CachedTerritory();
                territoryCache.put(c, t);
            }
            t.recalculate(ibg, ibh);
        } else if (time > t.lastTick) {
            t.lastTick = time;
            t.age++;
        }
        return t.territory;
    }

    public static void setButterflyTarget(IEntityButterfly butterfly, Vec3 vec) {
        try {
            butterflyTarget.set(butterfly, vec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        allBees = new HashSet();
        territoryCache = new HashMap();
        if (ModList.FORESTRY.isLoaded()) {
            try {
                beeHealth = Class.forName("forestry.core.genetics.IndividualLiving").getDeclaredField("health");
                beeHealth.setAccessible(true);
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not find forestry bee life parameter!");
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.FORESTRY, e);
                e.printStackTrace();
            }
            try {
                butterflyStateEnum = Class.forName("forestry.lepidopterology.entities.EnumButterflyState");
                butterfly = Class.forName("forestry.lepidopterology.entities.EntityButterfly");
                butterflyState = butterfly.getDeclaredField("state");
                butterflyState.setAccessible(true);
                butterflyTarget = butterfly.getDeclaredField("flightTarget");
                butterflyTarget.setAccessible(true);
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not find forestry butterfly parameters!");
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.FORESTRY, e);
                e.printStackTrace();
            }
            try {
                Class<?> c = Class.forName("forestry.arboriculture.tiles.TileTreeContainer");
                setTreeLeaf = c.getDeclaredMethod("setTree", ITree.class);
                setTreeLeaf.setAccessible(true);
                setTreeLeafOwner = c.getDeclaredMethod("setOwner", GameProfile.class);
                setTreeLeafOwner.setAccessible(true);
                getTreeLeaf = c.getDeclaredMethod("getTree", new Class[0]);
                getTreeLeaf.setAccessible(true);
                c = Class.forName("forestry.arboriculture.tiles.TileLeaves");
                deco = c.getDeclaredField("isDecorative");
                deco.setAccessible(true);
                treeRipeness = c.getDeclaredField("ripeningTime");
                treeRipeness.setAccessible(true);
                treeRipeTime = c.getDeclaredField("ripeningPeriod");
                treeRipeTime.setAccessible(true);
                treeHasFruit = c.getDeclaredMethod("hasFruit", new Class[0]);
                treeHasFruit.setAccessible(true);
                updatePacket = c.getDeclaredMethod("sendNetworkUpdateRipening", new Class[0]);
                updatePacket.setAccessible(true);
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not find forestry leaf parameters!");
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.FORESTRY, e);
                e.printStackTrace();
            }
        }
        if (ModList.GENDUSTRY.isLoaded()) {
            try {
                geneSample = Class.forName("net.bdew.gendustry.forestry.GeneSampleInfo");
                geneSampleCtr = geneSample.getDeclaredConstructor(ISpeciesRoot.class, Integer.TYPE, IAllele.class);
                geneSampleCtr.setAccessible(true);
                geneTemplate = Class.forName("net.bdew.gendustry.items.GeneTemplate$");
                addSample = geneTemplate.getDeclaredMethod("addSample", ItemStack.class, geneSample);
                addSample.setAccessible(true);
                geneSampleItem = Class.forName("net.bdew.gendustry.items.GeneSample$");
                geneSampleGetItem = geneSampleItem.getDeclaredMethod("newStack", geneSample);
                geneSampleGetItem.setAccessible(true);
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not find GenDustry sample data!");
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.GENDUSTRY, e);
                e.printStackTrace();
            }
        }
    }

    private static class CachedTerritory {
        private int[] territory;
        private int age;
        private long lastTick;

        private CachedTerritory() {
        }

        private void recalculate(IBeeGenome ibg, IBeeHousing ibh) {
            this.age = 0;
            this.territory = ReikaBeeHelper.getFinalTerritory(ibg, ibh);
        }
    }
}

