/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.Bees;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.ModInteract.Bees.BeeAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.GeneBase;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import Reika.DragonAPI.ModInteract.Bees.TreeAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.TreeTraits;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleGrowth;
import forestry.api.arboriculture.IAlleleLeafEffect;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenerator;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.world.ITreeGenData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TreeSpecies
extends GeneBase
implements IAlleleTreeSpecies,
IIconProvider {
    protected final Random rand = new Random();
    private static final ITreeRoot treeRoot = ReikaBeeHelper.getTreeRoot();
    private final IClassification branch;
    private final String scientific;
    private final String creator;
    private final IAllele[] template = new IAllele[EnumTreeChromosome.values().length];
    private final ITreeGenerator generator = new ForestryTreeGenerator();
    private final HashSet<IFruitFamily> suitableFruits = new HashSet();
    private boolean isRegistered = false;
    private final IIcon[] pollenIcons = new IIcon[2];
    private IIcon saplingIcon;

    protected TreeSpecies(String name, String uid, String latinName, String creator, IClassification g) {
        super(uid, name, (IChromosomeType)EnumTreeChromosome.SPECIES);
        this.branch = g;
        this.creator = creator;
        this.scientific = latinName;
    }

    public final void register() {
        System.arraycopy(this.getSpeciesTemplate(), 0, this.template, 0, this.template.length);
        AlleleManager.alleleRegistry.registerAllele((IAllele)this, new IChromosomeType[]{EnumTreeChromosome.SPECIES});
        treeRoot.registerTemplate(this.template);
        this.isRegistered = true;
        if (this.getFruitAllele() != this.getNoFruit()) {
            this.suitableFruits.add(this.getFruitAllele().getProvider().getFamily());
        }
        this.onRegister();
    }

    protected void onRegister() {
    }

    public final String getBinomial() {
        return this.scientific;
    }

    public final String getAuthority() {
        return this.creator;
    }

    public final IClassification getBranch() {
        return this.branch;
    }

    public final ItemStack getTreeItem(World world, EnumGermlingType type) {
        return treeRoot.getMemberStack((IIndividual)treeRoot.getTree(world, treeRoot.templateAsGenome(this.template)), type.ordinal());
    }

    public final IAlleleFruit getNoFruit() {
        return (IAlleleFruit)AlleleManager.alleleRegistry.getAllele("forestry.fruitNone");
    }

    public final IAlleleLeafEffect getNoEffect() {
        return (IAlleleLeafEffect)AlleleManager.alleleRegistry.getAllele("forestry.leavesNone");
    }

    public final IAlleleGrowth getLightGrowth() {
        return (IAlleleGrowth)AlleleManager.alleleRegistry.getAllele("forestry.growthLightlevel");
    }

    public final void addBreeding(TreeSpecies parent1, TreeSpecies parent2, int chance) {
        this.addBreeding((IAlleleTreeSpecies)parent1, (IAlleleTreeSpecies)parent2, chance);
    }

    public final void addBreeding(IAlleleTreeSpecies p1, IAlleleTreeSpecies p2, int chance) {
        if (!this.isRegistered) {
            throw new MisuseException("You must register a tree before adding breeding pairs!");
        }
        if (p1 == null || p2 == null) {
            throw new MisuseException("You cannot breed a tree from null!");
        }
        treeRoot.registerMutation((IMutation)new TreeBreeding(p1, p2, chance, this));
    }

    public final void addSuitableFruit(IFruitFamily fam) {
        if (fam == null) {
            throw new MisuseException("Null is not an acceptable fruit family!");
        }
        this.suitableFruits.add(fam);
    }

    public final ITree constructIndividual() {
        return treeRoot.templateAsIndividual(this.template);
    }

    public final void setLeaves(ITreeGenome genome, World world, GameProfile owner, int x, int y, int z, boolean decorative) {
        this.generator.setLeaves(genome, world, owner, x, y, z, decorative);
    }

    public final EnumTemperature getTemperature() {
        switch (this.getPlantType()) {
            case Cave: {
                return EnumTemperature.COLD;
            }
            case Desert: {
                return EnumTemperature.HOT;
            }
            case Nether: {
                return EnumTemperature.HELLISH;
            }
            case Beach: 
            case Plains: 
            case Water: 
            case Crop: {
                return EnumTemperature.NORMAL;
            }
        }
        return EnumTemperature.NONE;
    }

    public final EnumHumidity getHumidity() {
        switch (this.getPlantType()) {
            case Desert: 
            case Nether: {
                return EnumHumidity.ARID;
            }
            case Beach: 
            case Water: {
                return EnumHumidity.DAMP;
            }
        }
        return EnumHumidity.NORMAL;
    }

    public final Collection<IFruitFamily> getSuitableFruit() {
        return Collections.unmodifiableCollection(this.suitableFruits);
    }

    public final ITreeGenerator getGenerator() {
        return this.generator;
    }

    public abstract IAlleleFruit getFruitAllele();

    public abstract IAlleleLeafEffect getEffectAllele();

    public abstract IAlleleGrowth getGrowthAllele();

    public abstract TreeAlleleRegistry.Yield getYield();

    public abstract TreeAlleleRegistry.Heights getHeight();

    public abstract int getGirth();

    public abstract TreeAlleleRegistry.Sappiness getSappiness();

    public abstract TreeAlleleRegistry.Maturation getMaturation();

    public abstract TreeAlleleRegistry.Saplings getSaplingRate();

    public abstract BeeAlleleRegistry.Territory getTerritorySize();

    public abstract boolean isFireproof();

    protected final IAllele[] getSpeciesTemplate() {
        IAllele[] alleles = treeRoot.getDefaultTemplate();
        alleles[EnumTreeChromosome.SPECIES.ordinal()] = this;
        alleles[EnumTreeChromosome.FRUITS.ordinal()] = this.getFruitAllele();
        alleles[EnumTreeChromosome.YIELD.ordinal()] = this.getYield().getAllele();
        alleles[EnumTreeChromosome.MATURATION.ordinal()] = this.getMaturation().getAllele();
        alleles[EnumTreeChromosome.TERRITORY.ordinal()] = this.getTerritorySize().getAllele();
        alleles[EnumTreeChromosome.SAPPINESS.ordinal()] = this.getSappiness().getAllele();
        alleles[EnumTreeChromosome.HEIGHT.ordinal()] = this.getHeight().getAllele();
        alleles[EnumTreeChromosome.FERTILITY.ordinal()] = this.getSaplingRate().getAllele();
        alleles[EnumTreeChromosome.EFFECT.ordinal()] = this.getEffectAllele();
        alleles[EnumTreeChromosome.GIRTH.ordinal()] = ReikaBeeHelper.getIntegerAllele(this.getGirth());
        alleles[EnumTreeChromosome.PLANT.ordinal()] = ReikaBeeHelper.getAlleleForPlantType(this.getPlantType());
        alleles[EnumTreeChromosome.GROWTH.ordinal()] = this.getGrowthAllele();
        alleles[EnumTreeChromosome.FIREPROOF.ordinal()] = ReikaBeeHelper.getBooleanAllele(this.isFireproof());
        return alleles;
    }

    public final ITreeRoot getRoot() {
        return treeRoot;
    }

    @SideOnly(value=Side.CLIENT)
    public final IIconProvider getIconProvider() {
        return this;
    }

    public final void registerIcons(IIconRegister ico) {
        this.saplingIcon = ico.func_94245_a(this.getIconMod(false) + ":" + this.getIconFolderRoot(false) + "/" + this.getSaplingIconName());
        for (int i = 0; i < this.pollenIcons.length; ++i) {
            this.pollenIcons[i] = ico.func_94245_a(this.getIconMod(true) + ":" + this.getIconFolderRoot(true) + "/pollen." + i);
        }
    }

    protected String getIconMod(boolean pollen) {
        return "forestry";
    }

    protected String getIconFolderRoot(boolean pollen) {
        return "germlings";
    }

    protected String getSaplingIconName() {
        return "sapling." + this.uid.toLowerCase(Locale.ENGLISH);
    }

    public final IIcon getGermlingIcon(EnumGermlingType type, int renderPass) {
        switch (type) {
            case SAPLING: {
                return this.saplingIcon;
            }
            case POLLEN: {
                return this.pollenIcons[renderPass];
            }
        }
        return ReikaTextureHelper.getMissingIcon();
    }

    public int getComplexity() {
        return 0;
    }

    public float getResearchSuitability(ItemStack is) {
        return 0.0f;
    }

    public ItemStack[] getResearchBounty(World paramWorld, GameProfile f, IIndividual paramIIndividual, int paramInt) {
        return new ItemStack[0];
    }

    @SideOnly(value=Side.CLIENT)
    public final IIcon getIcon(short ps) {
        return ReikaTextureHelper.getMissingIcon();
    }

    protected abstract BlockKey getLogBlock(ITreeGenome var1, World var2, int var3, int var4, int var5, Random var6, ITreeGenData var7, ForgeDirection var8);

    protected abstract boolean generate(World var1, int var2, int var3, int var4, Random var5, ITreeGenData var6);

    public static interface NoLocaleDescriptionFruit {
        public String getDirectDescription();
    }

    public static abstract class TraitsTree
    extends TreeSpecies {
        protected final TreeTraits traits;

        protected TraitsTree(String name, String uid, String latinName, String creator, IClassification g, TreeTraits traits) {
            super(name, uid, latinName, creator, g);
            this.traits = traits;
        }

        public final EnumPlantType getPlantType() {
            return this.traits.plant;
        }

        @Override
        public final TreeAlleleRegistry.Yield getYield() {
            return this.traits.yield;
        }

        @Override
        public final TreeAlleleRegistry.Heights getHeight() {
            return this.traits.height;
        }

        @Override
        public final int getGirth() {
            return this.traits.girth;
        }

        @Override
        public final TreeAlleleRegistry.Sappiness getSappiness() {
            return this.traits.sappiness;
        }

        @Override
        public final TreeAlleleRegistry.Maturation getMaturation() {
            return this.traits.maturation;
        }

        @Override
        public final TreeAlleleRegistry.Saplings getSaplingRate() {
            return this.traits.fertility;
        }

        @Override
        public final BeeAlleleRegistry.Territory getTerritorySize() {
            return this.traits.area;
        }

        @Override
        public final boolean isFireproof() {
            return this.traits.isFireproof;
        }
    }

    public static abstract class BasicTreeSpecies
    extends TreeSpecies {
        protected BasicTreeSpecies(String name, String uid, String latinName, String creator, IClassification g) {
            super(name, uid, latinName, creator, g);
        }

        public EnumPlantType getPlantType() {
            return EnumPlantType.Plains;
        }

        @Override
        public IAlleleFruit getFruitAllele() {
            return this.getNoFruit();
        }

        @Override
        public IAlleleLeafEffect getEffectAllele() {
            return this.getNoEffect();
        }

        @Override
        public IAlleleGrowth getGrowthAllele() {
            return this.getLightGrowth();
        }

        @Override
        public boolean isFireproof() {
            return false;
        }

        public boolean hasEffect() {
            return false;
        }

        public boolean isSecret() {
            return false;
        }

        public boolean isCounted() {
            return true;
        }
    }

    private class ForestryTreeGenerator
    extends WorldGenerator
    implements ITreeGenerator {
        private ITreeGenData data;

        private ForestryTreeGenerator() {
        }

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            this.data = tree;
            return this;
        }

        public void setLogBlock(ITreeGenome genome, World world, int x, int y, int z, ForgeDirection facing) {
            BlockKey bk = TreeSpecies.this.getLogBlock(genome, world, x, y, z, TreeSpecies.this.rand, this.data, facing);
            if (bk != null) {
                bk.place(world, x, y, z);
            }
        }

        public void setLeaves(ITreeGenome genome, World world, GameProfile owner, int x, int y, int z, boolean decorative) {
            if (world.func_147449_b(x, y, z, ForestryHandler.BlockEntry.LEAF.getBlock())) {
                TileEntity te = world.func_147438_o(x, y, z);
                ReikaBeeHelper.setTree(te, TreeManager.treeRoot.getTree(world, genome));
                ReikaBeeHelper.setTreeOwner(te, owner);
                ReikaBeeHelper.setTreeLeafDecorative(te, decorative);
            }
        }

        public void setLogBlock(World world, int x, int y, int z, ForgeDirection facing) {
            this.setLogBlock(TreeManager.treeRoot.templateAsGenome(TreeSpecies.this.template), world, x, y, z, facing);
        }

        public void setLeaves(World world, GameProfile owner, int x, int y, int z, boolean decorative) {
            this.setLeaves(TreeManager.treeRoot.templateAsGenome(TreeSpecies.this.template), world, owner, x, y, z, decorative);
        }

        public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
            return TreeSpecies.this.generate(world, x, y, z, rand, this.data);
        }
    }

    private static final class TreeBreeding
    implements ITreeMutation {
        public final IAlleleTreeSpecies parent1;
        public final IAlleleTreeSpecies parent2;
        public final int chance;
        private final TreeSpecies tree;

        private TreeBreeding(IAlleleTreeSpecies p1, IAlleleTreeSpecies p2, int chance, TreeSpecies tree) {
            this.parent1 = p1;
            this.parent2 = p2;
            this.chance = chance;
            this.tree = tree;
        }

        public IAlleleSpecies getAllele0() {
            return this.parent1;
        }

        public IAlleleSpecies getAllele1() {
            return this.parent2;
        }

        public IAllele[] getTemplate() {
            return this.tree.template;
        }

        public float getBaseChance() {
            return this.chance;
        }

        public Collection getSpecialConditions() {
            return new ArrayList();
        }

        public boolean isPartner(IAllele ia) {
            return this.parent1.getUID().equals(ia.getUID()) || this.parent2.getUID().equals(ia.getUID());
        }

        public IAllele getPartner(IAllele ia) {
            IAlleleTreeSpecies val = this.parent1;
            if (val.getUID().equals(ia.getUID())) {
                val = this.parent2;
            }
            return val;
        }

        public boolean isSecret() {
            return this.tree.isSecret();
        }

        public ITreeRoot getRoot() {
            return this.tree.getRoot();
        }

        public final float getChance(World world, int x, int y, int z, IAlleleTreeSpecies ia1, IAlleleTreeSpecies ia2, ITreeGenome ig1, ITreeGenome ig2) {
            return this.isValidParents((IAllele)ia1, (IAllele)ia2) ? (float)this.chance : 0.0f;
        }

        private boolean isValidParents(IAllele ia1, IAllele ia2) {
            if (ia1.getUID().equals(this.parent1.getUID()) && ia2.getUID().equals(this.parent2.getUID())) {
                return true;
            }
            return ia1.getUID().equals(this.parent2.getUID()) && ia2.getUID().equals(this.parent1.getUID());
        }
    }

    public static class TreeBranch
    implements IClassification {
        public final String displayName;
        public final String description;
        private final String uid;
        private final String latinName;

        public TreeBranch(String id, String n, String latin, String desc) {
            this.displayName = n;
            this.description = desc;
            this.latinName = latin;
            this.uid = id;
        }

        public final IClassification.EnumClassLevel getLevel() {
            return IClassification.EnumClassLevel.GENUS;
        }

        public final String getUID() {
            return this.uid;
        }

        public final String getName() {
            return this.displayName;
        }

        public final String getScientific() {
            return this.latinName;
        }

        public final String getDescription() {
            return this.description;
        }

        public IClassification[] getMemberGroups() {
            return new IClassification[0];
        }

        public void addMemberGroup(IClassification icl) {
        }

        public IAlleleSpecies[] getMemberSpecies() {
            return new IAlleleSpecies[0];
        }

        public void addMemberSpecies(IAlleleSpecies ias) {
        }

        public IClassification getParent() {
            return null;
        }

        public void setParent(IClassification icl) {
        }
    }
}

