/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.DeepInteract;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Interfaces.Registry.RegistrationList;
import Reika.DragonAPI.Interfaces.Registry.RegistryEntry;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaRegistryHelper;
import com.creativemd.craftingmanager.api.utils.sorting.ItemSortingList;
import com.creativemd.craftingmanager.api.utils.sorting.SortingItem;
import com.creativemd.craftingmanager.api.utils.sorting.items.BlockSorting;
import com.creativemd.craftingmanager.api.utils.sorting.items.ItemSorting;
import com.creativemd.craftingmanager.api.utils.sorting.items.ItemStackSorting;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CraftingManagerBlacklisting {
    private static ItemSortingList blacklist;

    public static void registerItem(Item sort) {
        CraftingManagerBlacklisting.registerItem((SortingItem)new ItemSorting(sort));
    }

    public static void registerItem(Block sort) {
        CraftingManagerBlacklisting.registerItem((SortingItem)new BlockSorting(sort));
    }

    public static void registerItem(ItemStack sort) {
        CraftingManagerBlacklisting.registerItem((SortingItem)new ItemStackSorting(sort));
    }

    public static void registerItem(SortingItem sort) {
        blacklist.add((Object)sort);
    }

    static {
        try {
            Class<?> c = Class.forName("com.creativemd.craftingmanager.mod.CraftingManagerMod");
            Field f = c.getField("forbiddenOutputs");
            blacklist = (ItemSortingList)f.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class RegistrySorting
    extends SortingItem {
        public final Class<? extends RegistrationList> registryEnum;

        public RegistrySorting(Class<? extends RegistrationList> reg) {
            if (reg == null) {
                throw new MisuseException("You cannot block items from a null registry!");
            }
            this.registryEnum = reg;
        }

        protected boolean isObject(ItemStack stack) {
            RegistryEntry reg = ReikaRegistryHelper.getRegistryForObject(stack.func_77973_b());
            return reg != null && reg.getClass() == this.registryEnum;
        }
    }

    public static class ModSorting
    extends SortingItem {
        public final String modID;

        public ModSorting(DragonAPIMod mod) {
            String id;
            if (mod == null) {
                throw new MisuseException("You cannot block items from a null mod ID!");
            }
            this.modID = id = mod.getModContainer().getModId();
        }

        protected boolean isObject(ItemStack stack) {
            return ReikaItemHelper.isItemAddedByMod(stack.func_77973_b(), this.modID);
        }
    }
}

