/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.DeepInteract;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Instantiable.BasicModEntry;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import java.lang.reflect.Method;
import java.util.HashMap;

public class MantlePulsarHandler {
    private static boolean isLoaded;
    private static Method checkLoaded;
    private static final HashMap<Object, HashMap<String, Boolean>> cache;

    public static boolean isPulseLoaded(Object pulsar, String id) {
        Boolean flag;
        if (!isLoaded) {
            return false;
        }
        HashMap<String, Boolean> map = cache.get(pulsar);
        if (map == null) {
            map = new HashMap();
            cache.put(pulsar, map);
        }
        if ((flag = map.get(id)) == null) {
            flag = MantlePulsarHandler.readLoaded(pulsar, id);
            map.put(id, flag);
        }
        return flag;
    }

    private static boolean readLoaded(Object pulsar, String id) {
        try {
            return (Boolean)checkLoaded.invoke(pulsar, id);
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        cache = new HashMap();
        BasicModEntry mod = new BasicModEntry("Mantle");
        if (mod.isLoaded()) {
            try {
                Class<?> c = Class.forName("mantle.pulsar.control.PulseManager");
                checkLoaded = c.getMethod("isPulseLoaded", String.class);
                isLoaded = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)mod, e);
                isLoaded = false;
            }
        }
    }
}

