/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.DeepInteract;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import java.lang.reflect.Field;
import java.util.HashMap;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.AdvancedRocketryAPI;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;

public class PlanetDimensionHandler {
    private static HashMap<Integer, Object> advRDimensionData;

    public static boolean isOtherWorld(World world) {
        return PlanetDimensionHandler.isGalacticWorld(world) || PlanetDimensionHandler.isAdvRWorld(world);
    }

    public static boolean isGalacticWorld(World world) {
        return ModList.GALACTICRAFT.isLoaded() && InterfaceCache.IGALACTICWORLD.instanceOf(world.field_73011_w);
    }

    public static boolean isAdvRWorld(World world) {
        return ModList.ADVROCKET.isLoaded() && (InterfaceCache.IPLANETWORLD.instanceOf(world.field_73011_w) || advRDimensionData != null && advRDimensionData.keySet().contains(world.field_73011_w.field_76574_g));
    }

    public static float getExtraGravity(World world) {
        if (PlanetDimensionHandler.isGalacticWorld(world)) {
            return ((IGalacticraftWorldProvider)world.field_73011_w).getGravity();
        }
        if (PlanetDimensionHandler.isAdvRWorld(world)) {
            // empty if block
        }
        return 0.0f;
    }

    public static float getWindFactor(World world) {
        if (PlanetDimensionHandler.isGalacticWorld(world)) {
            return ((IGalacticraftWorldProvider)world.field_73011_w).getWindLevel();
        }
        if (PlanetDimensionHandler.isAdvRWorld(world)) {
            // empty if block
        }
        return 1.0f;
    }

    public static double getSunIntensity(World world) {
        if (PlanetDimensionHandler.isGalacticWorld(world)) {
            if (InterfaceCache.ISOLARLEVEL.instanceOf(world.field_73011_w)) {
                ISolarLevel isl = (ISolarLevel)world.field_73011_w;
                return isl.getSolarEnergyMultiplier();
            }
            return ((IGalacticraftWorldProvider)world.field_73011_w).getSolarSize();
        }
        if (PlanetDimensionHandler.isAdvRWorld(world)) {
            IDimensionProperties dim = AdvancedRocketryAPI.dimensionManager.getDimensionProperties(world.field_73011_w.field_76574_g);
            double peak = dim.getPeakInsolationMultiplier();
            double lim = Math.min(0.1, peak);
            if ((peak -= (double)(dim.getAtmosphereDensity() - 80) / 120.0) < lim) {
                peak = lim;
            }
            return peak;
        }
        return 1.0;
    }

    static {
        if (ModList.GALACTICRAFT.isLoaded()) {
            // empty if block
        }
        if (ModList.ADVROCKET.isLoaded()) {
            try {
                Class<?> c = Class.forName("zmaster587.advancedRocketry.dimension.DimensionManager");
                Field inst = c.getDeclaredField("instance");
                inst.setAccessible(true);
                Object ref = inst.get(null);
                Field f = c.getDeclaredField("dimensionList");
                f.setAccessible(true);
                advRDimensionData = (HashMap)f.get(ref);
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not load AdvR dimension manager!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.ADVROCKET, e);
            }
        }
    }
}

