/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Interfaces.Registry.CropHandler;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.Loader;
import forestry.api.arboriculture.ITree;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ForestryHandler
extends ModHandlerBase
implements CropHandler {
    private boolean init = false;
    private Field crateList;
    public final Block extraTreeLog;
    private static final ForestryHandler instance = new ForestryHandler();

    private ForestryHandler() {
        Block extra = null;
        if (this.hasMod()) {
            Class<?> c;
            Object reg;
            Field f;
            Class<?> c2;
            Enum ie;
            int i;
            for (i = 0; i < ItemEntry.list.length; ++i) {
                ie = ItemEntry.list[i];
                try {
                    c2 = Class.forName(((ItemEntry)ie).reg);
                    f = c2.getDeclaredField(((ItemEntry)ie).tag);
                    reg = ((ItemEntry)ie).getRegistryObject();
                    ((ItemEntry)ie).item = (Item)f.get(reg);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (NullPointerException e) {
                    DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                }
            }
            for (i = 0; i < BlockEntry.list.length; ++i) {
                ie = BlockEntry.list[i];
                try {
                    c2 = Class.forName(((BlockEntry)ie).reg);
                    f = c2.getDeclaredField(((BlockEntry)ie).tag);
                    reg = ((BlockEntry)ie).getRegistryObject();
                    ((BlockEntry)ie).item = (Block)f.get(reg);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (NullPointerException e) {
                    DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                }
            }
            try {
                c = Class.forName("forestry.plugins.PluginStorage");
                this.crateList = c.getDeclaredField("crates");
                this.crateList.setAccessible(true);
            }
            catch (ClassNotFoundException e) {
                DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            this.init = true;
            if (Loader.isModLoaded((String)"ExtraTrees")) {
                try {
                    c = Class.forName("binnie.extratrees.ExtraTrees");
                    Field f2 = c.getDeclaredField("blockLog");
                    f2.setAccessible(true);
                    extra = (Block)f2.get(null);
                }
                catch (ClassNotFoundException e) {
                    DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                }
                catch (NoSuchFieldException e) {
                    DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                }
                catch (IllegalArgumentException e) {
                    DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                }
                catch (IllegalAccessException e) {
                    DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                }
                catch (NullPointerException e) {
                    DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                    e.printStackTrace();
                    this.logFailure(e);
                }
            }
        } else {
            this.noMod();
        }
        this.extraTreeLog = extra;
    }

    public static ForestryHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.init;
    }

    @Override
    public ModList getMod() {
        return ModList.FORESTRY;
    }

    public Collection<Item> getAllCrates() {
        try {
            return Collections.unmodifiableCollection((Collection)this.crateList.get(null));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return new ArrayList<Item>();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return new ArrayList<Item>();
        }
    }

    public boolean isLog(Block b) {
        return b == BlockEntry.LOG.getBlock() || b == BlockEntry.FIRELOG.getBlock() || b != null && b == this.extraTreeLog;
    }

    @Override
    public int getHarvestedMeta(World world, int x, int y, int z) {
        return 0;
    }

    @Override
    public boolean isCrop(Block id, int meta) {
        return id == BlockEntry.LEAF.getBlock();
    }

    @Override
    public boolean isRipeCrop(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null && ReikaBeeHelper.hasFruit(te);
    }

    @Override
    public void makeRipe(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null) {
            ReikaBeeHelper.setTreeRipeness(te, -1);
        }
    }

    @Override
    public int getGrowthState(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null ? ReikaBeeHelper.getTreeRipeness(te) : 0;
    }

    @Override
    public boolean isSeedItem(ItemStack is) {
        return false;
    }

    @Override
    public ArrayList<ItemStack> getDropsOverride(World world, int x, int y, int z, Block id, int meta, int fortune) {
        ITree tree;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && (tree = ReikaBeeHelper.getTree(te)) != null) {
            ItemStack[] fruit;
            for (ItemStack is : fruit = tree.produceStacks(world, x, y, z, ReikaBeeHelper.getTreeRipeness(te))) {
                ret.add(is);
            }
        }
        return ret;
    }

    @Override
    public ArrayList<ItemStack> getAdditionalDrops(World world, int x, int y, int z, Block id, int meta, int fortune) {
        return null;
    }

    @Override
    public void editTileDataForHarvest(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null) {
            ReikaBeeHelper.setTreeRipeness(te, 0);
        }
    }

    @Override
    public boolean neverDropsSecondSeed() {
        return true;
    }

    @Override
    public boolean isTileEntity() {
        return true;
    }

    public static enum SoilType {
        HUMUS,
        BOG_EARTH,
        PEAT;


        public static SoilType getTypeFromMeta(int meta) {
            int type = meta & 3;
            int maturity = meta >> 2;
            if (type == 1) {
                if (maturity < 3) {
                    return BOG_EARTH;
                }
                return PEAT;
            }
            return HUMUS;
        }
    }

    public static enum Combs {
        HONEY(0),
        SIMMERING(2),
        STRINGY(3),
        FROZEN(4),
        DRIPPING(5),
        SILKY(6),
        PARCHED(7),
        MOSSY(15),
        MELLOW(16);

        public final int damageValue;

        private Combs(int dmg) {
            this.damageValue = dmg;
        }

        public ItemStack getItem() {
            return new ItemStack(ItemEntry.COMB.getItem(), 1, this.damageValue);
        }
    }

    public static enum CraftingMaterials {
        PULSEDUST,
        PULSEMESH,
        SILKWISP,
        WOVENSILK,
        DISSIPATION,
        ICESHARD,
        SCENTEDPANEL;


        public ItemStack getItem() {
            return new ItemStack(ItemEntry.CRAFTING.getItem(), 1, this.ordinal());
        }
    }

    public static enum BlockEntry {
        SAPLING("forestry.arboriculture.blocks.BlockRegistryArboriculture", "saplingGE"),
        LEAF("forestry.arboriculture.blocks.BlockRegistryArboriculture", "leaves"),
        LOG("forestry.arboriculture.blocks.BlockRegistryArboriculture", "logs"),
        FIRELOG("forestry.arboriculture.blocks.BlockRegistryArboriculture", "logsFireproof"),
        HIVE("forestry.apiculture.blocks.BlockRegistryApiculture", "beehives"),
        SOIL("forestry.core.blocks.BlockRegistryCore", "soil");

        private final String reg;
        private final String tag;
        private Block item;
        private static final BlockEntry[] list;

        private BlockEntry(String c, String id) {
            this.reg = c;
            this.tag = id;
        }

        public Block getBlock() {
            return this.item;
        }

        private Object getRegistryObject() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException, IllegalArgumentException {
            String n = this.reg.split("\\.")[1];
            n = ReikaStringParser.capFirstChar(n);
            n = "forestry.plugins.Plugin" + n;
            Class<?> c = Class.forName(n);
            Field f = c.getDeclaredField("blocks");
            f.setAccessible(true);
            return f.get(null);
        }

        static {
            list = BlockEntry.values();
        }
    }

    public static enum ItemEntry {
        APATITE("forestry.core.items.ItemRegistryCore", "apatite"),
        FERTILIZER("forestry.core.items.ItemRegistryCore", "fertilizerCompound"),
        SAPLING("forestry.arboriculture.items.ItemRegistryArboriculture", "sapling"),
        COMB("forestry.apiculture.items.ItemRegistryApiculture", "beeComb"),
        HONEY("forestry.apiculture.items.ItemRegistryApiculture", "honeyDrop"),
        HONEYDEW("forestry.apiculture.items.ItemRegistryApiculture", "honeydew"),
        JELLY("forestry.apiculture.items.ItemRegistryApiculture", "royalJelly"),
        PROPOLIS("forestry.apiculture.items.ItemRegistryApiculture", "propolis"),
        WAX("forestry.core.items.ItemRegistryCore", "beeswax"),
        REFWAX("forestry.core.items.ItemRegistryCore", "refractoryWax"),
        PHOSPHOR("forestry.core.items.ItemRegistryCore", "phosphor"),
        MULCH("forestry.core.items.ItemRegistryCore", "mulch"),
        PEAT("forestry.core.items.ItemRegistryCore", "peat"),
        ASH("forestry.core.items.ItemRegistryCore", "ash"),
        POLLEN("forestry.apiculture.items.ItemRegistryApiculture", "pollenCluster"),
        TREEPOLLEN("forestry.arboriculture.items.ItemRegistryArboriculture", "pollenFertile"),
        QUEEN("forestry.apiculture.items.ItemRegistryApiculture", "beeQueenGE"),
        PRINCESS("forestry.apiculture.items.ItemRegistryApiculture", "beePrincessGE"),
        DRONE("forestry.apiculture.items.ItemRegistryApiculture", "beeDroneGE"),
        LARVA("forestry.apiculture.items.ItemRegistryApiculture", "beeLarvaeGE"),
        BUTTERFLY("forestry.lepidopterology.items.ItemRegistryLepidopterology", "butterflyGE"),
        CATERPILLAR("forestry.lepidopterology.items.ItemRegistryLepidopterology", "caterpillarGE"),
        CRAFTING("forestry.core.items.ItemRegistryCore", "craftingMaterial"),
        BASICFRAME("forestry.apiculture.items.ItemRegistryApiculture", "frameUntreated"),
        IMPREGFRAME("forestry.apiculture.items.ItemRegistryApiculture", "frameImpregnated"),
        PROVENFRAME("forestry.apiculture.items.ItemRegistryApiculture", "frameProven");

        private final String reg;
        private final String tag;
        private Item item;
        private static final ItemEntry[] list;

        private ItemEntry(String c, String id) {
            this.reg = c;
            this.tag = id;
        }

        public Item getItem() {
            return this.item;
        }

        private Object getRegistryObject() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException, IllegalArgumentException {
            String n = this.reg.split("\\.")[1];
            n = ReikaStringParser.capFirstChar(n);
            n = "forestry.plugins.Plugin" + n;
            Class<?> c = Class.forName(n);
            Field f = c.getDeclaredField("items");
            f.setAccessible(true);
            return f.get(null);
        }

        static {
            list = ItemEntry.values();
        }
    }
}

