/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.Loader;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class IC2Handler
extends ModHandlerBase {
    private static final IC2Handler instance = new IC2Handler();
    private boolean init = false;

    private IC2Handler() {
        if (this.hasMod()) {
            Field f;
            Enum s;
            int i;
            Class ic2 = this.getMod().getItemClass();
            boolean exc = false;
            for (i = 0; i < IC2Stacks.list.length; ++i) {
                s = IC2Stacks.list[i];
                try {
                    f = ic2.getField(((IC2Stacks)s).tag);
                    ((IC2Stacks)s).stack = (ItemStack)f.get(null);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                    exc = true;
                    continue;
                }
                catch (SecurityException e) {
                    DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                    exc = true;
                    continue;
                }
                catch (IllegalArgumentException e) {
                    DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                    exc = true;
                    continue;
                }
                catch (IllegalAccessException e) {
                    DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                    exc = true;
                    continue;
                }
                catch (NullPointerException e) {
                    DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                    e.printStackTrace();
                    this.logFailure(e);
                    exc = true;
                }
            }
            for (i = 0; i < IC2Ores.list.length; ++i) {
                s = IC2Ores.list[i];
                try {
                    f = ic2.getField(((IC2Ores)s).tag);
                    ((IC2Ores)s).oreBlock = Block.func_149634_a((Item)((ItemStack)f.get(null)).func_77973_b());
                    continue;
                }
                catch (NoSuchFieldException e) {
                    DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                    exc = true;
                    continue;
                }
                catch (SecurityException e) {
                    DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                    exc = true;
                    continue;
                }
                catch (IllegalArgumentException e) {
                    DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                    exc = true;
                    continue;
                }
                catch (IllegalAccessException e) {
                    DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                    exc = true;
                    continue;
                }
                catch (NullPointerException e) {
                    DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                    e.printStackTrace();
                    this.logFailure(e);
                    exc = true;
                }
            }
            this.init = !exc;
        } else {
            this.noMod();
        }
    }

    public static IC2Handler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.init;
    }

    @Override
    public ModList getMod() {
        return ModList.IC2;
    }

    public boolean isIC2Classic() {
        return ModList.IC2.getRegisteredName().equals("Industrial Craft Classic") || Loader.isModLoaded((String)"IC2-Classic-Spmod");
    }

    public static enum IC2Stacks {
        PURECRUSHEDU("purifiedCrushedUraniumOre"),
        ENERGIUM("energiumDust"),
        ADVANCEDALLOY("advancedAlloy"),
        LAPOTRON("lapotronCrystal"),
        CARBONFIBER("carbonPlate"),
        IRIDPLATE("iridiumPlate"),
        RUBBER("rubber"),
        RESIN("resin"),
        SCRAP("scrap"),
        SCRAPBOX("scrapBox"),
        IRIDIUM("iridiumOre"),
        BRONZEPICK("bronzePickaxe"),
        BRONZEAXE("bronzeAxe"),
        BRONZESWORD("bronzeSword"),
        BRONZESHOVEL("bronzeShovel"),
        BRONZEHOE("bronzeHoe"),
        BRONZEHELMET("bronzeHelmet"),
        BRONZECHESTPLATE("bronzeChestplate"),
        BRONZELEGGINGS("bronzeLeggings"),
        BRONZEBOOTS("bronzeBoots"),
        BIOCHAFF("biochaff"),
        PLANTBALL("plantBall"),
        U235("Uran235"),
        U238("Uran238"),
        Pu239("Plutonium"),
        U235_TINY("smallUran235"),
        Pu239_TINY("smallPlutonium"),
        FUEL("UranFuel"),
        MOX("MOXFuel"),
        FUELROD("reactorUraniumSimple"),
        FUELROD2("reactorUraniumDual"),
        FUELROD4("reactorUraniumQuad"),
        DEPLETEDROD("reactorDepletedUraniumSimple"),
        DEPLETEDROD2("reactorDepletedUraniumDual"),
        DEPLETEDROD4("reactorDepletedUraniumQuad"),
        MOXROD("reactorMOXSimple"),
        MOXROD2("reactorMOXDual"),
        MOXROD4("reactorMOXQuad"),
        DEPLETEDMOXROD("reactorDepletedMOXSimple"),
        DEPLETEDMOXROD2("reactorDepletedMOXDual"),
        DEPLETEDMOXROD4("reactorDepletedMOXQuad"),
        REFLECTOR("reactorReflector"),
        DENSEREFLECTOR("reactorReflectorThick"),
        REFINEDIRON("advIronIngot"),
        OVERCLOCK("overclockerUpgrade"),
        TRANSFORMER("transformerUpgrade"),
        CAPACITY("energyStorageUpgrade"),
        RSH("reactorCondensator"),
        LZH("reactorCondensatorLap"),
        VENT("reactorVent"),
        REACVENT("reactorVentCore"),
        ADVENT("reactorVentDiamond"),
        OVERVENT("reactorVentGold"),
        CASTING("machine"),
        ADVCASING("advancedMachine"),
        COOLANT6("reactorCoolantSix");

        private final String tag;
        private ItemStack stack;
        private static final IC2Stacks[] list;

        private IC2Stacks(String s) {
            this.tag = s;
        }

        public ItemStack getItem() {
            return this.stack != null ? this.stack.func_77946_l() : null;
        }

        public boolean match(ItemStack is) {
            return ReikaItemHelper.matchStacks(is, this.stack);
        }

        static {
            list = IC2Stacks.values();
        }
    }

    public static enum IC2Cables {
        INSCOPPER,
        COPPER,
        GOLD,
        INSGOLD,
        UNUSED,
        HV,
        INSHV,
        UNUSED2,
        UNUSED3,
        FIBER,
        TIN,
        DETECTOR,
        SPLITTER,
        INSTIN;


        public ItemStack getItem() {
            return ReikaItemHelper.lookupItem("IC2:itemCable:" + this.ordinal());
        }
    }

    public static enum IC2Materials {
        COPPER,
        TIN,
        BRONZE,
        GOLD,
        IRON,
        REFIRON,
        LEAD,
        OBSIDIAN,
        LAPIS;


        public ItemStack getDensePlate() {
            return ReikaItemHelper.lookupItem("IC2:itemDensePlates:" + this.ordinal());
        }

        public ItemStack getPlate() {
            return ReikaItemHelper.lookupItem("IC2:itemPlates:" + this.ordinal());
        }

        public ItemStack getCasing() {
            return this == OBSIDIAN || this == LAPIS ? null : ReikaItemHelper.lookupItem("IC2:itemCasing:" + this.ordinal());
        }
    }

    public static enum IC2Ores {
        COPPER("copperOre"),
        TIN("tinOre"),
        LEAD("leadOre"),
        URANIUM("uraniumOre");

        private final String tag;
        private Block oreBlock;
        private static final IC2Ores[] list;

        private IC2Ores(String s) {
            this.tag = s;
        }

        public Block getBlock() {
            return this.oreBlock;
        }

        static {
            list = IC2Ores.values();
        }
    }
}

