/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.enchantment.Enchantment;
import thaumcraft.api.ThaumcraftApi;

public class InfusionEnchantmentHandler {
    public static final InfusionEnchantmentHandler instance = new InfusionEnchantmentHandler();
    private final MultiMap<ModEntry, Enchantment> enchantments = new MultiMap();

    private InfusionEnchantmentHandler() {
        if (ModList.THAUMCRAFT.isLoaded()) {
            this.loadThaumcraft();
        }
        if (ModList.THAUMICTINKER.isLoaded()) {
            this.loadTTinkerer();
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    private void loadThaumcraft() {
        this.registerEnchant(ModList.THAUMCRAFT, Enchantment.field_77331_b[ThaumcraftApi.enchantFrugal]);
        this.registerEnchant(ModList.THAUMCRAFT, Enchantment.field_77331_b[ThaumcraftApi.enchantHaste]);
        this.registerEnchant(ModList.THAUMCRAFT, Enchantment.field_77331_b[ThaumcraftApi.enchantPotency]);
        this.registerEnchant(ModList.THAUMCRAFT, Enchantment.field_77331_b[ThaumcraftApi.enchantRepair]);
        this.registerEnchant(ModList.THAUMCRAFT, Enchantment.field_77331_b[ThaumcraftApi.enchantWandFortune]);
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMICTINKER})
    private void loadTTinkerer() {
        try {
            Field[] fd;
            Class<?> c = Class.forName("thaumic.tinkerer.common.enchantment.ModEnchantments");
            for (Field f : fd = c.getDeclaredFields()) {
                if ((f.getModifiers() & 8) == 0 || f.getType() != Enchantment.class) continue;
                this.registerEnchant(ModList.THAUMICTINKER, (Enchantment)f.get(null));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void registerEnchant(ModList mod, Enchantment e) {
        if (e.field_77352_x == 0) {
            return;
        }
        if (ReikaEnchantmentHelper.isVanillaEnchant(e)) {
            DragonAPICore.logError("Detected a ThaumCraft enchantment registered to ID " + e.field_77352_x + ", overwriting a vanilla ID!");
            return;
        }
        this.enchantments.addValue(mod, e);
    }

    public boolean isInfusionEnchantment(Enchantment e) {
        return this.enchantments.containsValue(e);
    }

    public Collection<Enchantment> getEnchantmentsFor(ModEntry mod) {
        return Collections.unmodifiableCollection(this.enchantments.get(mod));
    }
}

