/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.Power;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class ReikaRailCraftHelper
extends DragonAPICore {
    private static Class sharedClass;
    private static Class solidClass;
    private static Class fluidClass;
    private static Field boiler;
    private static Field boilerBurnTime;
    private static Field boilerHeat;
    private static Field boilerBurning;
    private static final Fluid STEAM;

    public static boolean doesRailCraftExist() {
        return ModList.RAILCRAFT.isLoaded();
    }

    public static double getSteamEnergy(int Tinit, int mB) {
        return ReikaRailCraftHelper.getSteamBoilingEnergy(mB) + ReikaRailCraftHelper.getSteamBucketEnergyToHeat(Tinit, mB);
    }

    public static double getSteamBoilingEnergy(int mB) {
        return 2260.0 * (double)mB * 1000.0;
    }

    public static double getSteamBucketEnergyToHeat(int Tinit, int mB) {
        double dT = 100 - Tinit;
        if (dT < 0.0) {
            dT = 0.0;
        }
        return 4.18 * (double)mB * 1000.0 * dT;
    }

    public static int getAmountConvertibleSteam(int Tinit, long energy) {
        double per = ReikaRailCraftHelper.getSteamEnergy(Tinit, 1);
        return (int)((double)energy / per);
    }

    public static boolean isFirebox(TileEntity te) {
        return te != null && sharedClass.isAssignableFrom(te.getClass());
    }

    public static boolean isSolidFirebox(TileEntity te) {
        return te != null && solidClass == te.getClass();
    }

    public static boolean isFluidFirebox(TileEntity te) {
        return te != null && fluidClass == te.getClass();
    }

    static {
        STEAM = FluidRegistry.getFluid((String)"steam");
        if (ModList.RAILCRAFT.isLoaded()) {
            try {
                sharedClass = Class.forName("mods.railcraft.common.blocks.machine.beta.TileBoilerFirebox");
                boiler = sharedClass.getDeclaredField("boiler");
                boiler.setAccessible(true);
                solidClass = Class.forName("mods.railcraft.common.blocks.machine.beta.TileBoilerFireboxSolid");
                fluidClass = Class.forName("mods.railcraft.common.blocks.machine.beta.TileBoilerFireboxFluid");
                Class<?> c2 = Class.forName("mods.railcraft.common.util.steam.SteamBoiler");
                boilerBurnTime = c2.getDeclaredField("burnTime");
                boilerBurnTime.setAccessible(true);
                boilerHeat = c2.getDeclaredField("heat");
                boilerHeat.setAccessible(true);
                boilerBurning = c2.getDeclaredField("isBurning");
                boilerBurning.setAccessible(true);
            }
            catch (Exception e) {
                DragonAPICore.logError("Error loading Firebox Handling!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.RAILCRAFT, e);
            }
        }
    }

    public static class FireboxWrapper {
        private final long tileID;
        public double temperature;
        private boolean isBurning;
        private double burnTime;

        public FireboxWrapper(TileEntity te) {
            if (!ReikaRailCraftHelper.isFirebox(te)) {
                throw new MisuseException("Tile is not a firebox!");
            }
            this.tileID = System.identityHashCode(te);
            this.load(te);
        }

        public void load(TileEntity te) {
            if ((long)System.identityHashCode(te) != this.tileID) {
                throw new MisuseException("You cannot reuse a FireboxWrapper instance for different TileEntities!");
            }
            try {
                Object obj = boiler.get(te);
                this.temperature = boilerHeat.getDouble(obj);
                this.burnTime = boilerBurnTime.getDouble(obj);
                this.isBurning = boilerBurning.getBoolean(obj);
            }
            catch (Exception e) {
                DragonAPICore.logError("Error running Firebox Handling!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.RAILCRAFT, e);
            }
        }

        public void setBurning(int ticks) {
            this.isBurning = true;
            this.burnTime = Math.max((double)ticks, this.burnTime);
        }

        public void write(TileEntity te) {
            if ((long)System.identityHashCode(te) != this.tileID) {
                throw new MisuseException("You cannot reuse a FireboxWrapper instance for different TileEntities!");
            }
            try {
                Object obj = boiler.get(te);
                boilerHeat.setDouble(obj, this.temperature);
                boilerBurning.setBoolean(obj, this.isBurning);
                boilerBurnTime.setDouble(obj, this.burnTime);
            }
            catch (Exception e) {
                DragonAPICore.logError("Error running Firebox Handling!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.RAILCRAFT, e);
            }
        }
    }
}

