/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.RecipeHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Collections.ChancedOutputList;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.api.recipes.RecipeManagers;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class ForestryRecipeHelper
extends ModHandlerBase {
    private static final ForestryRecipeHelper instance = new ForestryRecipeHelper();
    private final ItemHashMap<ChancedOutputList> centrifuge = new ItemHashMap();
    private final ItemHashMap<ISqueezerRecipe> squeezer = new ItemHashMap();
    private final ItemHashMap<IFermenterRecipe> fermenter = new ItemHashMap();
    private Field centrifugeOutputs;
    private Method addFermenter;
    private Enum[] fluids;

    public static final ForestryRecipeHelper getInstance() {
        return instance;
    }

    private ForestryRecipeHelper() {
        if (this.hasMod()) {
            if (!Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
                throw new MisuseException("You cannot load other mod's machine recipes before postload!");
            }
            try {
                Collection c = RecipeManagers.centrifugeManager.recipes();
                for (Object r : c) {
                    ItemStack in = r.getInput();
                    ChancedOutputList outputs = new ChancedOutputList(false);
                    Map out = r.getAllProducts();
                    for (ItemStack is : out.keySet()) {
                        float chance = ((Float)out.get(is)).floatValue() * 100.0f;
                        for (int i = 0; i < is.field_77994_a; ++i) {
                            outputs.addItem(ReikaItemHelper.getSizedItemStack(is, 1), chance);
                        }
                    }
                    this.centrifuge.put(in, outputs);
                }
                Class<?> cl = Class.forName("forestry.factory.recipes.CentrifugeRecipe");
                this.centrifugeOutputs = cl.getDeclaredField("outputs");
                this.centrifugeOutputs.setAccessible(true);
                for (ItemStack in : RecipeManagers.squeezerManager.recipes()) {
                    ItemStack[] items = in.getResources();
                    if (items.length != 1 || FluidContainerRegistry.isFilledContainer((ItemStack)items[0])) continue;
                    this.squeezer.put(items[0], (ISqueezerRecipe)in);
                }
                for (ItemStack in : RecipeManagers.fermenterManager.recipes()) {
                    this.fermenter.put(in.getResource(), (IFermenterRecipe)in);
                }
                Class<?> fluids = Class.forName("forestry.core.fluids.Fluids");
                this.fluids = (Enum[])fluids.getEnumConstants();
                Class<?> util = Class.forName("forestry.core.recipes.RecipeUtil");
                this.addFermenter = util.getDeclaredMethod("addFermenterRecipes", ItemStack.class, Integer.TYPE, fluids);
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not initialize Forestry recipe helper!");
                e.printStackTrace();
            }
        } else {
            this.noMod();
        }
    }

    public Collection<ItemStack> getCentrifugeRecipes() {
        return this.centrifuge.keySet();
    }

    public Collection<ItemStack> getSqueezerRecipes() {
        return this.squeezer.keySet();
    }

    public Collection<ItemStack> getFermenterRecipes() {
        return this.fermenter.keySet();
    }

    public ChancedOutputList getCentrifugeOutput(ItemStack in) {
        return this.centrifuge.get(in).copy();
    }

    public ISqueezerRecipe getSqueezerOutput(ItemStack in) {
        return this.squeezer.get(in);
    }

    public IFermenterRecipe getFermenterOutput(ItemStack in) {
        return this.fermenter.get(in);
    }

    @Override
    public boolean initializedProperly() {
        return !this.centrifuge.isEmpty() && !this.squeezer.isEmpty();
    }

    @Override
    public ModList getMod() {
        return ModList.FORESTRY;
    }

    public void addStandardFermenterRecipes(ItemStack resource, int fermentationValue) {
        try {
            Object f = this.getFluidByName("biomass");
            this.addFermenter.invoke(null, resource, fermentationValue, f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getFluidByName(String s) {
        for (Enum e : this.fluids) {
            if (!e.name().equalsIgnoreCase(s)) continue;
            return e;
        }
        return null;
    }
}

