/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.RecipeHandlers;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerBlockHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerToolHandler;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class SmelteryRecipeHandler {
    public static final int INGOT_AMOUNT = 144;
    private static boolean isLoaded;
    private static Method addMelting;
    private static Method addCasting;
    private static Method addBlockCasting;
    private static Method getAllRecipes;
    private static Method addAlloying;
    private static Object castingInstance;
    private static Object castingBasinInstance;
    private static Object smelteryInstance;
    private static Class castingRecipe;
    private static Field recipeOutput;
    private static Field recipeFluid;
    private static Field recipeCast;

    public static void addIngotMelting(ItemStack ingot, ItemStack render, int temp, String fluid) {
        SmelteryRecipeHandler.addMelting(ingot, render, temp, 144, fluid);
    }

    public static void addIngotMelting(ItemStack ingot, ItemStack render, int temp, Fluid fluid) {
        SmelteryRecipeHandler.addMelting(ingot, render, temp, 144, fluid);
    }

    public static void addMelting(ItemStack is, ItemStack render, int temp, int fluidAmount, String fluid) {
        SmelteryRecipeHandler.addMelting(is, render, temp, fluidAmount, FluidRegistry.getFluid((String)fluid));
    }

    public static void addMelting(ItemStack is, ItemStack render, int temp, int fluidAmount, Fluid fluid) {
        if (fluid == null) {
            throw new MisuseException("You cannot melt items into a null fluid!");
        }
        SmelteryRecipeHandler.addMelting(is, render, temp, new FluidStack(fluid, fluidAmount));
    }

    public static void addBlockMelting(ItemStack is, int temp, Fluid fluid) {
        if (fluid == null) {
            throw new MisuseException("You cannot melt items into a null fluid!");
        }
        SmelteryRecipeHandler.addMelting(is, is, temp, new FluidStack(fluid, 1296));
    }

    public static void addMelting(ItemStack is, ItemStack render, int temp, FluidStack fluid) {
        Block b = Block.func_149634_a((Item)render.func_77973_b());
        if (!(render.func_77973_b() instanceof ItemBlock) || b == Blocks.field_150350_a) {
            throw new MisuseException("The render block must be a non-null block!");
        }
        if (!isLoaded) {
            return;
        }
        try {
            addMelting.invoke(smelteryInstance, is, b, render.func_77960_j(), temp, fluid);
            DragonAPICore.log("Adding smeltery melting of " + is + " into " + SmelteryRecipeHandler.fluidToString(fluid) + ".");
        }
        catch (Exception e) {
            DragonAPICore.logError("Could not add Smeltery Recipe for " + is + " to " + SmelteryRecipeHandler.fluidToString(fluid) + " @ " + temp + "!");
            e.printStackTrace();
        }
    }

    public static void addIngotCasting(ItemStack out, String fluid, int delay) {
        SmelteryRecipeHandler.addCasting(TinkerToolHandler.getInstance().getIngotCast(), out, FluidRegistry.getFluid((String)fluid), 144, delay);
    }

    public static void addIngotCasting(ItemStack out, Fluid fluid, int delay) {
        SmelteryRecipeHandler.addCasting(TinkerToolHandler.getInstance().getIngotCast(), out, fluid, 144, delay);
    }

    public static void addCasting(ItemStack cast, ItemStack out, String fluid, int fluidAmount, int delay) {
        SmelteryRecipeHandler.addCasting(cast, out, FluidRegistry.getFluid((String)fluid), fluidAmount, delay);
    }

    public static void addCasting(ItemStack cast, ItemStack out, Fluid fluid, int fluidAmount, int delay) {
        if (fluid == null) {
            throw new MisuseException("You cannot cast items from a null fluid!");
        }
        SmelteryRecipeHandler.addCasting(cast, out, new FluidStack(fluid, fluidAmount), delay);
    }

    public static void addCasting(ItemStack cast, ItemStack out, FluidStack in, int delay) {
        SmelteryRecipeHandler.addCasting(cast, out, in, delay, true);
    }

    public static void addCasting(ItemStack cast, ItemStack out, FluidStack in, int delay, boolean addCastRecipe) {
        if (!isLoaded) {
            return;
        }
        try {
            addCasting.invoke(castingInstance, out, in, cast, delay);
            if (addCastRecipe) {
                addCasting.invoke(castingInstance, cast, SmelteryRecipeHandler.getCastFluid(), out, delay / 2);
            }
            DragonAPICore.log("Adding casting of " + SmelteryRecipeHandler.fluidToString(in) + " to " + out + " with " + cast + ".");
        }
        catch (Exception e) {
            DragonAPICore.logError("Could not add Casting Recipe for " + SmelteryRecipeHandler.fluidToString(in) + " to " + out + " with " + cast + "!");
            e.printStackTrace();
        }
    }

    public static void addReversibleCasting(ItemStack cast, ItemStack out, ItemStack render, int temp, FluidStack fluid, int delay) {
        SmelteryRecipeHandler.addCasting(cast, out, fluid, delay);
        SmelteryRecipeHandler.addMelting(out, render, temp, fluid);
    }

    public static void addReversibleCasting(ItemStack cast, ItemStack out, ItemStack render, int temp, Fluid fluid, int fluidAmount, int delay) {
        SmelteryRecipeHandler.addCasting(cast, out, fluid, fluidAmount, delay);
        SmelteryRecipeHandler.addMelting(out, render, temp, fluidAmount, fluid);
    }

    public static void addReversibleCasting(ItemStack cast, ItemStack out, ItemStack render, int temp, String fluid, int fluidAmount, int delay) {
        SmelteryRecipeHandler.addCasting(cast, out, fluid, fluidAmount, delay);
        SmelteryRecipeHandler.addMelting(out, render, temp, fluidAmount, fluid);
    }

    public static void addBlockCasting(ItemStack block, int fluidAmount, String fluid, int delay) {
        SmelteryRecipeHandler.addBlockCasting(block, fluidAmount, FluidRegistry.getFluid((String)fluid), delay);
    }

    public static void addBlockCasting(ItemStack block, int fluidAmount, Fluid fluid, int delay) {
        if (fluid == null) {
            throw new MisuseException("You cannot cast blocks from a null fluid!");
        }
        SmelteryRecipeHandler.addBlockCasting(block, new FluidStack(fluid, fluidAmount), delay);
    }

    public static void addBlockCasting(ItemStack block, Fluid fluid, int delay) {
        if (fluid == null) {
            throw new MisuseException("You cannot cast blocks from a null fluid!");
        }
        SmelteryRecipeHandler.addBlockCasting(block, new FluidStack(fluid, 1296), delay);
    }

    public static void addBlockCasting(ItemStack block, FluidStack fluid, int delay) {
        if (!(block.func_77973_b() instanceof ItemBlock)) {
            throw new MisuseException("You cannot cast a non-block as a block!");
        }
        if (!isLoaded) {
            return;
        }
        try {
            addBlockCasting.invoke(castingBasinInstance, block, fluid, delay);
            DragonAPICore.log("Adding block casting of " + SmelteryRecipeHandler.fluidToString(fluid) + " to " + block + ".");
        }
        catch (Exception e) {
            DragonAPICore.logError("Could not add Block Casting Recipe for " + SmelteryRecipeHandler.fluidToString(fluid) + " to " + block + "!");
            e.printStackTrace();
        }
    }

    public static void addAlloying(FluidStack out, FluidStack ... in) {
        if (!isLoaded) {
            return;
        }
        try {
            addAlloying.invoke(smelteryInstance, out, in);
            DragonAPICore.log("Adding alloying of " + Arrays.toString(in) + " to " + SmelteryRecipeHandler.fluidToString(out) + ".");
        }
        catch (Exception e) {
            DragonAPICore.logError("Could not add alloying of " + Arrays.toString(in) + " to " + SmelteryRecipeHandler.fluidToString(out) + ".");
            e.printStackTrace();
        }
    }

    public static List getCastingRecipes() {
        if (!isLoaded) {
            return null;
        }
        try {
            List li = (List)getAllRecipes.invoke(castingInstance, new Object[0]);
            return li;
        }
        catch (Exception e) {
            DragonAPICore.logError("Could not fetch TiC Casting Recipes!");
            e.printStackTrace();
            return null;
        }
    }

    public static List getBlockCastingRecipes() {
        if (!isLoaded) {
            return null;
        }
        try {
            List li = (List)getAllRecipes.invoke(castingBasinInstance, new Object[0]);
            return li;
        }
        catch (Exception e) {
            DragonAPICore.logError("Could not fetch TiC Casting Recipes!");
            e.printStackTrace();
            return null;
        }
    }

    public static ItemStack getRecipeOutput(Object recipe) {
        if (!isLoaded) {
            return null;
        }
        if (recipe == null || recipe.getClass() != castingRecipe) {
            throw new MisuseException("You cannot get the output for a null or non-recipe!");
        }
        try {
            return (ItemStack)recipeOutput.get(recipe);
        }
        catch (Exception e) {
            DragonAPICore.logError("Could not fetch TiC Casting Recipe output!");
            e.printStackTrace();
            return null;
        }
    }

    public static FluidStack getRecipeFluid(Object recipe) {
        if (!isLoaded) {
            return null;
        }
        if (recipe == null || recipe.getClass() != castingRecipe) {
            throw new MisuseException("You cannot get the fluid for a null or non-recipe!");
        }
        try {
            return (FluidStack)recipeFluid.get(recipe);
        }
        catch (Exception e) {
            DragonAPICore.logError("Could not fetch TiC Casting Recipe fluid!");
            e.printStackTrace();
            return null;
        }
    }

    public static ItemStack getRecipeCast(Object recipe) {
        if (!isLoaded) {
            return null;
        }
        if (recipe == null || recipe.getClass() != castingRecipe) {
            throw new MisuseException("You cannot get the cast for a null or non-recipe!");
        }
        try {
            return (ItemStack)recipeCast.get(recipe);
        }
        catch (Exception e) {
            DragonAPICore.logError("Could not fetch TiC Casting Recipe cast!");
            e.printStackTrace();
            return null;
        }
    }

    private static String fluidToString(FluidStack fs) {
        return fs.amount + " mB of " + fs.getLocalizedName();
    }

    private static FluidStack getCastFluid() {
        Fluid f = FluidRegistry.getFluid((String)"aluminiumbrass.molten");
        if (f == null) {
            f = FluidRegistry.getFluid((String)"aluminumbrass.molten");
        }
        if (f == null) {
            f = FluidRegistry.getFluid((String)"liquid_alubrass");
        }
        if (f == null) {
            f = FluidRegistry.getFluid((String)"fluid.molten.alubrass");
        }
        return new FluidStack(f, 144);
    }

    static {
        if (ModList.TINKERER.isLoaded() && TinkerBlockHandler.Pulses.SMELTERY.isLoaded()) {
            try {
                Class<?> reg = Class.forName("tconstruct.library.TConstructRegistry");
                Method getTableCasting = reg.getMethod("getTableCasting", new Class[0]);
                Method getBasinCasting = reg.getMethod("getBasinCasting", new Class[0]);
                castingInstance = getTableCasting.invoke(null, new Object[0]);
                castingBasinInstance = getBasinCasting.invoke(null, new Object[0]);
                Class<?> smeltery = Class.forName("tconstruct.library.crafting.Smeltery");
                Field inst = smeltery.getField("instance");
                smelteryInstance = inst.get(null);
                addMelting = smeltery.getMethod("addMelting", ItemStack.class, Block.class, Integer.TYPE, Integer.TYPE, FluidStack.class);
                addAlloying = smeltery.getMethod("addAlloyMixing", FluidStack.class, FluidStack[].class);
                Class<?> casting = Class.forName("tconstruct.library.crafting.LiquidCasting");
                addCasting = casting.getMethod("addCastingRecipe", ItemStack.class, FluidStack.class, ItemStack.class, Integer.TYPE);
                addBlockCasting = casting.getMethod("addCastingRecipe", ItemStack.class, FluidStack.class, Integer.TYPE);
                getAllRecipes = casting.getMethod("getCastingRecipes", new Class[0]);
                castingRecipe = Class.forName("tconstruct.library.crafting.CastingRecipe");
                recipeOutput = castingRecipe.getField("output");
                recipeFluid = castingRecipe.getField("castingMetal");
                recipeCast = castingRecipe.getField("cast");
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not load Smeltery Recipe Handler!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.TINKERER, e);
            }
            isLoaded = true;
        } else {
            isLoaded = false;
        }
    }
}

