/*
 * Decompiled with CFR 0.152.
 */
package Reika.LootTweaks.API;

import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;

public class LootViewer {
    private final ArrayList<LootItem> data = new ArrayList();
    public final String location;

    public LootViewer(String s, WeightedRandomChestContent[] li) {
        this(s, ReikaJavaLibrary.makeListFromArray(li));
    }

    public LootViewer(String s, ArrayList<WeightedRandomChestContent> li) {
        for (WeightedRandomChestContent wr : li) {
            this.data.add(new LootItem(wr, this.calculateChance(wr, li)));
        }
        this.location = s;
    }

    private float calculateChance(WeightedRandomChestContent wr, ArrayList<WeightedRandomChestContent> li) {
        float sum = 0.0f;
        for (WeightedRandomChestContent wc : li) {
            sum += (float)wc.field_76292_a;
        }
        return (float)wr.field_76292_a / sum * 100.0f;
    }

    public Collection<LootItem> getLoot() {
        return Collections.unmodifiableCollection(this.data);
    }

    public static class LootItem {
        private final WeightedRandomChestContent item;
        public final float netChance;

        private LootItem(WeightedRandomChestContent wr, float f) {
            this.item = wr;
            this.netChance = f;
        }

        public ItemStack getItem() {
            try {
                return this.item.field_76297_b.func_77946_l();
            }
            catch (Exception e) {
                try {
                    return new ItemStack(this.item.field_76297_b.func_77973_b(), 1, this.item.field_76297_b.func_77960_j());
                }
                catch (Exception e2) {
                    return new ItemStack((Block)Blocks.field_150349_c);
                }
            }
        }

        public int[] getStackSizeRange() {
            if (this.item.field_76295_d == this.item.field_76296_e) {
                return new int[]{this.item.field_76295_d};
            }
            return new int[]{this.item.field_76295_d, this.item.field_76296_e};
        }

        public int getWeight() {
            return this.item.field_76292_a;
        }
    }
}

